/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.provider;

import android.annotation.TargetApi;
import android.graphics.Outline;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewOutlineProvider;

@TargetApi(value=21)
public class OvalViewOutlineProvider
extends ViewOutlineProvider {
    public void getOutline(View view, Outline outline) {
        Rect ovalRect = this.convertToCircleRect(new Rect(0, 0, view.getWidth(), view.getHeight()));
        outline.setOval(ovalRect);
    }

    private Rect convertToCircleRect(Rect rect) {
        int bottom;
        int right;
        int top;
        int left;
        if (rect.width() > rect.height()) {
            int dH = rect.height() / 2;
            left = rect.centerX() - dH;
            top = 0;
            right = rect.centerX() + dH;
            bottom = dH * 2;
        } else {
            int dW = rect.width() / 2;
            left = 0;
            top = rect.centerY() - dW;
            right = dW * 2;
            bottom = rect.centerY() + dW;
        }
        rect.set(left, top, right, bottom);
        return rect;
    }
}

