/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.RecyclerView;

public abstract class BaseViewHolder<T>
extends RecyclerView.ViewHolder {
    private final SparseArray<View> mViews = new SparseArray();

    public BaseViewHolder(@NonNull View itemView) {
        super(itemView);
    }

    public abstract void bindData(T var1, int var2, int var3);

    protected <V extends View> V findView(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (V)view;
    }

    protected void setText(int viewId, String text) {
        Object view = this.findView(viewId);
        if (view instanceof TextView) {
            ((TextView)view).setText((CharSequence)text);
        }
    }

    protected void setText(int viewId, @StringRes int textId) {
        Object view = this.findView(viewId);
        if (view instanceof TextView) {
            ((TextView)view).setText(textId);
        }
    }

    protected void setTextColor(int viewId, @ColorInt int colorId) {
        Object view = this.findView(viewId);
        if (view instanceof TextView) {
            ((TextView)view).setTextColor(colorId);
        }
    }

    protected void setOnClickListener(int viewId, View.OnClickListener clickListener) {
        this.findView(viewId).setOnClickListener(clickListener);
    }

    protected void setBackgroundResource(int viewId, @DrawableRes int resId) {
        this.findView(viewId).setBackgroundResource(resId);
    }

    protected void setBackgroundColor(int viewId, @ColorInt int colorId) {
        this.findView(viewId).setBackgroundColor(colorId);
    }

    protected void setImageResource(@IdRes int viewId, @DrawableRes int resId) {
        Object view = this.findView(viewId);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageResource(resId);
        }
    }
}

