/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator.drawer;

import android.graphics.Canvas;
import com.zhpan.bannerview.indicator.drawer.BaseDrawer;
import com.zhpan.bannerview.manager.IndicatorOptions;
import com.zhpan.bannerview.utils.BannerUtils;

public class RectDrawer
extends BaseDrawer {
    RectDrawer(IndicatorOptions indicatorOptions) {
        super(indicatorOptions);
    }

    @Override
    public void onDraw(Canvas canvas) {
        int pageSize = this.mIndicatorOptions.getPageSize();
        if (pageSize > 1) {
            if (this.isWidthEquals() && this.mIndicatorOptions.getSlideMode() != 0) {
                this.drawUncheckedSlider(canvas, pageSize);
                this.drawCheckedSlider(canvas);
            } else {
                for (int i = 0; i < pageSize; ++i) {
                    this.drawInequalitySlider(canvas, i);
                }
            }
        }
    }

    private void drawUncheckedSlider(Canvas canvas, int pageSize) {
        for (int i = 0; i < pageSize; ++i) {
            this.mPaint.setColor(this.mIndicatorOptions.getNormalColor());
            float sliderHeight = this.mIndicatorOptions.getSliderHeight();
            float left = (float)i * this.maxWidth + (float)i * this.mIndicatorOptions.getIndicatorGap() + (this.maxWidth - this.minWidth);
            this.mRectF.set(left, 0.0f, left + this.minWidth, sliderHeight);
            this.drawRoundRect(canvas, sliderHeight, sliderHeight);
        }
    }

    private void drawInequalitySlider(Canvas canvas, int i) {
        int normalColor = this.mIndicatorOptions.getNormalColor();
        float indicatorGap = this.mIndicatorOptions.getIndicatorGap();
        float sliderHeight = this.mIndicatorOptions.getSliderHeight();
        int currentPosition = this.mIndicatorOptions.getCurrentPosition();
        if (i < currentPosition) {
            this.mPaint.setColor(normalColor);
            float left = (float)i * this.minWidth + (float)i * indicatorGap;
            this.mRectF.set(left, 0.0f, left + this.minWidth, sliderHeight);
            this.drawRoundRect(canvas, sliderHeight, sliderHeight);
        } else if (i == currentPosition) {
            this.mPaint.setColor(this.mIndicatorOptions.getCheckedColor());
            float left = (float)i * this.minWidth + (float)i * indicatorGap;
            this.mRectF.set(left, 0.0f, left + this.minWidth + (this.maxWidth - this.minWidth), sliderHeight);
            this.drawRoundRect(canvas, sliderHeight, sliderHeight);
        } else {
            this.mPaint.setColor(normalColor);
            float left = (float)i * this.minWidth + (float)i * indicatorGap + (this.maxWidth - this.minWidth);
            this.mRectF.set(left, 0.0f, left + this.minWidth, sliderHeight);
            this.drawRoundRect(canvas, sliderHeight, sliderHeight);
        }
    }

    private void drawCheckedSlider(Canvas canvas) {
        this.mPaint.setColor(this.mIndicatorOptions.getCheckedColor());
        switch (this.mIndicatorOptions.getSlideMode()) {
            case 2: {
                this.drawSmoothSlider(canvas);
                break;
            }
            case 3: {
                this.drawWormSlider(canvas);
            }
        }
    }

    private void drawWormSlider(Canvas canvas) {
        float sliderHeight = this.mIndicatorOptions.getSliderHeight();
        float slideProgress = this.mIndicatorOptions.getSlideProgress();
        int currentPosition = this.mIndicatorOptions.getCurrentPosition();
        float distance = this.mIndicatorOptions.getIndicatorGap() + this.mIndicatorOptions.getNormalIndicatorWidth();
        float startCoordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, currentPosition);
        float left = startCoordinateX + Math.max(distance * (slideProgress - 0.5f) * 2.0f, 0.0f) - this.mIndicatorOptions.getNormalIndicatorWidth() / 2.0f;
        float right = startCoordinateX + Math.min(distance * slideProgress * 2.0f, distance) + this.mIndicatorOptions.getNormalIndicatorWidth() / 2.0f;
        this.mRectF.set(left, 0.0f, right, sliderHeight);
        this.drawRoundRect(canvas, sliderHeight, sliderHeight);
    }

    private void drawSmoothSlider(Canvas canvas) {
        int currentPosition = this.mIndicatorOptions.getCurrentPosition();
        float indicatorGap = this.mIndicatorOptions.getIndicatorGap();
        float sliderHeight = this.mIndicatorOptions.getSliderHeight();
        float left = (float)currentPosition * this.maxWidth + (float)currentPosition * indicatorGap + (this.maxWidth + indicatorGap) * this.mIndicatorOptions.getSlideProgress();
        this.mRectF.set(left, 0.0f, left + this.maxWidth, sliderHeight);
        this.drawRoundRect(canvas, sliderHeight, sliderHeight);
    }

    protected void drawRoundRect(Canvas canvas, float rx, float ry) {
        this.drawDash(canvas);
    }

    protected void drawDash(Canvas canvas) {
    }
}

