/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import com.zhpan.bannerview.holder.HolderCreator;
import com.zhpan.bannerview.holder.ViewHolder;
import com.zhpan.bannerview.utils.BannerUtils;
import java.util.ArrayList;
import java.util.List;

public class BannerPagerAdapter<T, VH extends ViewHolder>
extends PagerAdapter {
    private List<T> mList = new ArrayList<T>();
    private HolderCreator holderCreator;
    private boolean isCanLoop;
    private PageClickListener mPageClickListener;
    public static final int MAX_VALUE = 10000;

    public BannerPagerAdapter(List<T> list, HolderCreator<VH> holderCreator) {
        this.mList.addAll(list);
        this.holderCreator = holderCreator;
    }

    public int getCount() {
        if (this.isCanLoop && this.mList.size() > 1) {
            return 10000;
        }
        return this.mList.size();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        View itemView = this.getView(container, BannerUtils.getRealPosition(this.isCanLoop, position, this.mList.size()));
        container.addView(itemView);
        return itemView;
    }

    private View getView(ViewGroup container, int position) {
        Object holder = this.holderCreator.createViewHolder();
        if (holder == null) {
            throw new NullPointerException("Can not return a null holder");
        }
        return this.createView((ViewHolder<T>)holder, position, container);
    }

    private View createView(ViewHolder<T> holder, int position, ViewGroup container) {
        View itemView = LayoutInflater.from((Context)container.getContext()).inflate(holder.getLayoutId(), container, false);
        if (this.mList != null && this.mList.size() > 0) {
            holder.onBind(itemView, this.mList.get(position), position, this.mList.size());
            this.setViewListener(itemView, position);
        }
        return itemView;
    }

    private void setViewListener(View view, final int position) {
        if (view != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != BannerPagerAdapter.this.mPageClickListener) {
                        BannerPagerAdapter.this.mPageClickListener.onPageClick(position);
                    }
                }
            });
        }
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
    }

    public void finishUpdate(@NonNull ViewGroup container) {
        super.finishUpdate(container);
    }

    public void setPageClickListener(PageClickListener pageClickListener) {
        this.mPageClickListener = pageClickListener;
    }

    public void setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
    }

    public List<T> getList() {
        return this.mList;
    }

    public int getListSize() {
        return this.mList.size();
    }

    public static interface PageClickListener {
        public void onPageClick(int var1);
    }
}

