/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.zhpan.bannerview.R;
import com.zhpan.bannerview.adapter.BannerPagerAdapter;
import com.zhpan.bannerview.holder.HolderCreator;
import com.zhpan.bannerview.holder.ViewHolder;
import com.zhpan.bannerview.indicator.IIndicator;
import com.zhpan.bannerview.indicator.IndicatorView;
import com.zhpan.bannerview.manager.BannerManager;
import com.zhpan.bannerview.manager.BannerOptions;
import com.zhpan.bannerview.provider.ViewStyleSetter;
import com.zhpan.bannerview.transform.PageTransformerFactory;
import com.zhpan.bannerview.transform.ScaleInTransformer;
import com.zhpan.bannerview.utils.BannerUtils;
import com.zhpan.bannerview.view.CatchViewPager;
import java.util.List;

public class BannerViewPager<T, VH extends ViewHolder>
extends RelativeLayout
implements ViewPager.OnPageChangeListener {
    private int currentPosition;
    private boolean isCustomIndicator;
    private OnPageClickListener mOnPageClickListener;
    private IIndicator mIndicatorView;
    private RelativeLayout mIndicatorLayout;
    private CatchViewPager mViewPager;
    private BannerManager mBannerManager;
    private HolderCreator<VH> holderCreator;
    private Handler mHandler = new Handler();
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            BannerViewPager.this.handlePosition();
        }
    };
    private BannerPagerAdapter<T, VH> mBannerPagerAdapter;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;

    public BannerViewPager(Context context) {
        this(context, null);
    }

    public BannerViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mBannerManager = new BannerManager();
        this.mBannerManager.initAttrs(context, attrs);
        this.initView();
    }

    private void initView() {
        BannerViewPager.inflate((Context)this.getContext(), (int)R.layout.layout_banner_view_pager, (ViewGroup)this);
        this.mViewPager = (CatchViewPager)this.findViewById(R.id.vp_main);
        this.mIndicatorLayout = (RelativeLayout)this.findViewById(R.id.rl_indicator);
    }

    protected void onDetachedFromWindow() {
        this.stopLoop();
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startLoop();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setTouchListener() {
        this.mViewPager.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int action = event.getAction();
                switch (action) {
                    case 0: 
                    case 2: {
                        BannerViewPager.this.setLooping(true);
                        BannerViewPager.this.stopLoop();
                        break;
                    }
                    case 1: 
                    case 3: {
                        BannerViewPager.this.setLooping(false);
                        BannerViewPager.this.startLoop();
                    }
                }
                return false;
            }
        });
    }

    public void onPageSelected(int position) {
        int size = this.mBannerPagerAdapter.getListSize();
        if (size > 0 && this.isCanLoop() && position == 0) {
            position = 0x3FFFFFFF - 0x3FFFFFFF % size + 1;
            this.setCurrentItem(0, false);
        }
        this.currentPosition = BannerUtils.getRealPosition(this.isCanLoop(), position, size);
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(this.currentPosition);
        }
        if (this.mIndicatorView != null) {
            this.mIndicatorView.onPageSelected(this.currentPosition);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mIndicatorView != null) {
            this.mIndicatorView.onPageScrollStateChanged(state);
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        int listSize = this.mBannerPagerAdapter.getListSize();
        if (listSize > 0) {
            if (this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageScrolled(BannerUtils.getRealPosition(this.isCanLoop(), position, listSize), positionOffset, positionOffsetPixels);
            }
            if (this.mIndicatorView != null) {
                this.mIndicatorView.onPageScrolled(BannerUtils.getRealPosition(this.isCanLoop(), position, listSize), positionOffset, positionOffsetPixels);
            }
        }
    }

    private void handlePosition() {
        if (this.mBannerPagerAdapter.getListSize() > 1) {
            this.currentPosition = this.mViewPager.getCurrentItem() + 1;
            this.mViewPager.setCurrentItem(this.currentPosition);
            this.mHandler.postDelayed(this.mRunnable, (long)this.getInterval());
        }
    }

    private void initBannerData(List<T> list) {
        if (list != null) {
            this.setIndicatorValues(list);
            this.setupViewPager(list);
            this.initRoundCorner();
        }
    }

    private void setIndicatorValues(List<T> list) {
        BannerOptions bannerOptions = this.mBannerManager.bannerOptions();
        bannerOptions.resetIndicatorOptions();
        if (this.isCustomIndicator && null != this.mIndicatorView) {
            this.initIndicator(this.mIndicatorView);
        } else {
            this.initIndicator(new IndicatorView(this.getContext()));
        }
        this.mIndicatorView.setIndicatorOptions(bannerOptions.getIndicatorOptions());
        this.mIndicatorView.setPageSize(list.size());
    }

    private void initIndicator(IIndicator indicatorView) {
        this.mIndicatorLayout.setVisibility(this.mBannerManager.bannerOptions().getIndicatorVisibility());
        this.mIndicatorView = indicatorView;
        if (((View)this.mIndicatorView).getParent() == null) {
            this.mIndicatorLayout.removeAllViews();
            this.mIndicatorLayout.addView((View)this.mIndicatorView);
            this.initIndicatorViewMargin();
            this.initIndicatorGravity();
        }
    }

    private void initIndicatorGravity() {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)((View)this.mIndicatorView).getLayoutParams();
        switch (this.mBannerManager.bannerOptions().getIndicatorGravity()) {
            case 0: {
                layoutParams.addRule(14);
                break;
            }
            case 2: {
                layoutParams.addRule(9);
                break;
            }
            case 4: {
                layoutParams.addRule(11);
            }
        }
    }

    private void initIndicatorViewMargin() {
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)((View)this.mIndicatorView).getLayoutParams();
        BannerOptions.IndicatorMargin indicatorMargin = this.mBannerManager.bannerOptions().getIndicatorMargin();
        if (indicatorMargin == null) {
            int dp10 = BannerUtils.dp2px(10.0f);
            layoutParams.setMargins(dp10, dp10, dp10, dp10);
        } else {
            layoutParams.setMargins(indicatorMargin.getLeft(), indicatorMargin.getTop(), indicatorMargin.getRight(), indicatorMargin.getBottom());
        }
    }

    private void initRoundCorner() {
        int roundCorner = this.mBannerManager.bannerOptions().getRoundRectRadius();
        if (roundCorner > 0 && Build.VERSION.SDK_INT >= 21) {
            ViewStyleSetter viewStyleSetter = new ViewStyleSetter((View)this);
            viewStyleSetter.setRoundRect(roundCorner);
        }
    }

    private void setupViewPager(List<T> list) {
        if (this.holderCreator != null) {
            if (list.size() > 0 && this.isCanLoop()) {
                this.currentPosition = 0x3FFFFFFF - 0x3FFFFFFF % list.size() + 1;
            }
        } else {
            throw new NullPointerException("You must set HolderCreator for BannerViewPager");
        }
        this.removeAllViews();
        this.mViewPager.setAdapter(this.getPagerAdapter(list));
        this.mViewPager.setCurrentItem(this.currentPosition);
        this.mViewPager.removeOnPageChangeListener(this);
        this.mViewPager.addOnPageChangeListener(this);
        BannerOptions bannerOptions = this.mBannerManager.bannerOptions();
        this.mViewPager.setScrollDuration(bannerOptions.getScrollDuration());
        this.mViewPager.disableTouchScroll(bannerOptions.isDisableTouchScroll());
        this.mViewPager.setFirstLayout(true);
        this.addView((View)this.mViewPager);
        this.addView((View)this.mIndicatorLayout);
        this.initPageStyle();
        this.startLoop();
        this.setTouchListener();
    }

    private PagerAdapter getPagerAdapter(List<T> list) {
        this.mBannerPagerAdapter = new BannerPagerAdapter<T, VH>(list, this.holderCreator);
        this.mBannerPagerAdapter.setCanLoop(this.isCanLoop());
        this.mBannerPagerAdapter.setPageClickListener(new BannerPagerAdapter.PageClickListener(){

            @Override
            public void onPageClick(int position) {
                if (BannerViewPager.this.mOnPageClickListener != null) {
                    BannerViewPager.this.mOnPageClickListener.onPageClick(position);
                }
            }
        });
        return this.mBannerPagerAdapter;
    }

    private void initPageStyle() {
        switch (this.mBannerManager.bannerOptions().getPageStyle()) {
            case 2: {
                this.setMultiPageStyle(false, 0.999f);
                break;
            }
            case 4: {
                this.setMultiPageStyle(true, 0.85f);
                break;
            }
            case 8: {
                this.setMultiPageStyle(false, 0.85f);
            }
        }
    }

    private void setMultiPageStyle(boolean overlap, float scale) {
        this.setClipChildren(false);
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mViewPager.getLayoutParams();
        BannerOptions bannerOptions = this.mBannerManager.bannerOptions();
        params.rightMargin = params.leftMargin = bannerOptions.getPageMargin() + bannerOptions.getRevealWidth();
        this.mViewPager.setOverlapStyle(overlap);
        this.mViewPager.setPageMargin(overlap ? -bannerOptions.getPageMargin() : bannerOptions.getPageMargin());
        this.mViewPager.setOffscreenPageLimit(2);
        this.setPageTransformer(new ScaleInTransformer(scale));
    }

    private int getInterval() {
        return this.mBannerManager.bannerOptions().getInterval();
    }

    private boolean isAutoPlay() {
        return this.mBannerManager.bannerOptions().isAutoPlay();
    }

    private boolean isLooping() {
        return this.mBannerManager.bannerOptions().isLooping();
    }

    private void setLooping(boolean looping) {
        this.mBannerManager.bannerOptions().setLooping(looping);
    }

    private boolean isCanLoop() {
        return this.mBannerManager.bannerOptions().isCanLoop();
    }

    public List<T> getList() {
        return this.mBannerPagerAdapter.getList();
    }

    public void startLoop() {
        if (!this.isLooping() && this.isAutoPlay() && this.mBannerPagerAdapter != null && this.mBannerPagerAdapter.getListSize() > 1) {
            this.mHandler.postDelayed(this.mRunnable, (long)this.getInterval());
            this.setLooping(true);
        }
    }

    public void stopLoop() {
        if (this.isLooping()) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.setLooping(false);
        }
    }

    public BannerViewPager<T, VH> setHolderCreator(HolderCreator<VH> holderCreator) {
        this.holderCreator = holderCreator;
        return this;
    }

    @Deprecated
    public BannerViewPager<T, VH> setRoundCorner(int radius) {
        this.mBannerManager.bannerOptions().setRoundRectRadius(radius);
        return this;
    }

    public BannerViewPager<T, VH> setRoundRect(int radius) {
        this.mBannerManager.bannerOptions().setRoundRectRadius(radius);
        return this;
    }

    public BannerViewPager<T, VH> setAutoPlay(boolean autoPlay) {
        this.mBannerManager.bannerOptions().setAutoPlay(autoPlay);
        if (this.isAutoPlay()) {
            this.mBannerManager.bannerOptions().setCanLoop(true);
        }
        return this;
    }

    public BannerViewPager<T, VH> setCanLoop(boolean canLoop) {
        this.mBannerManager.bannerOptions().setCanLoop(canLoop);
        if (!canLoop) {
            this.mBannerManager.bannerOptions().setAutoPlay(false);
        }
        return this;
    }

    public BannerViewPager<T, VH> setInterval(int interval) {
        this.mBannerManager.bannerOptions().setInterval(interval);
        return this;
    }

    public BannerViewPager<T, VH> setPageTransformerStyle(int style) {
        this.mViewPager.setPageTransformer(true, new PageTransformerFactory().createPageTransformer(style));
        return this;
    }

    public void setPageTransformer(@Nullable ViewPager.PageTransformer transformer) {
        this.mViewPager.setPageTransformer(true, transformer);
    }

    public BannerViewPager<T, VH> setOnPageClickListener(OnPageClickListener onPageClickListener) {
        this.mOnPageClickListener = onPageClickListener;
        return this;
    }

    public BannerViewPager<T, VH> setScrollDuration(int scrollDuration) {
        this.mBannerManager.bannerOptions().setScrollDuration(scrollDuration);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorColor(@ColorInt int normalColor, @ColorInt int checkedColor) {
        this.mBannerManager.bannerOptions().setIndicatorCheckedColor(checkedColor);
        this.mBannerManager.bannerOptions().setIndicatorNormalColor(normalColor);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorRadius(int radius) {
        this.setIndicatorRadius(radius, radius);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorRadius(int normalRadius, int checkedRadius) {
        this.mBannerManager.bannerOptions().setNormalIndicatorWidth(normalRadius * 2);
        this.mBannerManager.bannerOptions().setCheckedIndicatorWidth(checkedRadius * 2);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorWidth(int indicatorWidth) {
        this.setIndicatorWidth(indicatorWidth, indicatorWidth);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorWidth(int normalWidth, int checkWidth) {
        this.mBannerManager.bannerOptions().setNormalIndicatorWidth(normalWidth);
        this.mBannerManager.bannerOptions().setCheckedIndicatorWidth(checkWidth);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorHeight(int indicatorHeight) {
        this.mBannerManager.bannerOptions().setIndicatorHeight(indicatorHeight);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorGap(int indicatorGap) {
        this.mBannerManager.bannerOptions().setIndicatorGap(indicatorGap);
        return this;
    }

    @Deprecated
    public BannerViewPager<T, VH> showIndicator(boolean showIndicator) {
        this.mIndicatorLayout.setVisibility(showIndicator ? 0 : 8);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorVisibility(int visibility) {
        this.mBannerManager.bannerOptions().setIndicatorVisibility(visibility);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorGravity(int gravity) {
        this.mBannerManager.bannerOptions().setIndicatorGravity(gravity);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSlideMode(int slideMode) {
        this.mBannerManager.bannerOptions().setIndicatorSlideMode(slideMode);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorView(IIndicator customIndicator) {
        if (customIndicator instanceof View) {
            this.isCustomIndicator = true;
            this.mIndicatorView = customIndicator;
        }
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorStyle(int indicatorStyle) {
        this.mBannerManager.bannerOptions().setIndicatorStyle(indicatorStyle);
        return this;
    }

    public void create(List<T> list) {
        this.initBannerData(list);
    }

    public int getCurrentItem() {
        return this.currentPosition;
    }

    public void setCurrentItem(int item) {
        if (this.isCanLoop() && this.mBannerPagerAdapter.getListSize() > 1) {
            this.removeAllViews();
            this.mViewPager.setCurrentItem(0x3FFFFFFF - 0x3FFFFFFF % this.mBannerPagerAdapter.getListSize() + 1 + item);
            this.addView((View)this.mViewPager);
            this.addView((View)this.mIndicatorLayout);
        } else {
            this.mViewPager.setCurrentItem(item);
        }
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        if (this.isCanLoop() && this.mBannerPagerAdapter.getListSize() > 1) {
            this.removeAllViews();
            this.mViewPager.setCurrentItem(0x3FFFFFFF - 0x3FFFFFFF % this.mBannerPagerAdapter.getListSize() + 1 + item, smoothScroll);
            this.addView((View)this.mViewPager);
            this.addView((View)this.mIndicatorLayout);
        } else {
            this.mViewPager.setCurrentItem(item, smoothScroll);
        }
    }

    public BannerViewPager<T, VH> setPageStyle(int pageStyle) {
        this.mBannerManager.bannerOptions().setPageStyle(pageStyle);
        return this;
    }

    public BannerViewPager<T, VH> setPageMargin(int pageMargin) {
        this.mBannerManager.bannerOptions().setPageMargin(pageMargin);
        this.mViewPager.setPageMargin(pageMargin);
        return this;
    }

    public BannerViewPager<T, VH> setRevealWidth(int revealWidth) {
        this.mBannerManager.bannerOptions().setRevealWidth(revealWidth);
        return this;
    }

    @Deprecated
    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public BannerViewPager<T, VH> setIndicatorMargin(int left, int top, int right, int bottom) {
        this.mBannerManager.bannerOptions().setIndicatorMargin(left, top, right, bottom);
        return this;
    }

    public BannerViewPager<T, VH> disableTouchScroll(boolean disableTouchScroll) {
        this.mBannerManager.bannerOptions().setDisableTouchScroll(disableTouchScroll);
        return this;
    }

    public BannerViewPager<T, VH> setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
        return this;
    }

    public static interface OnPageClickListener {
        public void onPageClick(int var1);
    }
}

