/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.zhpan.bannerview.indicator.BaseIndicatorView;
import com.zhpan.bannerview.indicator.IIndicator;
import com.zhpan.bannerview.indicator.drawer.BaseDrawer;
import com.zhpan.bannerview.indicator.drawer.DrawerProxy;
import com.zhpan.bannerview.manager.IndicatorOptions;

public class IndicatorView
extends BaseIndicatorView
implements IIndicator {
    private DrawerProxy mDrawerProxy = new DrawerProxy(this.getIndicatorOptions());

    public IndicatorView(Context context) {
        this(context, null);
    }

    public IndicatorView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        BaseDrawer.MeasureResult measureResult = this.mDrawerProxy.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(measureResult.getMeasureWidth(), measureResult.getMeasureHeight());
    }

    @Override
    public void setIndicatorOptions(IndicatorOptions indicatorOptions) {
        super.setIndicatorOptions(indicatorOptions);
        this.mDrawerProxy.setIndicatorOptions(indicatorOptions);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mDrawerProxy.onDraw(canvas);
    }
}

