/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.adapter;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import com.zhpan.bannerview.holder.HolderCreator;
import com.zhpan.bannerview.holder.ViewHolder;
import com.zhpan.bannerview.utils.PositionUtils;
import java.util.ArrayList;
import java.util.List;

public class BannerPagerAdapter<T, VH extends ViewHolder>
extends PagerAdapter {
    private List<T> mList;
    private HolderCreator holderCreator;
    private boolean isCanLoop;
    private PageClickListener mPageClickListener;
    private List<View> mViewList = new ArrayList<View>();
    private int mPageStyle;
    public static final int MAX_VALUE = Integer.MAX_VALUE;

    public BannerPagerAdapter(List<T> list, HolderCreator<VH> holderCreator) {
        this.mList = list;
        this.holderCreator = holderCreator;
    }

    public int getCount() {
        if (this.isCanLoop && this.mList.size() > 1) {
            return Integer.MAX_VALUE;
        }
        return this.mList.size();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        View itemView = this.findViewByPosition(container, PositionUtils.getRealPosition(this.isCanLoop, position, this.mList.size()));
        container.addView(itemView);
        return itemView;
    }

    private View findViewByPosition(ViewGroup container, int position) {
        for (View view : this.mViewList) {
            if ((Integer)view.getTag() != position || view.getParent() != null) continue;
            return view;
        }
        View view = this.getView(position, container);
        view.setTag((Object)position);
        this.mViewList.add(view);
        return view;
    }

    private View getView(int position, ViewGroup container) {
        Object holder = this.holderCreator.createViewHolder();
        if (holder == null) {
            throw new RuntimeException("can not return a null holder");
        }
        return this.createView((ViewHolder<T>)holder, position, container);
    }

    private View createView(ViewHolder<T> holder, int position, ViewGroup container) {
        View view = null;
        if (this.mList != null && this.mList.size() > 0) {
            view = holder.createView(container, container.getContext(), position);
            holder.onBind(container.getContext(), this.mList.get(position), position, this.mList.size());
            this.setViewListener(view, position);
        }
        return view;
    }

    private void setViewListener(View view, int position) {
        if (view != null) {
            view.setOnClickListener(v -> {
                if (null != this.mPageClickListener) {
                    this.mPageClickListener.onPageClick(PositionUtils.toUnrealPosition(this.isCanLoop, position, this.mList.size(), this.mPageStyle));
                }
            });
        }
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
    }

    public void finishUpdate(@NonNull ViewGroup container) {
        super.finishUpdate(container);
    }

    public void setPageClickListener(PageClickListener pageClickListener) {
        this.mPageClickListener = pageClickListener;
    }

    public void setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
    }

    public void setPageStyle(int pageStyle) {
        this.mPageStyle = pageStyle;
    }

    public static interface PageClickListener {
        public void onPageClick(int var1);
    }
}

