/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;
import com.zhpan.bannerview.R;
import com.zhpan.bannerview.adapter.BannerPagerAdapter;
import com.zhpan.bannerview.holder.HolderCreator;
import com.zhpan.bannerview.holder.ViewHolder;
import com.zhpan.bannerview.indicator.DashIndicatorView;
import com.zhpan.bannerview.indicator.IIndicator;
import com.zhpan.bannerview.indicator.IndicatorFactory;
import com.zhpan.bannerview.provider.ViewStyleSetter;
import com.zhpan.bannerview.transform.PageTransformerFactory;
import com.zhpan.bannerview.transform.pagestyle.ScaleInTransformer;
import com.zhpan.bannerview.utils.BannerUtils;
import com.zhpan.bannerview.utils.PositionUtils;
import com.zhpan.bannerview.view.CatchViewPager;
import java.util.ArrayList;
import java.util.List;

public class BannerViewPager<T, VH extends ViewHolder>
extends RelativeLayout
implements ViewPager.OnPageChangeListener {
    private int interval;
    private int currentPosition;
    private boolean isLooping;
    private boolean isCanLoop;
    private boolean isAutoPlay = false;
    private int indicatorGravity;
    private int indicatorNormalColor;
    private int indicatorCheckedColor;
    private int normalIndicatorWidth;
    private int checkedIndicatorWidth;
    private OnPageClickListener mOnPageClickListener;
    private IIndicator mIndicatorView;
    private RelativeLayout mIndicatorLayout;
    private int mPageMargin;
    private int mRevealWidth;
    private int mIndicatorStyle;
    private int mIndicatorSlideMode;
    private CatchViewPager mViewPager;
    private List<T> mList;
    private HolderCreator<VH> holderCreator;
    private int indicatorGap;
    private int indicatorHeight;
    private boolean isCustomIndicator;
    private int mPageStyle = 0;
    private IndicatorMargin mIndicatorMargin;
    private Handler mHandler = new Handler();
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            if (BannerViewPager.this.mList.size() > 1) {
                BannerViewPager.this.currentPosition = BannerViewPager.this.mViewPager.getCurrentItem() + 1;
                if (BannerViewPager.this.isCanLoop) {
                    if (BannerViewPager.this.currentPosition == 0x7FFFFFFE) {
                        BannerViewPager.this.currentPosition = 0;
                        BannerViewPager.this.mViewPager.setCurrentItem(BannerViewPager.this.currentPosition, false);
                        BannerViewPager.this.mHandler.post(BannerViewPager.this.mRunnable);
                    } else {
                        BannerViewPager.this.mViewPager.setCurrentItem(BannerViewPager.this.currentPosition);
                        BannerViewPager.this.mHandler.postDelayed(BannerViewPager.this.mRunnable, (long)BannerViewPager.this.interval);
                    }
                } else if (BannerViewPager.this.currentPosition >= Integer.MAX_VALUE) {
                    BannerViewPager.this.stopLoop();
                } else {
                    BannerViewPager.this.mViewPager.setCurrentItem(BannerViewPager.this.currentPosition);
                    BannerViewPager.this.mHandler.postDelayed(BannerViewPager.this.mRunnable, (long)BannerViewPager.this.interval);
                }
            }
        }
    };
    private int mIndicatorVisibility;
    private int mScrollDuration;
    private int mRoundCorner;
    private boolean disableTouchScroll;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;

    public BannerViewPager(Context context) {
        this(context, null);
    }

    public BannerViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.initAttrs(attrs);
        this.initView();
    }

    private void initView() {
        BannerViewPager.inflate((Context)this.getContext(), (int)R.layout.layout_banner_view_pager, (ViewGroup)this);
        this.mViewPager = (CatchViewPager)this.findViewById(R.id.vp_main);
        this.mIndicatorLayout = (RelativeLayout)this.findViewById(R.id.rl_indicator);
        this.mList = new ArrayList<T>();
    }

    private void initAttrs(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.BannerViewPager);
            this.interval = typedArray.getInteger(R.styleable.BannerViewPager_bvp_interval, 3000);
            this.indicatorCheckedColor = typedArray.getColor(R.styleable.BannerViewPager_bvp_indicator_checked_color, Color.parseColor((String)"#8C18171C"));
            this.indicatorNormalColor = typedArray.getColor(R.styleable.BannerViewPager_bvp_indicator_normal_color, Color.parseColor((String)"#8C6C6D72"));
            this.normalIndicatorWidth = (int)typedArray.getDimension(R.styleable.BannerViewPager_bvp_indicator_radius, (float)BannerUtils.dp2px(8.0f));
            this.isAutoPlay = typedArray.getBoolean(R.styleable.BannerViewPager_bvp_auto_play, true);
            this.isCanLoop = typedArray.getBoolean(R.styleable.BannerViewPager_bvp_can_loop, true);
            this.mPageMargin = (int)typedArray.getDimension(R.styleable.BannerViewPager_bvp_page_margin, 0.0f);
            this.mRoundCorner = (int)typedArray.getDimension(R.styleable.BannerViewPager_bvp_round_corner, 0.0f);
            this.mRevealWidth = (int)typedArray.getDimension(R.styleable.BannerViewPager_bvp_reveal_width, 0.0f);
            this.indicatorGravity = typedArray.getInt(R.styleable.BannerViewPager_bvp_indicator_gravity, 0);
            this.mPageStyle = typedArray.getInt(R.styleable.BannerViewPager_bvp_page_style, 0);
            this.mIndicatorStyle = typedArray.getInt(R.styleable.BannerViewPager_bvp_indicator_style, 0);
            this.mIndicatorSlideMode = typedArray.getInt(R.styleable.BannerViewPager_bvp_indicator_slide_mode, 0);
            this.mIndicatorVisibility = typedArray.getInt(R.styleable.BannerViewPager_bvp_indicator_visibility, 0);
            this.mScrollDuration = typedArray.getInt(R.styleable.BannerViewPager_bvp_scroll_duration, 800);
            typedArray.recycle();
            this.indicatorGap = this.normalIndicatorWidth;
            this.indicatorHeight = this.normalIndicatorWidth / 2;
            this.checkedIndicatorWidth = this.normalIndicatorWidth;
        }
    }

    private void initBannerData(List<T> list) {
        if (list != null) {
            this.mList.clear();
            this.mList.addAll(list);
            if (this.mList.size() > 0) {
                if (this.mList.size() > 1) {
                    if (this.isCustomIndicator && null != this.mIndicatorView) {
                        this.initIndicator(this.mIndicatorView);
                    } else {
                        this.initIndicator(IndicatorFactory.createIndicatorView(this.getContext(), this.mIndicatorStyle));
                    }
                }
                if (this.isCanLoop) {
                    this.currentPosition = 0x3FFFFFFF - 0x3FFFFFFF % this.mList.size() + 1;
                }
                this.setupViewPager();
                this.setIndicatorValues();
            }
        }
    }

    private void setIndicatorValues() {
        if (null != this.mIndicatorView) {
            this.mIndicatorView.setPageSize(this.mList.size());
            this.mIndicatorView.setCheckedColor(this.indicatorCheckedColor);
            this.mIndicatorView.setNormalColor(this.indicatorNormalColor);
            this.mIndicatorView.setIndicatorGap(this.indicatorGap);
            this.mIndicatorView.setSlideMode(this.mIndicatorSlideMode);
            this.mIndicatorView.setIndicatorWidth(this.normalIndicatorWidth, this.checkedIndicatorWidth);
            if (this.mIndicatorView instanceof DashIndicatorView) {
                ((DashIndicatorView)this.mIndicatorView).setSliderHeight(this.indicatorHeight);
            }
            this.mIndicatorView.notifyDataChanged();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setTouchListener() {
        this.mViewPager.setOnTouchListener((v, event) -> {
            int action = event.getAction();
            switch (action) {
                case 0: 
                case 2: {
                    this.isLooping = true;
                    this.stopLoop();
                    break;
                }
                case 1: 
                case 3: {
                    this.isLooping = false;
                    this.startLoop();
                }
            }
            return false;
        });
    }

    private void initIndicator(IIndicator indicatorView) {
        this.mIndicatorLayout.setVisibility(this.mIndicatorVisibility);
        this.mIndicatorView = indicatorView;
        if (((View)this.mIndicatorView).getParent() == null) {
            this.mIndicatorLayout.removeAllViews();
            this.mIndicatorLayout.addView((View)this.mIndicatorView);
            this.initIndicatorViewMargin();
            this.initIndicatorGravity();
        }
    }

    private void initIndicatorGravity() {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)((View)this.mIndicatorView).getLayoutParams();
        switch (this.indicatorGravity) {
            case 0: {
                layoutParams.addRule(14);
                break;
            }
            case 1: {
                layoutParams.addRule(20);
                break;
            }
            case 2: {
                layoutParams.addRule(21);
            }
        }
    }

    private void initIndicatorViewMargin() {
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)((View)this.mIndicatorView).getLayoutParams();
        if (this.mIndicatorMargin == null) {
            int dp10 = BannerUtils.dp2px(10.0f);
            layoutParams.setMargins(dp10, dp10, dp10, dp10);
        } else {
            layoutParams.setMargins(this.mIndicatorMargin.left, this.mIndicatorMargin.top, this.mIndicatorMargin.right, this.mIndicatorMargin.bottom);
        }
    }

    private void setupViewPager() {
        if (this.holderCreator == null) {
            throw new NullPointerException("You must set HolderCreator for BannerViewPager");
        }
        this.removeAllViews();
        BannerPagerAdapter<T, VH> bannerPagerAdapter = new BannerPagerAdapter<T, VH>(this.mList, this.holderCreator);
        bannerPagerAdapter.setPageStyle(this.mPageStyle);
        bannerPagerAdapter.setCanLoop(this.isCanLoop);
        bannerPagerAdapter.setPageClickListener(position -> {
            if (this.mOnPageClickListener != null) {
                this.mOnPageClickListener.onPageClick(PositionUtils.getRealPosition(this.isCanLoop, position, this.mList.size(), this.mPageStyle));
            }
        });
        this.mViewPager.setAdapter(bannerPagerAdapter);
        this.mViewPager.setCurrentItem(this.currentPosition);
        this.mViewPager.addOnPageChangeListener(this);
        this.mViewPager.setScrollDuration(this.mScrollDuration);
        this.mViewPager.disableTouchScroll(this.disableTouchScroll);
        this.addView((View)this.mViewPager);
        this.addView((View)this.mIndicatorLayout);
        this.initPageStyle();
        this.startLoop();
        this.setTouchListener();
        if (this.mRoundCorner > 0 && Build.VERSION.SDK_INT >= 21) {
            ViewStyleSetter viewStyleSetter = new ViewStyleSetter((View)this);
            viewStyleSetter.setRoundCorner(this.mRoundCorner);
        }
    }

    private void initPageStyle() {
        switch (this.mPageStyle) {
            case 1: {
                this.setMultiPageStyle(false, 0.999f);
                break;
            }
            case 2: {
                this.setMultiPageStyle(true, 0.85f);
                break;
            }
            case 3: {
                this.setMultiPageStyle(false, 0.85f);
            }
        }
    }

    private void setMultiPageStyle(boolean overlap, float scale) {
        this.mPageMargin = this.mPageMargin == 0 ? BannerUtils.dp2px(20.0f) : this.mPageMargin;
        this.mRevealWidth = this.mRevealWidth == 0 ? BannerUtils.dp2px(20.0f) : this.mRevealWidth;
        this.setClipChildren(false);
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mViewPager.getLayoutParams();
        params.leftMargin = this.mPageMargin + this.mRevealWidth;
        params.rightMargin = this.mPageMargin + this.mRevealWidth;
        this.mViewPager.setOverlapStyle(overlap);
        this.mViewPager.setPageMargin(overlap ? -this.mPageMargin : this.mPageMargin);
        this.mViewPager.setOffscreenPageLimit(2);
        this.setPageTransformer(new ScaleInTransformer(scale));
    }

    public void onPageSelected(int position) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(PositionUtils.getRealPosition(this.isCanLoop, position, this.mList.size()));
        }
        if (this.mIndicatorView != null) {
            this.mIndicatorView.onPageSelected(PositionUtils.getRealPosition(this.isCanLoop, position, this.mList.size()));
        }
        this.currentPosition = position;
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mIndicatorView != null) {
            this.mIndicatorView.onPageScrollStateChanged(state);
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(PositionUtils.getRealPosition(this.isCanLoop, position, this.mList.size()), positionOffset, positionOffsetPixels);
        }
        if (this.mIndicatorView != null) {
            this.mIndicatorView.onPageScrolled(PositionUtils.getRealPosition(this.isCanLoop, position, this.mList.size()), positionOffset, positionOffsetPixels);
        }
    }

    public List<T> getList() {
        return this.mList;
    }

    public void startLoop() {
        if (!this.isLooping && this.isAutoPlay && this.mList.size() > 1) {
            this.mHandler.postDelayed(this.mRunnable, (long)this.interval);
            this.isLooping = true;
        }
    }

    public void stopLoop() {
        if (this.isLooping) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.isLooping = false;
        }
    }

    public BannerViewPager<T, VH> setHolderCreator(HolderCreator<VH> holderCreator) {
        this.holderCreator = holderCreator;
        return this;
    }

    public BannerViewPager<T, VH> setRoundCorner(int radius) {
        this.mRoundCorner = radius;
        return this;
    }

    public BannerViewPager<T, VH> setAutoPlay(boolean autoPlay) {
        this.isAutoPlay = autoPlay;
        if (this.isAutoPlay) {
            this.isCanLoop = true;
        }
        return this;
    }

    public BannerViewPager<T, VH> setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
        if (!canLoop) {
            this.isAutoPlay = false;
        }
        return this;
    }

    public BannerViewPager<T, VH> setInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public BannerViewPager<T, VH> setPageTransformerStyle(int style) {
        this.mViewPager.setPageTransformer(true, new PageTransformerFactory().createPageTransformer(style));
        return this;
    }

    public void setPageTransformer(@Nullable ViewPager.PageTransformer transformer) {
        this.mViewPager.setPageTransformer(true, transformer);
    }

    public BannerViewPager<T, VH> setOnPageClickListener(OnPageClickListener onPageClickListener) {
        this.mOnPageClickListener = onPageClickListener;
        return this;
    }

    public BannerViewPager<T, VH> setScrollDuration(int scrollDuration) {
        this.mScrollDuration = scrollDuration;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorColor(@ColorInt int normalColor, @ColorInt int checkedColor) {
        this.indicatorCheckedColor = checkedColor;
        this.indicatorNormalColor = normalColor;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorRadius(int radius) {
        this.normalIndicatorWidth = radius * 2;
        this.checkedIndicatorWidth = radius * 2;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorRadius(int normalRadius, int checkedRadius) {
        this.normalIndicatorWidth = normalRadius * 2;
        this.checkedIndicatorWidth = checkedRadius * 2;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorWidth(int indicatorWidth) {
        this.normalIndicatorWidth = indicatorWidth;
        this.checkedIndicatorWidth = indicatorWidth;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorWidth(int normalWidth, int checkWidth) {
        this.normalIndicatorWidth = normalWidth;
        this.checkedIndicatorWidth = checkWidth;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorHeight(int indicatorHeight) {
        this.indicatorHeight = indicatorHeight;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorGap(int indicatorGap) {
        this.indicatorGap = indicatorGap;
        return this;
    }

    @Deprecated
    public BannerViewPager<T, VH> showIndicator(boolean showIndicator) {
        this.mIndicatorLayout.setVisibility(showIndicator ? 0 : 8);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorVisibility(int visibility) {
        this.mIndicatorVisibility = visibility;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorGravity(int gravity) {
        this.indicatorGravity = gravity;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSlideMode(int slideMode) {
        this.mIndicatorSlideMode = slideMode;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorView(IIndicator customIndicator) {
        if (customIndicator instanceof View) {
            this.isCustomIndicator = true;
            this.mIndicatorView = customIndicator;
        }
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorStyle(int indicatorStyle) {
        this.mIndicatorStyle = indicatorStyle;
        return this;
    }

    public void create(List<T> list) {
        this.initBannerData(list);
    }

    public int getCurrentItem() {
        return PositionUtils.getRealPosition(this.isCanLoop, this.currentPosition, this.mList.size(), this.mPageStyle);
    }

    public void setCurrentItem(int item) {
        this.mViewPager.setCurrentItem(PositionUtils.toUnrealPosition(this.isCanLoop, item, this.mList.size(), this.mPageStyle));
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.mViewPager.setCurrentItem(PositionUtils.toUnrealPosition(this.isCanLoop, item, this.mList.size(), this.mPageStyle), smoothScroll);
    }

    public BannerViewPager<T, VH> setPageStyle(int pageStyle) {
        this.mPageStyle = pageStyle;
        return this;
    }

    public BannerViewPager<T, VH> setPageMargin(int pageMargin) {
        this.mPageMargin = pageMargin;
        this.mViewPager.setPageMargin(pageMargin);
        return this;
    }

    public BannerViewPager<T, VH> setRevealWidth(int revealWidth) {
        this.mRevealWidth = revealWidth;
        return this;
    }

    @Deprecated
    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public BannerViewPager<T, VH> setIndicatorMargin(int left, int top, int right, int bottom) {
        this.mIndicatorMargin = new IndicatorMargin();
        this.mIndicatorMargin.bottom = bottom;
        this.mIndicatorMargin.left = left;
        this.mIndicatorMargin.top = top;
        this.mIndicatorMargin.right = right;
        return this;
    }

    public BannerViewPager<T, VH> disableTouchScroll(boolean disableTouchScroll) {
        this.disableTouchScroll = disableTouchScroll;
        return this;
    }

    public BannerViewPager<T, VH> setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
        return this;
    }

    private static class IndicatorMargin {
        private int left;
        private int right;
        private int top;
        private int bottom;

        private IndicatorMargin() {
        }
    }

    public static interface OnPageClickListener {
        public void onPageClick(int var1);
    }
}

