/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.transform.pagestyle;

import android.annotation.TargetApi;
import android.view.View;
import androidx.viewpager.widget.ViewPager;
import com.zhpan.bannerview.transform.pagestyle.BasePageTransformer;
import com.zhpan.bannerview.transform.pagestyle.NonPageTransformer;

public class ScaleInTransformer
extends BasePageTransformer {
    public static final float DEFAULT_MIN_SCALE = 0.85f;
    public static final float MAX_SCALE = 0.999f;
    private float mMinScale = 0.85f;

    public ScaleInTransformer() {
    }

    public ScaleInTransformer(float minScale) {
        this(minScale, NonPageTransformer.INSTANCE);
    }

    public ScaleInTransformer(ViewPager.PageTransformer pageTransformer) {
        this(0.85f, pageTransformer);
    }

    public ScaleInTransformer(float minScale, ViewPager.PageTransformer pageTransformer) {
        this.mMinScale = minScale;
        this.mPageTransformer = pageTransformer;
    }

    @Override
    @TargetApi(value=11)
    public void pageTransform(View view, float position) {
        int pageWidth = view.getWidth();
        int pageHeight = view.getHeight();
        view.setPivotY((float)(pageHeight / 2));
        view.setPivotX((float)(pageWidth / 2));
        if (position < -1.0f) {
            view.setScaleX(this.mMinScale);
            view.setScaleY(this.mMinScale);
            view.setPivotX((float)pageWidth);
        } else if (position <= 1.0f) {
            if (position < 0.0f) {
                float scaleFactor = (1.0f + position) * (1.0f - this.mMinScale) + this.mMinScale;
                view.setScaleX(scaleFactor);
                view.setScaleY(scaleFactor);
                view.setPivotX((float)pageWidth * (0.5f + 0.5f * -position));
            } else {
                float scaleFactor = (1.0f - position) * (1.0f - this.mMinScale) + this.mMinScale;
                view.setScaleX(scaleFactor);
                view.setScaleY(scaleFactor);
                view.setPivotX((float)pageWidth * ((1.0f - position) * 0.5f));
            }
        } else {
            view.setPivotX(0.0f);
            view.setScaleX(this.mMinScale);
            view.setScaleY(this.mMinScale);
        }
    }
}

