/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import com.zhpan.bannerview.indicator.BaseIndicatorView;

public class DashIndicatorView
extends BaseIndicatorView {
    private float sliderHeight;
    private float maxWidth;
    private float minWidth;

    public DashIndicatorView(Context context) {
        this(context, null);
    }

    public DashIndicatorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DashIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint.setColor(this.normalColor);
        this.sliderHeight = this.normalIndicatorWidth / 2.0f;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.maxWidth = Math.max(this.normalIndicatorWidth, this.checkedIndicatorWidth);
        this.minWidth = Math.min(this.normalIndicatorWidth, this.checkedIndicatorWidth);
        this.setMeasuredDimension((int)((float)(this.pageSize - 1) * this.indicatorGap + this.maxWidth + (float)(this.pageSize - 1) * this.minWidth), (int)this.sliderHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.pageSize > 1) {
            for (int i = 0; i < this.pageSize; ++i) {
                if (this.slideMode == 1) {
                    this.smoothSlide(canvas, i);
                    continue;
                }
                this.normalSlide(canvas, i);
            }
        }
    }

    private void normalSlide(Canvas canvas, int i) {
        if (this.normalIndicatorWidth == this.checkedIndicatorWidth) {
            this.mPaint.setColor(this.normalColor);
            float left = (float)i * this.normalIndicatorWidth + (float)i * this.indicatorGap;
            canvas.drawRect(left, 0.0f, left + this.normalIndicatorWidth, this.sliderHeight, this.mPaint);
            this.drawSliderStyle(canvas);
        } else if (i < this.currentPosition) {
            this.mPaint.setColor(this.normalColor);
            float left = (float)i * this.minWidth + (float)i * this.indicatorGap;
            canvas.drawRect(left, 0.0f, left + this.minWidth, this.sliderHeight, this.mPaint);
        } else if (i == this.currentPosition) {
            this.mPaint.setColor(this.checkedColor);
            float left = (float)i * this.minWidth + (float)i * this.indicatorGap;
            canvas.drawRect(left, 0.0f, left + this.minWidth + (this.maxWidth - this.minWidth), this.sliderHeight, this.mPaint);
        } else {
            this.mPaint.setColor(this.normalColor);
            float left = (float)i * this.minWidth + (float)i * this.indicatorGap + (this.maxWidth - this.minWidth);
            canvas.drawRect(left, 0.0f, left + this.minWidth, this.sliderHeight, this.mPaint);
        }
    }

    private void smoothSlide(Canvas canvas, int i) {
        this.mPaint.setColor(this.normalColor);
        float left = (float)i * this.maxWidth + (float)i * this.indicatorGap + (this.maxWidth - this.minWidth);
        canvas.drawRect(left, 0.0f, left + this.minWidth, this.sliderHeight, this.mPaint);
        this.drawSliderStyle(canvas);
    }

    @Override
    public void onPageSelected(int position) {
        super.onPageSelected(position);
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        super.onPageScrolled(position, positionOffset, positionOffsetPixels);
    }

    @Override
    public void onPageScrollStateChanged(int state) {
        super.onPageScrollStateChanged(state);
    }

    private void drawSliderStyle(Canvas canvas) {
        this.mPaint.setColor(this.checkedColor);
        float left = (float)this.currentPosition * this.maxWidth + (float)this.currentPosition * this.indicatorGap + (this.maxWidth + this.indicatorGap) * this.slideProgress;
        canvas.drawRect(left, 0.0f, left + this.maxWidth, this.sliderHeight, this.mPaint);
    }

    public DashIndicatorView setSliderHeight(int sliderHeight) {
        this.sliderHeight = sliderHeight;
        return this;
    }
}

