/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import com.zhpan.bannerview.indicator.BaseIndicatorView;

public class CircleIndicatorView
extends BaseIndicatorView {
    private static final String tag = "IndicatorView";
    private float mNormalRadius;
    private float mCheckedRadius;
    private float maxRadius;
    private int height;

    public CircleIndicatorView(Context context) {
        this(context, null);
    }

    public CircleIndicatorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint.setColor(this.normalColor);
        this.mNormalRadius = this.normalIndicatorWidth / 2.0f;
        this.mCheckedRadius = this.checkedIndicatorWidth / 2.0f;
        this.indicatorGap = this.mNormalRadius * 2.0f;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.height = this.getHeight();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mNormalRadius = this.normalIndicatorWidth / 2.0f;
        this.mCheckedRadius = this.checkedIndicatorWidth / 2.0f;
        this.maxRadius = Math.max(this.mCheckedRadius, this.mNormalRadius);
        this.setMeasuredDimension((int)((float)(this.pageSize - 1) * this.indicatorGap + 2.0f * (this.maxRadius + this.mNormalRadius * (float)(this.pageSize - 1))), (int)(2.0f * this.maxRadius));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.pageSize > 1) {
            for (int i = 0; i < this.pageSize; ++i) {
                this.mPaint.setColor(this.normalColor);
                canvas.drawCircle(this.maxRadius + (2.0f * this.mNormalRadius + this.indicatorGap) * (float)i, (float)this.height / 2.0f, this.mNormalRadius, this.mPaint);
            }
            this.drawSliderStyle(canvas);
        }
    }

    @Override
    public void onPageSelected(int position) {
        super.onPageSelected(position);
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        super.onPageScrolled(position, positionOffset, positionOffsetPixels);
    }

    @Override
    public void onPageScrollStateChanged(int state) {
        super.onPageScrollStateChanged(state);
    }

    private void drawSliderStyle(Canvas canvas) {
        this.mPaint.setColor(this.checkedColor);
        canvas.drawCircle(this.maxRadius + (2.0f * this.mNormalRadius + this.indicatorGap) * (float)this.currentPosition + (2.0f * this.mNormalRadius + this.indicatorGap) * this.slideProgress, (float)this.height / 2.0f, this.mCheckedRadius, this.mPaint);
    }
}

