/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import androidx.viewpager.widget.ViewPager;
import java.util.ArrayList;
import java.util.Collections;

public class CatchViewPager
extends ViewPager {
    private ArrayList<Integer> mArrayList = new ArrayList();
    private SparseIntArray mSparseIntArray = new SparseIntArray();
    private boolean mMultiPageOverlay = false;

    public CatchViewPager(Context context) {
        this(context, null);
    }

    public CatchViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.mMultiPageOverlay) {
            if (i == 0 || this.mSparseIntArray.size() != childCount) {
                this.mArrayList.clear();
                this.mSparseIntArray.clear();
                int viewCenterX = this.getViewCenterX((View)this);
                for (int index = 0; index < childCount; ++index) {
                    int indexAbs = Math.abs(viewCenterX - this.getViewCenterX(this.getChildAt(index)));
                    this.mArrayList.add(++indexAbs);
                    this.mSparseIntArray.append(indexAbs, index);
                }
                Collections.sort(this.mArrayList);
            }
            return this.mSparseIntArray.get(this.mArrayList.get(childCount - 1 - i).intValue());
        }
        return super.getChildDrawingOrder(childCount, i);
    }

    private int getViewCenterX(View view) {
        int[] array = new int[2];
        view.getLocationOnScreen(array);
        return array[0] + view.getWidth() / 2;
    }

    public void setMultiPageOverlay(boolean multiPageOverlay) {
        this.mMultiPageOverlay = multiPageOverlay;
    }
}

