/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;
import com.zhpan.bannerview.R;
import com.zhpan.bannerview.adapter.BannerPagerAdapter;
import com.zhpan.bannerview.holder.HolderCreator;
import com.zhpan.bannerview.holder.ViewHolder;
import com.zhpan.bannerview.indicator.BaseIndicatorView;
import com.zhpan.bannerview.indicator.DashIndicatorView;
import com.zhpan.bannerview.indicator.IIndicator;
import com.zhpan.bannerview.indicator.IndicatorFactory;
import com.zhpan.bannerview.provider.BannerScroller;
import com.zhpan.bannerview.provider.ViewStyleSetter;
import com.zhpan.bannerview.transform.PageTransformerFactory;
import com.zhpan.bannerview.transform.pagestyle.ScaleInTransformer;
import com.zhpan.bannerview.utils.DpUtils;
import com.zhpan.bannerview.view.CatchViewPager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class BannerViewPager<T, VH extends ViewHolder>
extends RelativeLayout
implements ViewPager.OnPageChangeListener {
    private CatchViewPager mViewPager;
    private List<T> mList;
    private int interval;
    private int currentPosition;
    private boolean isLooping;
    private boolean isCanLoop;
    private boolean isAutoPlay = false;
    private boolean showIndicator = true;
    private int gravity;
    private int indicatorNormalColor;
    private int indicatorCheckedColor;
    private int normalIndicatorWidth;
    private int checkedIndicatorWidth;
    private OnPageClickListener mOnPageClickListener;
    private IIndicator mIndicatorView;
    private RelativeLayout mRelativeLayout;
    private int mPageMargin;
    private int mRevealWidth;
    private int mIndicatorStyle;
    private int mIndicatorSlideMode;
    private HolderCreator<VH> holderCreator;
    private BannerScroller mScroller;
    private int indicatorGap;
    private int indicatorHeight;
    private boolean isCustomIndicator;
    private int mPageStyle = 0;
    private Handler mHandler = new Handler();
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            if (BannerViewPager.this.mList.size() > 1) {
                BannerViewPager.this.currentPosition = BannerViewPager.this.currentPosition % (BannerViewPager.this.mList.size() + 1) + 1;
                if (BannerViewPager.this.currentPosition == 1) {
                    BannerViewPager.this.mViewPager.setCurrentItem(BannerViewPager.this.currentPosition, false);
                    BannerViewPager.this.mHandler.post(BannerViewPager.this.mRunnable);
                } else {
                    BannerViewPager.this.mViewPager.setCurrentItem(BannerViewPager.this.currentPosition, true);
                    BannerViewPager.this.mHandler.postDelayed(BannerViewPager.this.mRunnable, (long)BannerViewPager.this.interval);
                }
            }
        }
    };
    public static final int DEFAULT_SCROLL_DURATION = 800;
    private IndicatorMargin mIndicatorMargin;

    public BannerViewPager(Context context) {
        this(context, null);
    }

    public BannerViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.initValues(attrs);
        this.initView();
        this.initScroller();
    }

    private void initView() {
        BannerViewPager.inflate((Context)this.getContext(), (int)R.layout.layout_banner_view_pager, (ViewGroup)this);
        this.mViewPager = (CatchViewPager)this.findViewById(R.id.vp_main);
        this.mRelativeLayout = (RelativeLayout)this.findViewById(R.id.rl_indicator);
        this.mList = new ArrayList<T>();
    }

    private void initValues(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.BannerViewPager);
            this.interval = typedArray.getInteger(R.styleable.BannerViewPager_bvp_interval, 3000);
            this.indicatorCheckedColor = typedArray.getColor(R.styleable.BannerViewPager_bvp_indicator_checked_color, Color.parseColor((String)"#8C18171C"));
            this.indicatorNormalColor = typedArray.getColor(R.styleable.BannerViewPager_bvp_indicator_normal_color, Color.parseColor((String)"#8C6C6D72"));
            this.indicatorGap = this.normalIndicatorWidth = (int)typedArray.getDimension(R.styleable.BannerViewPager_bvp_indicator_radius, (float)DpUtils.dp2px(8.0f));
            this.indicatorHeight = this.normalIndicatorWidth / 2;
            this.checkedIndicatorWidth = this.normalIndicatorWidth;
            this.isAutoPlay = typedArray.getBoolean(R.styleable.BannerViewPager_bvp_auto_play, true);
            this.isCanLoop = typedArray.getBoolean(R.styleable.BannerViewPager_bvp_can_loop, true);
            this.mPageMargin = (int)typedArray.getDimension(R.styleable.BannerViewPager_bvp_page_margin, 0.0f);
            this.mRevealWidth = (int)typedArray.getDimension(R.styleable.BannerViewPager_bvp_reveal_width, 0.0f);
            this.gravity = typedArray.getInt(R.styleable.BannerViewPager_bvp_indicator_gravity, 0);
            this.mPageStyle = typedArray.getInt(R.styleable.BannerViewPager_bvp_page_style, 0);
            this.mIndicatorStyle = typedArray.getInt(R.styleable.BannerViewPager_bvp_indicator_style, 0);
            this.mIndicatorSlideMode = typedArray.getInt(R.styleable.BannerViewPager_bvp_indicator_slide_mode, 0);
            typedArray.recycle();
        }
    }

    private void initScroller() {
        try {
            this.mScroller = new BannerScroller(this.mViewPager.getContext());
            this.mScroller.setDuration(800);
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            mField.set((Object)this.mViewPager, (Object)this.mScroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initData() {
        if (this.mList.size() > 0) {
            if (this.mList.size() > 1 && this.showIndicator) {
                if (this.isCustomIndicator && null != this.mIndicatorView) {
                    this.initIndicator(this.mIndicatorView);
                } else {
                    this.initIndicator(this.getIndicatorView());
                }
            }
            if (this.isCanLoop) {
                this.currentPosition = this.mPageStyle == 0 ? 1 : 2;
            }
            this.setupViewPager();
        }
    }

    private BaseIndicatorView getIndicatorView() {
        BaseIndicatorView indicatorView = IndicatorFactory.createIndicatorView(this.getContext(), this.mIndicatorStyle);
        indicatorView.setPageSize(this.mList.size());
        indicatorView.setIndicatorWidth(this.normalIndicatorWidth, this.checkedIndicatorWidth);
        indicatorView.setIndicatorGap(this.indicatorGap);
        indicatorView.setCheckedColor(this.indicatorCheckedColor);
        indicatorView.setNormalColor(this.indicatorNormalColor);
        indicatorView.setSlideMode(this.mIndicatorSlideMode);
        if (indicatorView instanceof DashIndicatorView) {
            ((DashIndicatorView)indicatorView).setSliderHeight(this.indicatorHeight);
        }
        indicatorView.invalidate();
        return indicatorView;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setTouchListener() {
        this.mViewPager.setOnTouchListener((v, event) -> {
            int action = event.getAction();
            switch (action) {
                case 0: 
                case 2: {
                    this.isLooping = true;
                    this.stopLoop();
                    break;
                }
                case 1: 
                case 3: {
                    this.isLooping = false;
                    this.startLoop();
                }
            }
            return false;
        });
    }

    private void initIndicator(IIndicator indicatorView) {
        this.mRelativeLayout.removeAllViews();
        this.mRelativeLayout.addView((View)indicatorView);
        this.mIndicatorView = indicatorView;
        this.setIndicatorViewMargin();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)((View)indicatorView).getLayoutParams();
        switch (this.gravity) {
            case 0: {
                layoutParams.addRule(14);
                break;
            }
            case 1: {
                layoutParams.addRule(20);
                break;
            }
            case 2: {
                layoutParams.addRule(21);
            }
        }
    }

    private void setIndicatorViewMargin() {
        if (this.mIndicatorMargin != null) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRelativeLayout.getLayoutParams();
            layoutParams.rightMargin = this.mIndicatorMargin.right;
            layoutParams.bottomMargin = this.mIndicatorMargin.bottom;
            layoutParams.topMargin = this.mIndicatorMargin.top;
            layoutParams.leftMargin = this.mIndicatorMargin.left;
        }
    }

    private void setupViewPager() {
        if (this.holderCreator == null) {
            throw new NullPointerException("You must set HolderCreator for BannerViewPager");
        }
        BannerPagerAdapter<T, VH> bannerPagerAdapter = new BannerPagerAdapter<T, VH>(this.mList, this.holderCreator);
        bannerPagerAdapter.setPageStyle(this.mPageStyle);
        bannerPagerAdapter.setPageClickListener(position -> {
            if (this.mOnPageClickListener != null) {
                this.mOnPageClickListener.onPageClick(this.getRealPosition(position));
            }
        });
        bannerPagerAdapter.setCanLoop(this.isCanLoop);
        this.mViewPager.setAdapter(bannerPagerAdapter);
        this.mViewPager.setCurrentItem(this.currentPosition);
        this.mViewPager.addOnPageChangeListener(this);
        this.initPageStyle();
        this.startLoop();
        this.setTouchListener();
    }

    private void initPageStyle() {
        switch (this.mPageStyle) {
            case 1: {
                this.setMultiPageStyle();
                break;
            }
            case 2: {
                this.setMultiPageOverlayStyle();
            }
        }
    }

    private void setMultiPageOverlayStyle() {
        this.mPageMargin = this.mPageMargin == 0 ? DpUtils.dp2px(20.0f) : this.mPageMargin;
        this.mRevealWidth = this.mRevealWidth == 0 ? DpUtils.dp2px(20.0f) : this.mRevealWidth;
        this.setClipChildren(false);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mViewPager.getLayoutParams();
        params.leftMargin = this.mPageMargin + this.mRevealWidth;
        params.rightMargin = this.mPageMargin + this.mRevealWidth;
        this.mViewPager.setPageMargin(-this.mPageMargin);
        this.mViewPager.setMultiPageOverlay(true);
        this.mViewPager.setOffscreenPageLimit(2);
        this.setPageTransformer(new ScaleInTransformer());
    }

    public void onPageSelected(int position) {
        this.currentPosition = position;
        if (this.showIndicator && this.mIndicatorView != null) {
            this.mIndicatorView.onPageSelected(this.getRealPosition(position));
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.showIndicator && this.mIndicatorView != null) {
            this.mIndicatorView.onPageScrollStateChanged(state);
        }
        if (this.isCanLoop) {
            switch (state) {
                case 0: {
                    if (this.currentPosition == 0) {
                        this.mViewPager.setCurrentItem(this.mList.size(), false);
                        break;
                    }
                    if (this.currentPosition != this.mList.size() + 1) break;
                    this.mViewPager.setCurrentItem(1, false);
                    break;
                }
                case 1: {
                    if (this.currentPosition == this.mList.size() + 1) {
                        this.mViewPager.setCurrentItem(1, false);
                        break;
                    }
                    if (this.currentPosition != 0) break;
                    this.mViewPager.setCurrentItem(this.mList.size(), false);
                }
            }
        } else {
            this.mViewPager.setCurrentItem(this.currentPosition);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.showIndicator && this.mIndicatorView != null) {
            this.mIndicatorView.onPageScrolled(this.getRealPosition(position), positionOffset, positionOffsetPixels);
        }
    }

    private int getRealPosition(int position) {
        if (this.isCanLoop) {
            if (this.mPageStyle == 0) {
                if (position == 0) {
                    return this.mList.size() - 1;
                }
                if (position == this.mList.size() + 1) {
                    return 0;
                }
                return --position;
            }
            if (position == 0) {
                return this.mList.size() == 1 ? 0 : this.mList.size() - 2;
            }
            if (position == 1) {
                return this.mList.size() - 1;
            }
            if (position == this.mList.size() + 3) {
                return 1;
            }
            if (position == this.mList.size() + 2) {
                return 0;
            }
            return position - 2;
        }
        return position;
    }

    private int toUnrealPosition(int position) {
        if (this.isCanLoop) {
            if (this.mPageStyle == 0) {
                return position < this.mList.size() ? ++position : this.mList.size();
            }
            return position < this.mList.size() ? position + 2 : this.mList.size() + 1;
        }
        return position;
    }

    public List<T> getList() {
        return this.mList;
    }

    public void startLoop() {
        if (!this.isLooping && this.isAutoPlay && this.mList.size() > 1) {
            this.mHandler.postDelayed(this.mRunnable, (long)this.interval);
            this.isLooping = true;
        }
    }

    public void stopLoop() {
        if (this.isLooping) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.isLooping = false;
        }
    }

    public BannerViewPager<T, VH> setHolderCreator(HolderCreator<VH> holderCreator) {
        this.holderCreator = holderCreator;
        return this;
    }

    public BannerViewPager<T, VH> setRoundCorner(int radius) {
        if (Build.VERSION.SDK_INT >= 21) {
            ViewStyleSetter viewStyleSetter = new ViewStyleSetter((View)this);
            viewStyleSetter.setRoundCorner(radius);
        }
        return this;
    }

    public BannerViewPager<T, VH> setAutoPlay(boolean autoPlay) {
        this.isAutoPlay = autoPlay;
        if (this.isAutoPlay) {
            this.isCanLoop = true;
        }
        return this;
    }

    public BannerViewPager<T, VH> setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
        if (!canLoop) {
            this.isAutoPlay = false;
        }
        return this;
    }

    public BannerViewPager<T, VH> setInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public BannerViewPager<T, VH> setPageTransformerStyle(int style) {
        this.mViewPager.setPageTransformer(true, new PageTransformerFactory().createPageTransformer(style));
        return this;
    }

    public void setPageTransformer(@Nullable ViewPager.PageTransformer transformer) {
        this.mViewPager.setPageTransformer(true, transformer);
    }

    public BannerViewPager<T, VH> setOnPageClickListener(OnPageClickListener onPageClickListener) {
        this.mOnPageClickListener = onPageClickListener;
        return this;
    }

    public BannerViewPager<T, VH> setScrollDuration(int scrollDuration) {
        this.mScroller.setDuration(scrollDuration);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorColor(@ColorInt int normalColor, @ColorInt int checkedColor) {
        this.indicatorCheckedColor = checkedColor;
        this.indicatorNormalColor = normalColor;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorRadius(int radius) {
        this.normalIndicatorWidth = radius * 2;
        this.checkedIndicatorWidth = radius * 2;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorRadius(int normalRadius, int checkRadius) {
        this.normalIndicatorWidth = normalRadius * 2;
        this.checkedIndicatorWidth = checkRadius * 2;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorWidth(int indicatorWidth) {
        this.normalIndicatorWidth = indicatorWidth;
        this.checkedIndicatorWidth = indicatorWidth;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorWidth(int normalWidth, int checkWidth) {
        this.normalIndicatorWidth = normalWidth;
        this.checkedIndicatorWidth = checkWidth;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorHeight(int indicatorHeight) {
        this.indicatorHeight = indicatorHeight;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorGap(int indicatorGap) {
        this.indicatorGap = indicatorGap;
        return this;
    }

    public BannerViewPager<T, VH> showIndicator(boolean showIndicator) {
        this.showIndicator = showIndicator;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorSlideMode(int slideMode) {
        this.mIndicatorSlideMode = slideMode;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorView(IIndicator customIndicator) {
        if (customIndicator instanceof View) {
            this.isCustomIndicator = true;
            this.mIndicatorView = customIndicator;
        }
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorStyle(int indicatorStyle) {
        this.mIndicatorStyle = indicatorStyle;
        return this;
    }

    public void create(List<T> list) {
        if (list != null) {
            this.mList.clear();
            this.mList.addAll(list);
            this.initData();
            if (this.showIndicator && null != this.mIndicatorView) {
                this.mIndicatorView.setPageSize(this.mList.size());
                this.mIndicatorView.notifyDataChanged();
            }
        }
    }

    public int getCurrentItem() {
        return this.getRealPosition(this.currentPosition);
    }

    public void setCurrentItem(int item) {
        this.mViewPager.setCurrentItem(this.toUnrealPosition(item));
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.mViewPager.setCurrentItem(this.toUnrealPosition(item), smoothScroll);
    }

    public BannerViewPager<T, VH> setPageStyle(int pageStyle) {
        this.mPageStyle = pageStyle;
        return this;
    }

    private void setMultiPageStyle() {
        this.mPageMargin = this.mPageMargin == 0 ? DpUtils.dp2px(20.0f) : this.mPageMargin;
        this.mRevealWidth = this.mRevealWidth == 0 ? DpUtils.dp2px(20.0f) : this.mRevealWidth;
        this.setClipChildren(false);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mViewPager.getLayoutParams();
        params.leftMargin = this.mPageMargin + this.mRevealWidth;
        params.rightMargin = this.mPageMargin + this.mRevealWidth;
        this.mViewPager.setPageMargin(this.mPageMargin);
        this.mViewPager.setOffscreenPageLimit(2);
        this.setPageTransformer(new ScaleInTransformer());
    }

    public BannerViewPager<T, VH> setPageMargin(int pageMargin) {
        this.mPageMargin = pageMargin;
        this.mViewPager.setPageMargin(pageMargin);
        return this;
    }

    public BannerViewPager<T, VH> setRevealWidth(int revealWidth) {
        this.mRevealWidth = revealWidth;
        return this;
    }

    @Deprecated
    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public BannerViewPager<T, VH> setIndicatorMargin(int left, int top, int right, int bottom) {
        this.mIndicatorMargin = new IndicatorMargin();
        this.mIndicatorMargin.setBottom(bottom);
        this.mIndicatorMargin.setLeft(left);
        this.mIndicatorMargin.setTop(top);
        this.mIndicatorMargin.setRight(right);
        return this;
    }

    @Deprecated
    public void resetIndicator() {
        this.isCustomIndicator = false;
        this.mIndicatorView = null;
    }

    public static class IndicatorMargin {
        private int left;
        private int right;
        private int top;
        private int bottom;

        public int getLeft() {
            return this.left;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public int getRight() {
            return this.right;
        }

        public void setRight(int right) {
            this.right = right;
        }

        public int getTop() {
            return this.top;
        }

        public void setTop(int top) {
            this.top = top;
        }

        public int getBottom() {
            return this.bottom;
        }

        public void setBottom(int bottom) {
            this.bottom = bottom;
        }
    }

    public static interface OnPageClickListener {
        public void onPageClick(int var1);
    }
}

