/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.jdbc;

import com.github.zhengframework.configuration.Configuration;
import com.github.zhengframework.configuration.ConfigurationAware;
import com.github.zhengframework.configuration.ConfigurationBeanMapper;
import com.github.zhengframework.jdbc.DSLContextProvider;
import com.github.zhengframework.jdbc.JooqConfig;
import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.conf.Settings;

public class JooqModule
extends AbstractModule
implements ConfigurationAware {
    private Configuration configuration;

    protected void configure() {
        Preconditions.checkArgument((this.configuration != null ? 1 : 0) != 0, (Object)"configuration is null");
        Map configMap = ConfigurationBeanMapper.resolve((Configuration)this.configuration, JooqConfig.class);
        for (Map.Entry entry : configMap.entrySet()) {
            String name = (String)entry.getKey();
            JooqConfig jooqConfig = (JooqConfig)entry.getValue();
            if (name.isEmpty()) {
                this.bind(JooqConfig.class).toInstance((Object)jooqConfig);
                if (!jooqConfig.isEnable()) continue;
                OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(SQLDialect.class)).setDefault().toInstance((Object)SQLDialect.DEFAULT);
                this.bind(Key.get(DSLContext.class)).toProvider((Provider)new DSLContextProvider((Provider<DataSource>)this.getProvider(Key.get(DataSource.class)), (Provider<SQLDialect>)this.getProvider(Key.get(SQLDialect.class)), (Provider<Settings>)this.getProvider(Key.get(Settings.class))));
                continue;
            }
            this.bind(Key.get(JooqConfig.class, (Annotation)Names.named((String)name))).toInstance((Object)jooqConfig);
            if (!jooqConfig.isEnable()) continue;
            OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(SQLDialect.class, (Annotation)Names.named((String)name))).setDefault().toInstance((Object)SQLDialect.DEFAULT);
            this.bind(Key.get(DSLContext.class, (Annotation)Names.named((String)name))).toProvider((Provider)new DSLContextProvider((Provider<DataSource>)this.getProvider(Key.get(DataSource.class, (Annotation)Names.named((String)name))), (Provider<SQLDialect>)this.getProvider(Key.get(SQLDialect.class, (Annotation)Names.named((String)name))), (Provider<Settings>)this.getProvider(Key.get(Settings.class))));
        }
    }

    public void initConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JooqModule)) {
            return false;
        }
        JooqModule other = (JooqModule)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Configuration this$configuration = this.configuration;
        Configuration other$configuration = other.configuration;
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JooqModule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Configuration $configuration = this.configuration;
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

