/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.jdbc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.persist.PersistService;
import com.google.inject.persist.UnitOfWork;
import java.sql.SQLException;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JooqPersistService
implements Provider<DSLContext>,
UnitOfWork,
PersistService {
    private static final Logger log = LoggerFactory.getLogger(JooqPersistService.class);
    private final ThreadLocal<DSLContext> threadFactory = new ThreadLocal();
    private final ThreadLocal<DefaultConnectionProvider> threadConnection = new ThreadLocal();
    private final DataSource jdbcSource;
    private final SQLDialect sqlDialect;
    @Inject(optional=true)
    private Settings jooqSettings = null;
    @Inject(optional=true)
    private Configuration configuration = null;

    @Inject
    public JooqPersistService(DataSource jdbcSource, SQLDialect sqlDialect) {
        this.jdbcSource = jdbcSource;
        this.sqlDialect = sqlDialect;
    }

    public DSLContext get() {
        DSLContext factory = this.threadFactory.get();
        if (null == factory) {
            throw new IllegalStateException("Requested Factory outside work unit. Try calling UnitOfWork.begin() first, use @Transactional annotationor use a PersistFilter if you are inside a servlet environment.");
        }
        return factory;
    }

    public boolean isWorking() {
        return this.threadFactory.get() != null;
    }

    public DefaultConnectionProvider getConnectionWrapper() {
        return this.threadConnection.get();
    }

    public void start() {
        DSLContext jooqFactory;
        DefaultConnectionProvider conn;
        if (null != this.threadFactory.get()) {
            throw new IllegalStateException("Work already begun on this thread. It looks like you have called UnitOfWork.begin() twice without a balancing call to end() in between.");
        }
        try {
            log.debug("Getting JDBC connection");
            conn = new DefaultConnectionProvider(this.jdbcSource.getConnection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (this.configuration != null) {
            log.debug("Creating factory from configuration having dialect {}", (Object)this.configuration.dialect());
            if (this.jooqSettings != null) {
                log.warn("@Injected org.jooq.conf.Settings is being ignored since a full org.jooq.Configuration was supplied");
            }
            jooqFactory = DSL.using((Configuration)this.configuration);
        } else if (this.jooqSettings == null) {
            log.debug("Creating factory with dialect {}", (Object)this.sqlDialect);
            jooqFactory = DSL.using((ConnectionProvider)conn, (SQLDialect)this.sqlDialect);
        } else {
            log.debug("Creating factory with dialect {} and settings.", (Object)this.sqlDialect);
            jooqFactory = DSL.using((ConnectionProvider)conn, (SQLDialect)this.sqlDialect, (Settings)this.jooqSettings);
        }
        this.threadConnection.set(conn);
        this.threadFactory.set(jooqFactory);
    }

    public void stop() {
    }

    public void begin() {
    }

    public void end() {
        DSLContext jooqFactory = this.threadFactory.get();
        DefaultConnectionProvider conn = this.threadConnection.get();
        if (null == jooqFactory) {
            return;
        }
        try {
            log.debug("Closing JDBC connection");
            conn.acquire().close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.threadFactory.remove();
        this.threadConnection.remove();
    }
}

