/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.jdbc;

import com.github.zhengframework.jdbc.JooqPersistService;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.persist.Transactional;
import com.google.inject.persist.UnitOfWork;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jooq.impl.DefaultConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcLocalTxnInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(JdbcLocalTxnInterceptor.class);
    private static final ConcurrentMap<Method, Transactional> methodsTransactionals = new ConcurrentHashMap<Method, Transactional>();
    private final Provider<JooqPersistService> jooqPersistServiceProvider;
    private final Provider<UnitOfWork> unitOfWorkProvider;
    private final ThreadLocal<Boolean> didWeStartWork = new ThreadLocal();

    @Inject
    public JdbcLocalTxnInterceptor(Provider<JooqPersistService> jooqPersistServiceProvider, Provider<UnitOfWork> unitOfWorkProvider) {
        this.jooqPersistServiceProvider = jooqPersistServiceProvider;
        this.unitOfWorkProvider = unitOfWorkProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object result;
        UnitOfWork unitOfWork = (UnitOfWork)this.unitOfWorkProvider.get();
        JooqPersistService jooqProvider = (JooqPersistService)this.jooqPersistServiceProvider.get();
        if (!jooqProvider.isWorking()) {
            unitOfWork.begin();
            this.didWeStartWork.set(true);
        }
        Transactional transactional = this.readTransactionMetadata(methodInvocation);
        DefaultConnectionProvider conn = jooqProvider.getConnectionWrapper();
        if (!conn.getAutoCommit()) {
            return methodInvocation.proceed();
        }
        logger.debug("Disabling JDBC auto commit for this thread");
        conn.setAutoCommit(false);
        try {
            result = methodInvocation.proceed();
        }
        catch (Exception e) {
            if (this.rollbackIfNecessary(transactional, e, conn)) {
                logger.debug("Committing JDBC transaction");
                conn.commit();
            }
            logger.debug("Enabling auto commit for this thread");
            conn.setAutoCommit(true);
            throw e;
        }
        finally {
            if (null != this.didWeStartWork.get() && conn.getAutoCommit()) {
                this.didWeStartWork.remove();
                unitOfWork.end();
            }
        }
        try {
            logger.debug("Committing JDBC transaction");
            conn.commit();
            logger.debug("Enabling auto commit for this thread");
            conn.setAutoCommit(true);
        }
        finally {
            if (null != this.didWeStartWork.get()) {
                this.didWeStartWork.remove();
                unitOfWork.end();
            }
        }
        return result;
    }

    private Transactional readTransactionMetadata(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Transactional cachedTransactional = (Transactional)methodsTransactionals.get(method);
        if (cachedTransactional != null) {
            return cachedTransactional;
        }
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (null == transactional) {
            Class<?> targetClass = methodInvocation.getThis().getClass();
            transactional = targetClass.getAnnotation(Transactional.class);
        }
        if (null != transactional) {
            methodsTransactionals.put(method, transactional);
        } else {
            transactional = Internal.class.getAnnotation(Transactional.class);
        }
        return transactional;
    }

    private boolean rollbackIfNecessary(Transactional transactional, Exception e, DefaultConnectionProvider conn) {
        boolean commit = true;
        for (Class rollBackOn : transactional.rollbackOn()) {
            if (!rollBackOn.isInstance(e)) continue;
            commit = false;
            for (Class exceptOn : transactional.ignore()) {
                if (!exceptOn.isInstance(e)) continue;
                commit = true;
                break;
            }
            if (commit) break;
            logger.debug("Rolling back JDBC transaction for this thread");
            conn.rollback();
            break;
        }
        return commit;
    }

    @Transactional
    private static class Internal {
        private Internal() {
        }
    }
}

