/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.jdbc;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;

public class DSLContextProvider
implements Provider<DSLContext> {
    private final Annotation qualifier;
    private final Provider<Injector> injectorProvider;

    public DSLContextProvider(Annotation qualifier, Provider<Injector> injectorProvider) {
        this.qualifier = qualifier;
        this.injectorProvider = injectorProvider;
    }

    public DSLContext get() {
        SQLDialect sqlDialect;
        DataSource dataSource;
        Injector injector = (Injector)this.injectorProvider.get();
        if (this.qualifier == null) {
            dataSource = (DataSource)injector.getInstance(Key.get(DataSource.class));
            sqlDialect = (SQLDialect)injector.getInstance(Key.get(SQLDialect.class));
        } else {
            dataSource = (DataSource)injector.getInstance(Key.get(DataSource.class, (Annotation)this.qualifier));
            sqlDialect = (SQLDialect)injector.getInstance(Key.get(SQLDialect.class, (Annotation)this.qualifier));
        }
        return DSL.using((DataSource)dataSource, (SQLDialect)sqlDialect);
    }
}

