/*
 * Decompiled with CFR 0.152.
 */
package com.internetitem.logback.elasticsearch;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import com.fasterxml.jackson.core.JsonGenerator;
import com.internetitem.logback.elasticsearch.AbstractElasticsearchPublisher;
import com.internetitem.logback.elasticsearch.config.ElasticsearchProperties;
import com.internetitem.logback.elasticsearch.config.HttpRequestHeaders;
import com.internetitem.logback.elasticsearch.config.Property;
import com.internetitem.logback.elasticsearch.config.Settings;
import com.internetitem.logback.elasticsearch.util.AbstractPropertyAndEncoder;
import com.internetitem.logback.elasticsearch.util.ClassicPropertyAndEncoder;
import com.internetitem.logback.elasticsearch.util.ErrorReporter;
import java.io.IOException;
import java.util.Map;

public class ClassicElasticsearchPublisher
extends AbstractElasticsearchPublisher<ILoggingEvent> {
    public ClassicElasticsearchPublisher(Context context, ErrorReporter errorReporter, Settings settings, ElasticsearchProperties properties, HttpRequestHeaders headers) throws IOException {
        super(context, errorReporter, settings, properties, headers);
    }

    @Override
    protected AbstractPropertyAndEncoder<ILoggingEvent> buildPropertyAndEncoder(Context context, Property property) {
        return new ClassicPropertyAndEncoder(property, context);
    }

    @Override
    protected void serializeCommonFields(JsonGenerator gen, ILoggingEvent event) throws IOException {
        gen.writeObjectField("@timestamp", (Object)ClassicElasticsearchPublisher.getTimestamp(event.getTimeStamp()));
        if (this.settings.isRawJsonMessage()) {
            gen.writeFieldName("message");
            gen.writeRawValue(event.getFormattedMessage());
        } else {
            String formattedMessage = event.getFormattedMessage();
            if (this.settings.getMaxMessageSize() > 0 && formattedMessage.length() > this.settings.getMaxMessageSize()) {
                formattedMessage = formattedMessage.substring(0, this.settings.getMaxMessageSize()) + "..";
            }
            gen.writeObjectField("message", (Object)formattedMessage);
        }
        if (this.settings.isIncludeMdc()) {
            for (Map.Entry entry : event.getMDCPropertyMap().entrySet()) {
                gen.writeObjectField((String)entry.getKey(), entry.getValue());
            }
        }
    }
}

