/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.StyleRes;
import android.support.v4.widget.PopupWindowCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.AppCompatPopupWindow;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import com.github.zawadz88.materialpopupmenu.R;
import com.github.zawadz88.materialpopupmenu.internal.PopupMenuAdapter;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 12\u00020\u0001:\u00011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001f\u001a\u00020\u0005H\u0002J\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\tH\u0002J\u000e\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u0005J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020(H\u0002J\u0006\u00100\u001a\u00020!R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Landroid/support/v7/widget/MaterialRecyclerViewPopupWindow;", "", "context", "Landroid/content/Context;", "dropDownGravity", "", "defStyleRes", "(Landroid/content/Context;II)V", "value", "Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter;", "adapter", "getAdapter$material_popup_menu_release", "()Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter;", "setAdapter$material_popup_menu_release", "(Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter;)V", "anchorView", "Landroid/view/View;", "getAnchorView$material_popup_menu_release", "()Landroid/view/View;", "setAnchorView$material_popup_menu_release", "(Landroid/view/View;)V", "dropDownHorizontalOffset", "dropDownVerticalOffset", "dropDownWidth", "popup", "Landroid/widget/PopupWindow;", "popupMaxWidth", "popupMinWidth", "popupWidthUnit", "tempRect", "Landroid/graphics/Rect;", "buildDropDown", "dismiss", "", "generateDefaultLayoutParams", "Landroid/support/v7/widget/RecyclerView$LayoutParams;", "getMaxAvailableHeight", "anchor", "yOffset", "ignoreBottomDecorations", "", "measureHeightOfChildrenCompat", "maxHeight", "measureIndividualMenuWidth", "setContentWidth", "width", "setPopupClipToScreenEnabled", "clip", "show", "Companion", "material-popup-menu_release"})
public final class MaterialRecyclerViewPopupWindow {
    @Nullable
    private View anchorView;
    @Nullable
    private PopupMenuAdapter adapter;
    private int dropDownWidth;
    private int dropDownVerticalOffset;
    private int dropDownHorizontalOffset;
    private final Rect tempRect;
    private final PopupWindow popup;
    private final int popupMaxWidth;
    private final int popupMinWidth;
    private final int popupWidthUnit;
    private final Context context;
    private int dropDownGravity;
    private static final String TAG = "MaterialRVPopupWindow";
    private static Method sClipToWindowEnabledMethod;
    private static Method sGetMaxAvailableHeightMethod;
    public static final Companion Companion;

    @Nullable
    public final View getAnchorView$material_popup_menu_release() {
        return this.anchorView;
    }

    public final void setAnchorView$material_popup_menu_release(@Nullable View view) {
        this.anchorView = view;
    }

    @Nullable
    public final PopupMenuAdapter getAdapter$material_popup_menu_release() {
        return this.adapter;
    }

    public final void setAdapter$material_popup_menu_release(@Nullable PopupMenuAdapter value) {
        MaterialRecyclerViewPopupWindow materialRecyclerViewPopupWindow = this;
        MaterialRecyclerViewPopupWindow materialRecyclerViewPopupWindow2 = this;
        if (value == null) {
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        PopupMenuAdapter popupMenuAdapter = value;
        materialRecyclerViewPopupWindow2.setContentWidth(materialRecyclerViewPopupWindow.measureIndividualMenuWidth(popupMenuAdapter));
        this.adapter = value;
    }

    public final void setContentWidth(int width) {
        Drawable popupBackground = this.popup.getBackground();
        if (popupBackground != null) {
            popupBackground.getPadding(this.tempRect);
            this.dropDownWidth = this.tempRect.left + this.tempRect.right + width;
        } else {
            this.dropDownWidth = width;
        }
    }

    public final void show() {
        View view = this.anchorView;
        if (view == null) {
            String string = "Anchor view must be set!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int height = this.buildDropDown();
        PopupWindowCompat.setWindowLayoutType((PopupWindow)this.popup, (int)1002);
        int heightSpec = height;
        int widthSpec = this.dropDownWidth;
        if (this.popup.isShowing()) {
            this.popup.setOutsideTouchable(true);
            this.popup.update(this.anchorView, this.dropDownHorizontalOffset, this.dropDownVerticalOffset, widthSpec, heightSpec < 0 ? -1 : heightSpec);
        } else {
            this.popup.setWidth(widthSpec);
            this.popup.setHeight(heightSpec);
            this.setPopupClipToScreenEnabled(true);
            this.popup.setOutsideTouchable(true);
            View view2 = this.anchorView;
            if (view2 == null) {
                Intrinsics.throwNpe();
            }
            PopupWindowCompat.showAsDropDown((PopupWindow)this.popup, (View)view2, (int)this.dropDownHorizontalOffset, (int)this.dropDownVerticalOffset, (int)this.dropDownGravity);
        }
    }

    public final void dismiss() {
        this.popup.dismiss();
        this.popup.setContentView((View)null);
    }

    private final int buildDropDown() {
        int maxHeight;
        int listContent;
        int padding;
        int otherHeights = 0;
        View view = View.inflate((Context)this.context, (int)R.layout.mpm_popup_menu, null);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.support.v7.widget.RecyclerView");
        }
        RecyclerView dropDownList = (RecyclerView)view;
        dropDownList.setAdapter((RecyclerView.Adapter)this.adapter);
        dropDownList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        dropDownList.setFocusable(true);
        dropDownList.setFocusableInTouchMode(true);
        this.popup.setContentView((View)dropDownList);
        Drawable background = this.popup.getBackground();
        if (background != null) {
            background.getPadding(this.tempRect);
            padding = this.tempRect.top + this.tempRect.bottom;
            this.dropDownVerticalOffset = -this.tempRect.top;
        } else {
            this.tempRect.setEmpty();
            padding = 0;
        }
        boolean ignoreBottomDecorations = this.popup.getInputMethodMode() == 2;
        View view2 = this.anchorView;
        if (view2 == null) {
            Intrinsics.throwNpe();
        }
        if ((listContent = this.measureHeightOfChildrenCompat((maxHeight = this.getMaxAvailableHeight(view2, this.dropDownVerticalOffset, ignoreBottomDecorations)) - otherHeights)) > 0) {
            int listPadding = dropDownList.getPaddingTop() + dropDownList.getPaddingBottom();
            otherHeights += padding + listPadding;
        }
        return listContent + otherHeights;
    }

    /*
     * WARNING - void declaration
     */
    private final int measureHeightOfChildrenCompat(int maxHeight) {
        FrameLayout parent = new FrameLayout(this.context);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int returnedHeight = 0;
        PopupMenuAdapter popupMenuAdapter = this.adapter;
        int n = 0;
        int count = popupMenuAdapter != null ? popupMenuAdapter.getItemCount() : 0;
        int n2 = count - 1;
        if (n <= n2) {
            while (true) {
                View itemView;
                void i;
                PopupMenuAdapter popupMenuAdapter2 = this.adapter;
                if (popupMenuAdapter2 == null) {
                    Intrinsics.throwNpe();
                }
                int positionType = popupMenuAdapter2.getItemViewType((int)i);
                PopupMenuAdapter popupMenuAdapter3 = this.adapter;
                if (popupMenuAdapter3 == null) {
                    Intrinsics.throwNpe();
                }
                RecyclerView.ViewHolder vh = popupMenuAdapter3.createViewHolder((ViewGroup)parent, positionType);
                PopupMenuAdapter popupMenuAdapter4 = this.adapter;
                if (popupMenuAdapter4 == null) {
                    Intrinsics.throwNpe();
                }
                popupMenuAdapter4.bindViewHolder(vh, (int)i);
                View view = itemView = vh.itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                ViewGroup.LayoutParams childLp = view.getLayoutParams();
                if (childLp == null) {
                    childLp = (ViewGroup.LayoutParams)this.generateDefaultLayoutParams();
                    itemView.setLayoutParams(childLp);
                }
                int heightMeasureSpec = childLp.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)childLp.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                itemView.measure(widthMeasureSpec, heightMeasureSpec);
                if ((returnedHeight += itemView.getMeasuredHeight()) >= maxHeight) {
                    return maxHeight;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return returnedHeight;
    }

    private final RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-1, -2);
    }

    private final void setPopupClipToScreenEnabled(boolean clip) {
        block2: {
            Method method;
            Method method2 = MaterialRecyclerViewPopupWindow.Companion.getSClipToWindowEnabledMethod();
            if (method2 == null) break block2;
            Method it = method = method2;
            try {
                Object object = it.invoke((Object)this.popup, clip);
            }
            catch (Exception e) {
                Integer n = Log.i((String)MaterialRecyclerViewPopupWindow.Companion.getTAG(), (String)"Could not call setClipToScreenEnabled() on PopupWindow. Oh well.");
            }
        }
    }

    private final int getMaxAvailableHeight(View anchor, int yOffset, boolean ignoreBottomDecorations) {
        Method method = MaterialRecyclerViewPopupWindow.Companion.getSGetMaxAvailableHeightMethod();
        if (method != null) {
            Method method2;
            Method it = method2 = method;
            try {
                Object object = it.invoke((Object)this.popup, anchor, yOffset, ignoreBottomDecorations);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                return (Integer)object;
            }
            catch (Exception e) {
                int n = Log.i((String)MaterialRecyclerViewPopupWindow.Companion.getTAG(), (String)"Could not call getMaxAvailableHeightMethod(View, int, boolean) on PopupWindow. Using the public version.");
            }
        }
        return this.popup.getMaxAvailableHeight(anchor, yOffset);
    }

    /*
     * WARNING - void declaration
     */
    private final int measureIndividualMenuWidth(PopupMenuAdapter adapter2) {
        adapter2.setupIndices();
        FrameLayout parent = new FrameLayout(this.context);
        int menuWidth = this.popupMinWidth;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int count = adapter2.getItemCount();
        int n = 0;
        int n2 = count - 1;
        if (n <= n2) {
            while (true) {
                void i;
                int positionType = adapter2.getItemViewType((int)i);
                RecyclerView.ViewHolder vh = adapter2.createViewHolder((ViewGroup)parent, positionType);
                adapter2.bindViewHolder(vh, (int)i);
                View itemView = vh.itemView;
                itemView.measure(widthMeasureSpec, heightMeasureSpec);
                View view = itemView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
                int itemWidth = view.getMeasuredWidth();
                if (itemWidth >= this.popupMaxWidth) {
                    return this.popupMaxWidth;
                }
                if (itemWidth > menuWidth) {
                    menuWidth = itemWidth;
                }
                if (i == n2) break;
                ++i;
            }
        }
        menuWidth = (int)Math.ceil((double)menuWidth / (double)this.popupWidthUnit) * this.popupWidthUnit;
        return menuWidth;
    }

    public MaterialRecyclerViewPopupWindow(@NotNull Context context, int dropDownGravity, @StyleRes int defStyleRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.dropDownGravity = dropDownGravity;
        this.dropDownWidth = -2;
        this.tempRect = new Rect();
        this.popup = (PopupWindow)new AppCompatPopupWindow(this.context, null, 0, defStyleRes);
        ((AppCompatPopupWindow)this.popup).setInputMethodMode(1);
        ((AppCompatPopupWindow)this.popup).setFocusable(true);
        this.popupMaxWidth = this.context.getResources().getDimensionPixelSize(R.dimen.mpm_popup_menu_max_width);
        this.popupMinWidth = this.context.getResources().getDimensionPixelSize(R.dimen.mpm_popup_menu_min_width);
        this.popupWidthUnit = this.context.getResources().getDimensionPixelSize(R.dimen.mpm_popup_menu_width_unit);
        TypedArray a = this.context.obtainStyledAttributes(null, R.styleable.ListPopupWindow, 0, defStyleRes);
        this.dropDownHorizontalOffset = a.getDimensionPixelOffset(R.styleable.ListPopupWindow_android_dropDownHorizontalOffset, 0);
        a.recycle();
    }

    static {
        Companion = new Companion(null);
        TAG = TAG;
        try {
            MaterialRecyclerViewPopupWindow.Companion.setSClipToWindowEnabledMethod(PopupWindow.class.getDeclaredMethod("setClipToScreenEnabled", JvmClassMappingKt.getJavaPrimitiveType((KClass)Reflection.getOrCreateKotlinClass(Boolean.TYPE))));
        }
        catch (NoSuchMethodException e) {
            Log.i((String)MaterialRecyclerViewPopupWindow.Companion.getTAG(), (String)"Could not find method setClipToScreenEnabled() on PopupWindow. Oh well.");
        }
        try {
            MaterialRecyclerViewPopupWindow.Companion.setSGetMaxAvailableHeightMethod(PopupWindow.class.getDeclaredMethod("getMaxAvailableHeight", View.class, JvmClassMappingKt.getJavaPrimitiveType((KClass)Reflection.getOrCreateKotlinClass(Integer.TYPE)), JvmClassMappingKt.getJavaPrimitiveType((KClass)Reflection.getOrCreateKotlinClass(Boolean.TYPE))));
        }
        catch (NoSuchMethodException e) {
            Log.i((String)MaterialRecyclerViewPopupWindow.Companion.getTAG(), (String)"Could not find method getMaxAvailableHeight(View, int, boolean) on PopupWindow. Oh well.");
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f\u00a8\u0006\u0010"}, d2={"Landroid/support/v7/widget/MaterialRecyclerViewPopupWindow$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "sClipToWindowEnabledMethod", "Ljava/lang/reflect/Method;", "getSClipToWindowEnabledMethod", "()Ljava/lang/reflect/Method;", "setSClipToWindowEnabledMethod", "(Ljava/lang/reflect/Method;)V", "sGetMaxAvailableHeightMethod", "getSGetMaxAvailableHeightMethod", "setSGetMaxAvailableHeightMethod", "material-popup-menu_release"})
    public static final class Companion {
        private final String getTAG() {
            return TAG;
        }

        private final Method getSClipToWindowEnabledMethod() {
            return sClipToWindowEnabledMethod;
        }

        private final void setSClipToWindowEnabledMethod(Method method) {
            sClipToWindowEnabledMethod = method;
        }

        private final Method getSGetMaxAvailableHeightMethod() {
            return sGetMaxAvailableHeightMethod;
        }

        private final void setSGetMaxAvailableHeightMethod(Method method) {
            sGetMaxAvailableHeightMethod = method;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

