/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl.middle;

import com.zakgof.velvetvideo.IVideoDecoderStream;
import com.zakgof.velvetvideo.IVideoFrame;
import java.awt.image.BufferedImage;

final class VideoFrameImpl
implements IVideoFrame {
    private final BufferedImage image;
    private final long nanostamp;
    private final long nanoduration;
    private final IVideoDecoderStream stream;

    public String toString() {
        return "Video frame t=" + this.nanostamp + " stream:" + this.stream.name();
    }

    public VideoFrameImpl(BufferedImage image, long nanostamp, long nanoduration, IVideoDecoderStream stream) {
        this.image = image;
        this.nanostamp = nanostamp;
        this.nanoduration = nanoduration;
        this.stream = stream;
    }

    @Override
    public BufferedImage image() {
        return this.image;
    }

    @Override
    public long nanostamp() {
        return this.nanostamp;
    }

    @Override
    public long nanoduration() {
        return this.nanoduration;
    }

    @Override
    public IVideoDecoderStream stream() {
        return this.stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoFrameImpl)) {
            return false;
        }
        VideoFrameImpl other = (VideoFrameImpl)o;
        BufferedImage this$image = this.image();
        BufferedImage other$image = other.image();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        if (this.nanostamp() != other.nanostamp()) {
            return false;
        }
        if (this.nanoduration() != other.nanoduration()) {
            return false;
        }
        IVideoDecoderStream this$stream = this.stream();
        IVideoDecoderStream other$stream = other.stream();
        return !(this$stream == null ? other$stream != null : !this$stream.equals(other$stream));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BufferedImage $image = this.image();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        long $nanostamp = this.nanostamp();
        result = result * 59 + (int)($nanostamp >>> 32 ^ $nanostamp);
        long $nanoduration = this.nanoduration();
        result = result * 59 + (int)($nanoduration >>> 32 ^ $nanoduration);
        IVideoDecoderStream $stream = this.stream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        return result;
    }
}

