/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl.middle;

import com.zakgof.velvetvideo.IVideoDecoderStream;
import com.zakgof.velvetvideo.IVideoFrame;
import com.zakgof.velvetvideo.VelvetVideoException;
import com.zakgof.velvetvideo.impl.JNRHelper;
import com.zakgof.velvetvideo.impl.VelvetVideoLib;
import com.zakgof.velvetvideo.impl.jnr.AVFrame;
import com.zakgof.velvetvideo.impl.jnr.AVPixelFormat;
import com.zakgof.velvetvideo.impl.jnr.AVRational;
import com.zakgof.velvetvideo.impl.jnr.LibAVUtil;
import com.zakgof.velvetvideo.impl.jnr.LibSwScale;
import com.zakgof.velvetvideo.impl.jnr.SwsContext;
import com.zakgof.velvetvideo.impl.middle.IFrameHolder;
import com.zakgof.velvetvideo.impl.middle.VideoFrameImpl;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;

public class VideoFrameHolder
implements AutoCloseable,
IFrameHolder {
    public final AVFrame frame;
    private final AVFrame biframe;
    private final SwsContext scaleCtx;
    private final int width;
    private final int height;
    private AVRational timebase;
    private static final LibSwScale libswscale = JNRHelper.load(LibSwScale.class, "swscale", 5);
    private static final LibAVUtil libavutil = JNRHelper.load(LibAVUtil.class, "avutil", 56);

    public VideoFrameHolder(int width, int height, AVPixelFormat srcFormat, AVPixelFormat destFormat, AVRational timebase, boolean encode) {
        this.width = width;
        this.height = height;
        this.frame = this.alloc(width, height, encode ? destFormat : srcFormat);
        this.biframe = this.alloc(width, height, encode ? srcFormat : destFormat);
        this.timebase = timebase;
        this.scaleCtx = libswscale.sws_getContext(width, height, srcFormat, width, height, destFormat, 0, null, null, null);
    }

    public AVFrame alloc(int width, int height, AVPixelFormat format) {
        AVFrame f = libavutil.av_frame_alloc();
        f.width.set(width);
        f.height.set(height);
        f.format.set((long)format.ordinal());
        libavutil.checkcode(libavutil.av_frame_get_buffer(f, 0));
        return f;
    }

    public AVFrame setPixels(BufferedImage image) {
        byte[] bytes = VideoFrameHolder.bytesOf(image);
        this.biframe.data[0].get().put(0L, bytes, 0, bytes.length);
        libavutil.checkcode(libswscale.sws_scale(this.scaleCtx, JNRHelper.ptr((Struct.NumberField)this.biframe.data[0]), JNRHelper.ptr((Struct.NumberField)this.biframe.linesize[0]), 0, this.height, JNRHelper.ptr((Struct.NumberField)this.frame.data[0]), JNRHelper.ptr((Struct.NumberField)this.frame.linesize[0])));
        return this.frame;
    }

    public BufferedImage getPixels(AVFrame f) {
        libavutil.checkcode(libswscale.sws_scale(this.scaleCtx, JNRHelper.ptr((Struct.NumberField)f.data[0]), JNRHelper.ptr((Struct.NumberField)f.linesize[0]), 0, this.height, JNRHelper.ptr((Struct.NumberField)this.biframe.data[0]), JNRHelper.ptr((Struct.NumberField)this.biframe.linesize[0])));
        BufferedImage bi = new BufferedImage(this.width, this.height, 5);
        byte[] bytes = VideoFrameHolder.bytesOf(bi);
        this.biframe.data[0].get().get(0L, bytes, 0, bytes.length);
        return bi;
    }

    private static byte[] bytesOf(BufferedImage image) {
        WritableRaster raster;
        DataBuffer buffer;
        if (image.getType() != 5) {
            BufferedImage newimage = new BufferedImage(image.getWidth(), image.getHeight(), 5);
            Graphics2D g = newimage.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            image = newimage;
        }
        if ((buffer = (raster = image.getRaster()).getDataBuffer()) instanceof DataBufferByte) {
            return ((DataBufferByte)buffer).getData();
        }
        throw new VelvetVideoException("Unsupported image data buffer type");
    }

    public IVideoFrame decode(AVFrame frame, VelvetVideoLib.DemuxerImpl.AbstractDecoderStream stream) {
        BufferedImage bi = this.getPixels(frame);
        long pts = this.pts();
        if (pts == Long.MIN_VALUE) {
            pts = 0L;
        }
        long nanostamp = pts * 1000000000L * (long)this.timebase.num.get() / (long)this.timebase.den.get();
        long duration = libavutil.av_frame_get_pkt_duration(frame);
        long nanoduration = duration * 1000000000L * (long)this.timebase.num.get() / (long)this.timebase.den.get();
        return new VideoFrameImpl(bi, nanostamp, nanoduration, (IVideoDecoderStream)((Object)stream));
    }

    @Override
    public AVFrame frame() {
        return this.frame;
    }

    @Override
    public void close() {
        libavutil.av_frame_free(new Pointer[]{Struct.getMemory((Struct)this.frame)});
        libavutil.av_frame_free(new Pointer[]{Struct.getMemory((Struct)this.biframe)});
        libswscale.sws_freeContext(this.scaleCtx);
    }
}

