/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl.middle;

import com.zakgof.velvetvideo.impl.JNRHelper;
import com.zakgof.velvetvideo.impl.jnr.AVCodecContext;
import com.zakgof.velvetvideo.impl.jnr.AVFrame;
import com.zakgof.velvetvideo.impl.jnr.LibAVFilter;
import com.zakgof.velvetvideo.impl.jnr.LibAVUtil;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.byref.PointerByReference;
import jnr.ffi.provider.jffi.NativeRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filters
implements AutoCloseable {
    private static final LibAVFilter libavfilter = JNRHelper.load(LibAVFilter.class, "avfilter", 7);
    private static final LibAVUtil libavutil = JNRHelper.load(LibAVUtil.class, "avutil", 56);
    private final Logger logFilter = LoggerFactory.getLogger((String)"velvet-video.filter");
    private final LibAVFilter.AVFilterContext buffersrc_ctx;
    private final LibAVFilter.AVFilterContext buffersink_ctx;
    private final Pointer pixfmts;
    private final LibAVFilter.AVFilterInOut outputs;
    private final LibAVFilter.AVFilterInOut inputs;
    private final LibAVFilter.AVFilter buffersrc;
    private final LibAVFilter.AVFilter buffersink;
    private final LibAVFilter.AVFilterGraph graph = libavfilter.avfilter_graph_alloc();
    private AVFrame workframe;

    public Filters(AVCodecContext codecCtx, String filterString) {
        this.buffersrc = libavfilter.avfilter_get_by_name("buffer");
        this.buffersink = libavfilter.avfilter_get_by_name("buffersink");
        this.outputs = libavfilter.avfilter_inout_alloc();
        this.inputs = libavfilter.avfilter_inout_alloc();
        PointerByReference ppbuffersink_ctx = new PointerByReference();
        PointerByReference ppbuffersrc_ctx = new PointerByReference();
        String inArgs = String.format("width=%d:height=%d:pix_fmt=%d:time_base=%d/%d", codecCtx.width.get(), codecCtx.height.get(), codecCtx.pix_fmt.intValue(), codecCtx.time_base.num.get(), codecCtx.time_base.den.get());
        this.pixfmts = NativeRuntime.getInstance().getMemoryManager().allocateDirect(4);
        this.pixfmts.putInt(0L, -1);
        libavutil.checkcode(libavfilter.avfilter_graph_create_filter(ppbuffersrc_ctx, this.buffersrc, "in", inArgs, null, this.graph));
        libavutil.checkcode(libavfilter.avfilter_graph_create_filter(ppbuffersink_ctx, this.buffersink, "out", null, this.pixfmts, this.graph));
        this.buffersrc_ctx = JNRHelper.struct(LibAVFilter.AVFilterContext.class, ppbuffersrc_ctx);
        this.buffersink_ctx = JNRHelper.struct(LibAVFilter.AVFilterContext.class, ppbuffersink_ctx);
        this.outputs.name.set(libavutil.av_strdup("in"));
        this.outputs.filter_ctx.set((Struct)this.buffersrc_ctx);
        this.outputs.pad_idx.set(0);
        this.outputs.next.set((Pointer)null);
        this.inputs.name.set(libavutil.av_strdup("out"));
        this.inputs.filter_ctx.set((Struct)this.buffersink_ctx);
        this.inputs.pad_idx.set(0);
        this.inputs.next.set((Pointer)null);
        PointerByReference ins = new PointerByReference(Struct.getMemory((Struct)this.inputs));
        PointerByReference outs = new PointerByReference(Struct.getMemory((Struct)this.outputs));
        libavutil.checkcode(libavfilter.avfilter_graph_parse_ptr(this.graph, filterString, ins, outs, null));
        libavutil.checkcode(libavfilter.avfilter_graph_config(this.graph, null));
    }

    public AVFrame submitFrame(AVFrame inputframe) {
        if (this.workframe == null && inputframe != null) {
            this.workframe = libavutil.av_frame_alloc();
            this.workframe.width.set(inputframe.width.get());
            this.workframe.height.set(inputframe.height.get());
            this.workframe.format.set(inputframe.format.get());
            this.workframe.pts.set(inputframe.pts.get());
            libavutil.checkcode(libavutil.av_frame_get_buffer(this.workframe, 0));
        }
        this.logFilter.atDebug().log(inputframe == null ? "filter flush" : "frame send to filter PTS=" + inputframe.pts.get());
        libavutil.checkcode(libavfilter.av_buffersrc_write_frame(this.buffersrc_ctx, inputframe));
        int res = libavfilter.av_buffersink_get_frame(this.buffersink_ctx, this.workframe);
        if (res == -11 || res == -541478725) {
            if (inputframe == null) {
                this.logFilter.atDebug().log("filter buffers empty");
            }
            return null;
        }
        libavutil.checkcode(res);
        this.logFilter.atDebug().addArgument((Object)this.workframe.pts.get()).log("filter returned frame PTS={}");
        return this.workframe;
    }

    public void reset() {
        this.logFilter.atDebug().log("draining filters");
        while (libavfilter.av_buffersink_get_frame(this.buffersink_ctx, this.workframe) >= 0) {
        }
    }

    @Override
    public void close() {
        libavfilter.avfilter_graph_free(new Pointer[]{Struct.getMemory((Struct)this.graph)});
        if (this.workframe != null) {
            libavutil.av_frame_free(new Pointer[]{Struct.getMemory((Struct)this.workframe)});
        }
    }
}

