/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl.middle;

import com.zakgof.tools.generic.MinFinder;
import com.zakgof.velvetvideo.impl.jnr.AVSampleFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;

public class BestMatchingAudioFormatConvertor
implements Function<AudioFormat, AudioFormat> {
    private final Collection<AudioFormat> supportedFormats;

    public BestMatchingAudioFormatConvertor() {
        this(BestMatchingAudioFormatConvertor.getSupportedFormats());
    }

    public BestMatchingAudioFormatConvertor(Collection<AudioFormat> supportedFormats) {
        this.supportedFormats = supportedFormats;
    }

    @Override
    public AudioFormat apply(AudioFormat suggested) {
        AudioFormat bestFormat = (AudioFormat)MinFinder.find(this.supportedFormats, format -> Float.valueOf(BestMatchingAudioFormatConvertor.compare(suggested, format))).get();
        if (bestFormat != null) {
            return new AudioFormat(bestFormat.getEncoding(), suggested.getSampleRate(), bestFormat.getSampleSizeInBits(), bestFormat.getChannels(), bestFormat.getFrameSize(), suggested.getSampleRate(), bestFormat.isBigEndian());
        }
        return suggested;
    }

    private static float compare(AudioFormat suggested, AudioFormat format) {
        float metric = 0.0f;
        int bitnessDiff = format.getSampleSizeInBits() - suggested.getSampleSizeInBits();
        metric = bitnessDiff > 0 ? (metric += (float)(bitnessDiff * 100)) : (metric -= (float)(bitnessDiff * 1000));
        int channelsDiff = format.getChannels() - suggested.getChannels();
        metric = channelsDiff > 0 ? (metric += (float)(channelsDiff * 10000)) : (metric -= (float)(channelsDiff * 100000));
        if (format.getEncoding() != suggested.getEncoding()) {
            metric += 10.0f;
        }
        if (format.isBigEndian()) {
            metric = (float)((double)metric + 1000000.0);
        }
        return metric;
    }

    private static Collection<AudioFormat> getSupportedFormats() {
        return Arrays.stream(AudioSystem.getMixerInfo()).map(AudioSystem::getMixer).map(Mixer::getTargetLineInfo).flatMap(Arrays::stream).filter(DataLine.Info.class::isInstance).map(DataLine.Info.class::cast).map(DataLine.Info::getFormats).flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    public static AVSampleFormat findBest(Set<AVSampleFormat> supportedFormats, AudioFormat suggested) {
        AVSampleFormat bestFormat = (AVSampleFormat)((Object)MinFinder.find(supportedFormats, format -> Float.valueOf(BestMatchingAudioFormatConvertor.compare(suggested, format.toAudioFormat(0, -1)))).get());
        if (bestFormat != null) {
            return bestFormat;
        }
        return AVSampleFormat.from(suggested);
    }
}

