/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl.middle;

import com.zakgof.velvetvideo.IAudioDecoderStream;
import com.zakgof.velvetvideo.IAudioFrame;
import java.util.Arrays;

final class AudioFrameImpl
implements IAudioFrame {
    private final byte[] samples;
    private final long nanostamp;
    private final long nanoduration;
    private final IAudioDecoderStream stream;

    public String toString() {
        return "Audio frame t=" + this.nanostamp + " stream:" + this.stream.name();
    }

    public AudioFrameImpl(byte[] samples, long nanostamp, long nanoduration, IAudioDecoderStream stream) {
        this.samples = samples;
        this.nanostamp = nanostamp;
        this.nanoduration = nanoduration;
        this.stream = stream;
    }

    @Override
    public byte[] samples() {
        return this.samples;
    }

    @Override
    public long nanostamp() {
        return this.nanostamp;
    }

    @Override
    public long nanoduration() {
        return this.nanoduration;
    }

    @Override
    public IAudioDecoderStream stream() {
        return this.stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioFrameImpl)) {
            return false;
        }
        AudioFrameImpl other = (AudioFrameImpl)o;
        if (!Arrays.equals(this.samples(), other.samples())) {
            return false;
        }
        if (this.nanostamp() != other.nanostamp()) {
            return false;
        }
        if (this.nanoduration() != other.nanoduration()) {
            return false;
        }
        IAudioDecoderStream this$stream = this.stream();
        IAudioDecoderStream other$stream = other.stream();
        return !(this$stream == null ? other$stream != null : !this$stream.equals(other$stream));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.samples());
        long $nanostamp = this.nanostamp();
        result = result * 59 + (int)($nanostamp >>> 32 ^ $nanostamp);
        long $nanoduration = this.nanoduration();
        result = result * 59 + (int)($nanoduration >>> 32 ^ $nanoduration);
        IAudioDecoderStream $stream = this.stream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        return result;
    }
}

