/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl.middle;

import com.zakgof.velvetvideo.IAudioDecoderStream;
import com.zakgof.velvetvideo.IAudioFrame;
import com.zakgof.velvetvideo.impl.JNRHelper;
import com.zakgof.velvetvideo.impl.VelvetVideoLib;
import com.zakgof.velvetvideo.impl.jnr.AVCodecContext;
import com.zakgof.velvetvideo.impl.jnr.AVFrame;
import com.zakgof.velvetvideo.impl.jnr.AVRational;
import com.zakgof.velvetvideo.impl.jnr.AVSampleFormat;
import com.zakgof.velvetvideo.impl.jnr.LibAVUtil;
import com.zakgof.velvetvideo.impl.jnr.LibSwResample;
import com.zakgof.velvetvideo.impl.middle.AudioFrameImpl;
import com.zakgof.velvetvideo.impl.middle.IFrameHolder;
import javax.sound.sampled.AudioFormat;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;

public class AudioFrameHolder
implements AutoCloseable,
IFrameHolder {
    public final AVFrame frame = libavutil.av_frame_alloc();
    private final AVRational timebase;
    private final Pointer swrContext;
    private final AVCodecContext codecCtx;
    private AudioFormat userFormat;
    private AVSampleFormat userSampleFormat;
    private static final LibAVUtil libavutil = JNRHelper.load(LibAVUtil.class, "avutil", 56);
    private static final LibSwResample libavresample = JNRHelper.load(LibSwResample.class, "swresample", 3);
    private Pointer[] userBuffer;
    private int userBufferSamplesSize;
    private int frameSamples;
    private int bytesPerSample;

    public AudioFrameHolder(AVRational timebase, boolean encode, AVCodecContext codecCtx, AudioFormat userFormat) {
        this.timebase = timebase;
        this.codecCtx = codecCtx;
        this.userFormat = userFormat;
        this.userSampleFormat = AVSampleFormat.from(userFormat);
        this.swrContext = this.initResampler(encode);
        this.userBuffer = new Pointer[]{null};
        this.bytesPerSample = this.userSampleFormat.bytesPerSample() * userFormat.getChannels();
        if (encode) {
            this.frameSamples = codecCtx.frame_size.get();
            this.frame.nb_samples.set(this.frameSamples);
            this.frame.format.set(codecCtx.sample_fmt.longValue());
            this.frame.channel_layout.set(codecCtx.channel_layout.get());
            this.frame.sample_rate.set((int)userFormat.getSampleRate());
            libavutil.checkcode(libavutil.av_frame_get_buffer(this.frame, 0));
        }
    }

    private Pointer initResampler(boolean encode) {
        Pointer swr = libavresample.swr_alloc();
        libavutil.av_opt_set_int(swr, !encode ? "in_channel_count" : "out_channel_count", this.codecCtx.channels.get(), 0);
        libavutil.av_opt_set_int(swr, !encode ? "out_channel_count" : "in_channel_count", this.userFormat.getChannels(), 0);
        libavutil.av_opt_set_int(swr, !encode ? "in_channel_layout" : "out_channel_layout", (int)this.codecCtx.channel_layout.get(), 0);
        libavutil.av_opt_set_int(swr, !encode ? "out_channel_layout" : "in_channel_layout", this.channelLayout((int)this.codecCtx.channel_layout.get(), this.codecCtx.channels.get(), this.userFormat.getChannels()), 0);
        libavutil.av_opt_set_int(swr, !encode ? "in_sample_rate" : "out_sample_rate", this.codecCtx.sample_rate.get(), 0);
        libavutil.av_opt_set_int(swr, !encode ? "out_sample_rate" : "in_sample_rate", (int)this.userFormat.getSampleRate(), 0);
        libavutil.av_opt_set_sample_fmt(swr, !encode ? "in_sample_fmt" : "out_sample_fmt", (AVSampleFormat)this.codecCtx.sample_fmt.get(), 0);
        libavutil.av_opt_set_sample_fmt(swr, !encode ? "out_sample_fmt" : "in_sample_fmt", this.userSampleFormat, 0);
        libavutil.checkcode(libavresample.swr_init(swr));
        return swr;
    }

    private int channelLayout(int suggestedLayout, int suggestedChannels, int targetChannels) {
        if (suggestedChannels == targetChannels) {
            return suggestedLayout;
        }
        return libavutil.av_get_default_channel_layout(targetChannels);
    }

    private byte[] samples(AVFrame frame) {
        this.reallocUserBuffer(frame.nb_samples.get());
        int frame_count = libavresample.swr_convert(this.swrContext, this.userBuffer, this.userBufferSamplesSize, JNRHelper.ptr((Struct.NumberField)frame.data[0]), this.userBufferSamplesSize);
        int bytesCount = frame_count * this.bytesPerSample;
        byte[] b1 = new byte[bytesCount];
        this.userBuffer[0].get(0L, b1, 0, bytesCount);
        return b1;
    }

    private void reallocUserBuffer(int size) {
        if (size != this.userBufferSamplesSize) {
            if (this.userBuffer[0] != null) {
                libavutil.av_freep(this.userBuffer);
            }
            this.userBufferSamplesSize = size;
            libavutil.av_samples_alloc(this.userBuffer, null, this.userFormat.getChannels(), size, this.userSampleFormat, 0);
        }
    }

    public int frameBytes() {
        return this.frameSamples * this.userSampleFormat.bytesPerSample() * this.userFormat.getChannels();
    }

    public int put(byte[] samples, int offset) {
        this.reallocUserBuffer(this.frameSamples);
        int sampleBytes = Math.min(this.frameBytes(), samples.length - offset);
        int sampleCount = sampleBytes / this.bytesPerSample;
        this.userBuffer[0].put(0L, samples, offset, sampleBytes);
        libavutil.checkcode(libavresample.swr_convert(this.swrContext, JNRHelper.ptr((Struct.NumberField)this.frame.data[0]), sampleCount, this.userBuffer, sampleCount));
        this.frame.nb_samples.set(sampleCount);
        return sampleCount;
    }

    @Override
    public void close() {
        libavutil.av_frame_free(new Pointer[]{Struct.getMemory((Struct)this.frame)});
        libavresample.swr_free(new Pointer[]{this.swrContext});
        if (this.userBuffer != null) {
            libavutil.av_freep(this.userBuffer);
        }
    }

    @Override
    public AVFrame frame() {
        return this.frame;
    }

    public IAudioFrame decode(AVFrame frame, VelvetVideoLib.DemuxerImpl.AbstractDecoderStream stream) {
        long pts = this.pts();
        if (pts == Long.MIN_VALUE) {
            pts = 0L;
        }
        long duration = libavutil.av_frame_get_pkt_duration(frame);
        byte[] samples = this.samples(frame);
        long nanostamp = pts * 1000000000L * (long)this.timebase.num.get() / (long)this.timebase.den.get();
        long nanoduration = duration * 1000000000L * (long)this.timebase.num.get() / (long)this.timebase.den.get();
        return new AudioFrameImpl(samples, nanostamp, nanoduration, (IAudioDecoderStream)((Object)stream));
    }
}

