/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl.jnr;

import com.zakgof.velvetvideo.VelvetVideoException;
import com.zakgof.velvetvideo.impl.jnr.AVDictionaryEntry;
import com.zakgof.velvetvideo.impl.jnr.AVFrame;
import com.zakgof.velvetvideo.impl.jnr.AVOption;
import com.zakgof.velvetvideo.impl.jnr.AVPixelFormat;
import com.zakgof.velvetvideo.impl.jnr.AVSampleFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.annotations.In;
import jnr.ffi.types.int64_t;
import jnr.ffi.types.size_t;

public interface LibAVUtil {
    public static final int AV_DICT_IGNORE_SUFFIX = 2;
    public static final int ERROR_TEXT_BUFFER_SIZE = 512;
    public static final int AVERROR_EOF = -541478725;
    public static final int AVERROR_EAGAIN = -11;
    public static final int AVERROR_INVALIDDATA = -1094995529;
    public static final long AVNOPTS_VALUE = Long.MIN_VALUE;

    public AVFrame av_frame_alloc();

    public int av_frame_get_buffer(AVFrame var1, int var2);

    public void av_frame_unref(AVFrame var1);

    public void av_frame_free(Pointer[] var1);

    public int av_image_alloc(Pointer[] var1, int[] var2, int var3, int var4, AVPixelFormat var5, int var6);

    public int av_dict_set(Pointer[] var1, String var2, String var3, int var4);

    public void av_dict_free(Pointer[] var1);

    public void av_opt_set_int(Pointer var1, String var2, @int64_t int var3, int var4);

    public void av_opt_set_sample_fmt(Pointer var1, String var2, AVSampleFormat var3, int var4);

    public AVOption av_opt_next(Pointer var1, @In AVOption var2);

    public int av_strerror(int var1, Pointer var2, int var3);

    public int av_log_set_level(int var1);

    public Pointer av_malloc(@size_t int var1);

    public AVDictionaryEntry av_dict_get(@In Pointer var1, @In String var2, @In AVDictionaryEntry var3, int var4);

    public long av_frame_get_pkt_duration(AVFrame var1);

    public void av_samples_alloc(Pointer[] var1, int[] var2, int var3, int var4, AVSampleFormat var5, int var6);

    public void av_freep(Pointer[] var1);

    public void av_free(Pointer var1);

    @int64_t
    public int av_get_default_channel_layout(int var1);

    public Pointer av_strdup(String var1);

    default public Pointer createDictionary(Map<String, String> map) {
        Pointer[] opts = new Pointer[1];
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.av_dict_set(opts, entry.getKey(), entry.getValue(), 0);
        }
        return opts[0];
    }

    default public Map<String, String> dictionaryToMap(Pointer dictionary) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        AVDictionaryEntry entry = null;
        do {
            if ((entry = this.av_dict_get(dictionary, "", entry, 2)) == null) continue;
            metadata.put(entry.key.get(), entry.value.get());
        } while (entry != null);
        return metadata;
    }

    default public int checkcode(int code) {
        if (code < 0) {
            Pointer ptr = Runtime.getSystemRuntime().getMemoryManager().allocateDirect(512);
            this.av_strerror(code, ptr, 512);
            byte[] bts = new byte[512];
            ptr.get(0L, bts, 0, 512);
            int len = 0;
            for (int i = 0; i < 512; ++i) {
                if (bts[i] != 0) continue;
                len = i;
            }
            String s = new String(bts, 0, len);
            throw new VelvetVideoException("FFMPEG error " + code + " : " + s);
        }
        return code;
    }

    default public List<String> options(Pointer obj) {
        ArrayList<String> options = new ArrayList<String>();
        AVOption curr = null;
        while ((curr = this.av_opt_next(obj, curr)) != null) {
            options.add(curr.name.get());
        }
        return options;
    }
}

