/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl.jnr;

import com.zakgof.velvetvideo.Direction;
import com.zakgof.velvetvideo.MediaType;
import com.zakgof.velvetvideo.impl.jnr.AVCodec;
import com.zakgof.velvetvideo.impl.jnr.AVCodecContext;
import com.zakgof.velvetvideo.impl.jnr.AVCodecParameters;
import com.zakgof.velvetvideo.impl.jnr.AVFrame;
import com.zakgof.velvetvideo.impl.jnr.AVPacket;
import java.util.ArrayList;
import java.util.List;
import jnr.ffi.Pointer;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.byref.PointerByReference;

public interface LibAVCodec {
    public static final int AVMEDIA_TYPE_VIDEO = 0;
    public static final int AVMEDIA_TYPE_AUDIO = 1;
    public static final int AVMEDIA_TYPE_DATA = 2;
    public static final int AVMEDIA_TYPE_SUBTITLE = 3;
    public static final int CODEC_FLAG_GLOBAL_HEADER = 0x400000;

    public AVCodec avcodec_find_encoder_by_name(String var1);

    public AVPacket av_packet_alloc();

    public void av_init_packet(AVPacket var1);

    public int av_new_packet(AVPacket var1, int var2);

    public int av_packet_from_data(AVPacket var1, @In Pointer var2, @In int var3);

    public void av_packet_free(Pointer[] var1);

    public void av_packet_unref(AVPacket var1);

    public int avcodec_receive_packet(AVCodecContext var1, AVPacket var2);

    public int avcodec_open2x();

    public AVCodecContext avcodec_alloc_context3(AVCodec var1);

    public int avcodec_open2(AVCodecContext var1, @In AVCodec var2, @In Pointer[] var3);

    public void avcodec_register_all();

    public int avcodec_send_frame(AVCodecContext var1, @In AVFrame var2);

    public int avcodec_encode_video2(AVCodecContext var1, AVPacket var2, @In AVFrame var3, @Out int[] var4);

    public int avcodec_parameters_from_context(@Out AVCodecParameters var1, @In AVCodecContext var2);

    public int avcodec_parameters_to_context(@Out AVCodecContext var1, @In AVCodecParameters var2);

    public int avcodec_parameters_copy(@Out AVCodecParameters var1, @In AVCodecParameters var2);

    public AVCodecParameters avcodec_parameters_alloc();

    public void avcodec_parameters_free(PointerByReference var1);

    public int avcodec_receive_frame(AVCodecContext var1, AVFrame var2);

    public int avcodec_send_packet(AVCodecContext var1, AVPacket var2);

    public AVCodec avcodec_find_decoder(int var1);

    public AVCodec av_codec_iterate(PointerByReference var1);

    public int av_codec_is_encoder(AVCodec var1);

    public int av_codec_is_decoder(AVCodec var1);

    public void avcodec_flush_buffers(AVCodecContext var1);

    public void avcodec_free_context(Pointer[] var1);

    public int avcodec_close(AVCodecContext var1);

    default public List<String> codecs(Direction dir, MediaType mediaType) {
        AVCodec codec;
        PointerByReference ptr = new PointerByReference();
        ArrayList<String> codecs = new ArrayList<String>();
        while ((codec = this.av_codec_iterate(ptr)) != null) {
            if (!this.matches(codec, dir, mediaType)) continue;
            codecs.add(codec.name.get());
        }
        return codecs;
    }

    default public boolean matches(AVCodec codec, Direction dir, MediaType mediaType) {
        switch (mediaType) {
            case Video: {
                if (codec.type.get() == 0) break;
                return false;
            }
            case Audio: {
                if (codec.type.get() == 1) break;
                return false;
            }
            case Subtitles: {
                if (codec.type.get() == 3) break;
                return false;
            }
        }
        switch (dir) {
            case Decode: {
                return this.av_codec_is_decoder(codec) != 0;
            }
            case Encode: {
                return this.av_codec_is_encoder(codec) != 0;
            }
            case All: {
                return true;
            }
        }
        return false;
    }
}

