/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl.jnr;

import com.zakgof.velvetvideo.VelvetVideoException;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;

public enum AVSampleFormat {
    AV_SAMPLE_FMT_U8(AudioFormat.Encoding.PCM_UNSIGNED, 8, false),
    AV_SAMPLE_FMT_S16(AudioFormat.Encoding.PCM_SIGNED, 16, false),
    AV_SAMPLE_FMT_S32(AudioFormat.Encoding.PCM_SIGNED, 32, false),
    AV_SAMPLE_FMT_FLT(AudioFormat.Encoding.PCM_FLOAT, 32, false),
    AV_SAMPLE_FMT_DBL(AudioFormat.Encoding.PCM_FLOAT, 64, false),
    AV_SAMPLE_FMT_U8P(AudioFormat.Encoding.PCM_UNSIGNED, 8, true),
    AV_SAMPLE_FMT_S16P(AudioFormat.Encoding.PCM_SIGNED, 16, true),
    AV_SAMPLE_FMT_S32P(AudioFormat.Encoding.PCM_SIGNED, 32, true),
    AV_SAMPLE_FMT_FLTP(AudioFormat.Encoding.PCM_FLOAT, 32, true),
    AV_SAMPLE_FMT_DBLP(AudioFormat.Encoding.PCM_FLOAT, 64, true),
    AV_SAMPLE_FMT_S64(AudioFormat.Encoding.PCM_SIGNED, 64, false),
    AV_SAMPLE_FMT_S64P(AudioFormat.Encoding.PCM_SIGNED, 64, true);

    private final AudioFormat.Encoding encoding;
    private final int sampleSizeInBits;
    private final boolean planar;

    public AudioFormat toAudioFormat(int frameRate, int channels) {
        int frameSize = (this.sampleSizeInBits >> 3) * (this.planar ? 1 : channels);
        return new AudioFormat(this.encoding, frameRate, this.sampleSizeInBits, channels, frameSize, frameRate, false);
    }

    public AVSampleFormat destFormat() {
        switch (this) {
            case AV_SAMPLE_FMT_U8: 
            case AV_SAMPLE_FMT_S16: 
            case AV_SAMPLE_FMT_S32: 
            case AV_SAMPLE_FMT_FLT: 
            case AV_SAMPLE_FMT_DBL: 
            case AV_SAMPLE_FMT_S64: {
                return this;
            }
            case AV_SAMPLE_FMT_U8P: {
                return AV_SAMPLE_FMT_U8;
            }
            case AV_SAMPLE_FMT_S16P: {
                return AV_SAMPLE_FMT_S16;
            }
            case AV_SAMPLE_FMT_S32P: {
                return AV_SAMPLE_FMT_S32;
            }
            case AV_SAMPLE_FMT_FLTP: {
                return AV_SAMPLE_FMT_FLT;
            }
            case AV_SAMPLE_FMT_DBLP: {
                return AV_SAMPLE_FMT_DBL;
            }
            case AV_SAMPLE_FMT_S64P: {
                return AV_SAMPLE_FMT_S64;
            }
        }
        throw new VelvetVideoException("Unsupported sample format " + (Object)((Object)this));
    }

    public int bytesPerSample() {
        return this.sampleSizeInBits >> 3;
    }

    public static AVSampleFormat from(AudioFormat targetFormat) {
        return Arrays.stream(AVSampleFormat.values()).filter(sf -> sf.encoding == targetFormat.getEncoding() && sf.sampleSizeInBits == targetFormat.getSampleSizeInBits() && !sf.planar).findFirst().get();
    }

    public boolean planar() {
        return this.planar;
    }

    private AVSampleFormat(AudioFormat.Encoding encoding, int sampleSizeInBits, boolean planar) {
        this.encoding = encoding;
        this.sampleSizeInBits = sampleSizeInBits;
        this.planar = planar;
    }
}

