/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl;

import com.zakgof.velvetvideo.Direction;
import com.zakgof.velvetvideo.IAudioDecoderStream;
import com.zakgof.velvetvideo.IAudioEncoderBuilder;
import com.zakgof.velvetvideo.IAudioEncoderStream;
import com.zakgof.velvetvideo.IAudioFrame;
import com.zakgof.velvetvideo.IAudioStreamProperties;
import com.zakgof.velvetvideo.IContainerProperties;
import com.zakgof.velvetvideo.IDecodedPacket;
import com.zakgof.velvetvideo.IDecoderStream;
import com.zakgof.velvetvideo.IDemuxer;
import com.zakgof.velvetvideo.IMuxer;
import com.zakgof.velvetvideo.IMuxerBuilder;
import com.zakgof.velvetvideo.IRawPacket;
import com.zakgof.velvetvideo.IRemuxerBuilder;
import com.zakgof.velvetvideo.IRemuxerStream;
import com.zakgof.velvetvideo.ISeekableInput;
import com.zakgof.velvetvideo.ISeekableOutput;
import com.zakgof.velvetvideo.IVelvetVideoLib;
import com.zakgof.velvetvideo.IVideoDecoderStream;
import com.zakgof.velvetvideo.IVideoEncoderBuilder;
import com.zakgof.velvetvideo.IVideoEncoderStream;
import com.zakgof.velvetvideo.IVideoFrame;
import com.zakgof.velvetvideo.IVideoStreamProperties;
import com.zakgof.velvetvideo.MediaType;
import com.zakgof.velvetvideo.VelvetVideoException;
import com.zakgof.velvetvideo.impl.AbstractEncoderBuilderImpl;
import com.zakgof.velvetvideo.impl.AudioEncoderBuilderImpl;
import com.zakgof.velvetvideo.impl.AudioStreamPropertiesImpl;
import com.zakgof.velvetvideo.impl.FileSeekableOutput;
import com.zakgof.velvetvideo.impl.JNRHelper;
import com.zakgof.velvetvideo.impl.MuxerProperties;
import com.zakgof.velvetvideo.impl.RawPacket;
import com.zakgof.velvetvideo.impl.RemuxerBuilderImpl;
import com.zakgof.velvetvideo.impl.UnknownPacket;
import com.zakgof.velvetvideo.impl.VideoEncoderBuilderImpl;
import com.zakgof.velvetvideo.impl.VideoStreamProperties;
import com.zakgof.velvetvideo.impl.jnr.AVCodec;
import com.zakgof.velvetvideo.impl.jnr.AVCodecContext;
import com.zakgof.velvetvideo.impl.jnr.AVCodecParameters;
import com.zakgof.velvetvideo.impl.jnr.AVDictionaryEntry;
import com.zakgof.velvetvideo.impl.jnr.AVFormatContext;
import com.zakgof.velvetvideo.impl.jnr.AVFrame;
import com.zakgof.velvetvideo.impl.jnr.AVIOContext;
import com.zakgof.velvetvideo.impl.jnr.AVInputFormat;
import com.zakgof.velvetvideo.impl.jnr.AVOutputFormat;
import com.zakgof.velvetvideo.impl.jnr.AVPacket;
import com.zakgof.velvetvideo.impl.jnr.AVPixelFormat;
import com.zakgof.velvetvideo.impl.jnr.AVSampleFormat;
import com.zakgof.velvetvideo.impl.jnr.AVStream;
import com.zakgof.velvetvideo.impl.jnr.LibAVCodec;
import com.zakgof.velvetvideo.impl.jnr.LibAVFormat;
import com.zakgof.velvetvideo.impl.jnr.LibAVUtil;
import com.zakgof.velvetvideo.impl.jnr.LibSwResample;
import com.zakgof.velvetvideo.impl.middle.AudioFrameHolder;
import com.zakgof.velvetvideo.impl.middle.BestMatchingAudioFormatConvertor;
import com.zakgof.velvetvideo.impl.middle.Feeder;
import com.zakgof.velvetvideo.impl.middle.Filters;
import com.zakgof.velvetvideo.impl.middle.IFrameHolder;
import com.zakgof.velvetvideo.impl.middle.VideoFrameHolder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sound.sampled.AudioFormat;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.byref.PointerByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelvetVideoLib
implements IVelvetVideoLib {
    private static final int AVIO_CUSTOM_BUFFER_SIZE = 32768;
    private static final long AVNOPTS_VALUE = Long.MIN_VALUE;
    private final LibAVUtil libavutil = JNRHelper.load(LibAVUtil.class, "avutil", 56);
    private final LibSwResample dummyswresample = JNRHelper.load(LibSwResample.class, "swresample", 3);
    private final int dummyopenh264 = JNRHelper.preload("openh264", 5);
    private final LibAVCodec libavcodec = JNRHelper.load(LibAVCodec.class, "avcodec", 58);
    private final LibAVFormat libavformat = JNRHelper.load(LibAVFormat.class, "avformat", 58);
    private static volatile IVelvetVideoLib instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IVelvetVideoLib getInstance() {
        if (instance != null) return instance;
        Class<VelvetVideoLib> clazz = VelvetVideoLib.class;
        synchronized (VelvetVideoLib.class) {
            if (instance != null) return instance;
            instance = new VelvetVideoLib();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private VelvetVideoLib() {
    }

    private int checkcode(int code) {
        return this.libavutil.checkcode(code);
    }

    @Override
    public List<String> codecs(Direction dir, MediaType mediaType) {
        return this.libavcodec.codecs(dir, mediaType);
    }

    @Override
    public List<String> formats(Direction dir) {
        return this.libavformat.formats(dir);
    }

    @Override
    public IVideoEncoderBuilder videoEncoder(String codec) {
        return new VideoEncoderBuilderImpl(codec);
    }

    @Override
    public IAudioEncoderBuilder audioEncoder(String codec, AudioFormat audioFormat) {
        return new AudioEncoderBuilderImpl(codec, audioFormat);
    }

    @Override
    public IRemuxerBuilder remuxer(IDecoderStream<?, ?, ?> decoder) {
        return new RemuxerBuilderImpl(decoder);
    }

    private String defaultName(AVStream avstream, int index) {
        String name;
        AVDictionaryEntry entry = this.libavutil.av_dict_get(avstream.metadata.get(), "handler_name", null, 0);
        if (entry != null && !(name = entry.value.get()).equals("VideoHandler")) {
            return name;
        }
        return "video" + index;
    }

    private void initCustomAvio(boolean read, AVFormatContext formatCtx, LibAVFormat.ICustomAvioCallback callback) {
        Pointer buffer = this.libavutil.av_malloc(32832);
        AVIOContext avioCtx = this.libavformat.avio_alloc_context(buffer, 32768, read ? 0 : 1, null, read ? callback : null, read ? null : callback, callback);
        int flagz = formatCtx.ctx_flags.get();
        formatCtx.ctx_flags.set(0x80 | flagz);
        formatCtx.pb.set((Struct)avioCtx);
    }

    private AVFormatContext createMuxerFormatContext(String format, Map<String, String> metadata) {
        AVOutputFormat outputFmt = this.libavformat.av_guess_format(format, null, null);
        if (outputFmt == null) {
            throw new VelvetVideoException("Unsupported format: " + format);
        }
        PointerByReference ctxptr = new PointerByReference();
        this.checkcode(this.libavformat.avformat_alloc_output_context2(ctxptr, outputFmt, null, null));
        AVFormatContext ctx = JNRHelper.struct(AVFormatContext.class, (Pointer)ctxptr.getValue());
        Pointer dictionary = this.libavutil.createDictionary(metadata);
        ctx.metadata.set(dictionary);
        return ctx;
    }

    @Override
    public IMuxerBuilder muxer(String format) {
        return new MuxerBuilderImpl(format);
    }

    @Override
    public IDemuxer demuxer(ISeekableInput input) {
        return new DemuxerImpl(input);
    }

    private static <T> Iterator<T> iteratorFromSupplier(final Supplier<T> supplier) {
        return new Iterator<T>(){
            private T next;
            {
                this.next = supplier.get();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = supplier.get();
                return ret;
            }
        };
    }

    public class DemuxerImpl
    implements IDemuxer {
        private final Logger logDemuxer = LoggerFactory.getLogger((String)"velvet-video.demuxer");
        private final AVFormatContext formatCtx;
        private final ISeekableInput input;
        private final IOCallback callback;
        private final AVPacket packet;
        private final Map<Integer, DecoderVideoStreamImpl> indexToVideoStream = new LinkedHashMap<Integer, DecoderVideoStreamImpl>();
        private final Map<Integer, DecoderAudioStreamImpl> indexToAudioStream = new LinkedHashMap<Integer, DecoderAudioStreamImpl>();
        private final List<AbstractDecoderStream> allStreams = new ArrayList<AbstractDecoderStream>();
        private int flushStreamIndex = 0;

        public DemuxerImpl(ISeekableInput input) {
            this.input = input;
            this.packet = VelvetVideoLib.this.libavcodec.av_packet_alloc();
            this.formatCtx = VelvetVideoLib.this.libavformat.avformat_alloc_context();
            this.callback = new IOCallback();
            VelvetVideoLib.this.initCustomAvio(true, this.formatCtx, this.callback);
            PointerByReference ptrctx = new PointerByReference(Struct.getMemory((Struct)this.formatCtx));
            int res = VelvetVideoLib.this.libavformat.avformat_open_input(ptrctx, null, null, null);
            if (res == -1094995529) {
                throw new VelvetVideoException("Unknown container format");
            }
            VelvetVideoLib.this.checkcode(res);
            VelvetVideoLib.this.checkcode(VelvetVideoLib.this.libavformat.avformat_find_stream_info(this.formatCtx, null));
            long nb = this.formatCtx.nb_streams.get();
            Pointer pointer = this.formatCtx.streams.get();
            int i = 0;
            while ((long)i < nb) {
                AbstractDecoderStream decoder;
                Pointer mem = pointer.getPointer((long)(i * pointer.getRuntime().addressSize()));
                AVStream avstream = JNRHelper.struct(AVStream.class, mem);
                int mediaType = ((AVCodecContext)avstream.codec.get()).codec_type.get();
                if (mediaType == 0) {
                    ((AVCodecContext)avstream.codec.get()).strict_std_compliance.set(-2);
                    decoder = new DecoderVideoStreamImpl(avstream, VelvetVideoLib.this.defaultName(avstream, i));
                    this.indexToVideoStream.put(i, (DecoderVideoStreamImpl)decoder);
                    this.allStreams.add(decoder);
                } else if (mediaType == 1) {
                    ((AVCodecContext)avstream.codec.get()).strict_std_compliance.set(-2);
                    decoder = new DecoderAudioStreamImpl(avstream, VelvetVideoLib.this.defaultName(avstream, i));
                    this.indexToAudioStream.put(i, (DecoderAudioStreamImpl)decoder);
                    this.allStreams.add(decoder);
                }
                ++i;
            }
        }

        @Override
        public IDecodedPacket<?> nextPacket() {
            return Feeder.next(this::nextAVPacket, this::decodePacket);
        }

        @Override
        public IRawPacket nextRawPacket() {
            AVPacket packet = this.nextAVPacket();
            if (packet == null) {
                return null;
            }
            return new RawPacket(packet);
        }

        private AVPacket nextAVPacket() {
            VelvetVideoLib.this.libavcodec.av_init_packet(this.packet);
            this.packet.data.set((Pointer)null);
            this.packet.size.set(0);
            int res = VelvetVideoLib.this.libavformat.av_read_frame(this.formatCtx, this.packet);
            if (res == -541478725 || res == -1) {
                this.logDemuxer.atDebug().log(() -> "muxer empty");
                return null;
            }
            VelvetVideoLib.this.checkcode(res);
            this.logDemuxer.atDebug().addArgument((Object)this.packet.stream_index.get()).addArgument((Object)this.packet.pts.get()).addArgument((Object)this.packet.dts.get()).addArgument((Object)this.packet.duration.get()).addArgument((Object)this.packet.size.get()).log(() -> "stream {}: read packet PTS/DTS={}/{} duration={} size={} bytes");
            return this.packet;
        }

        @Override
        public Stream<IDecodedPacket<?>> packetStream() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
        }

        @Override
        public Iterator<IDecodedPacket<?>> iterator() {
            return VelvetVideoLib.iteratorFromSupplier(this::nextPacket);
        }

        private IDecodedPacket<?> decodePacket(AVPacket p) {
            if (p != null) {
                return this.decodeRawPacket(p);
            }
            return this.flushNextStream();
        }

        private IDecodedPacket<?> decodeRawPacket(AVPacket p) {
            int index = p.stream_index.get();
            DecoderVideoStreamImpl videoStream = this.indexToVideoStream.get(index);
            if (videoStream != null) {
                return videoStream.decodePacket(p);
            }
            DecoderAudioStreamImpl audioStream = this.indexToAudioStream.get(index);
            if (audioStream != null) {
                return audioStream.decodePacket(p);
            }
            this.logDemuxer.atWarn().addArgument((Object)index).log("received packet of unknown stream {}");
            return new UnknownPacket();
        }

        private IDecodedPacket<?> flushNextStream() {
            while (this.flushStreamIndex < this.allStreams.size()) {
                this.logDemuxer.atDebug().addArgument((Object)this.flushStreamIndex).log(() -> "flushing demuxer stream={}");
                AbstractDecoderStream stream = this.allStreams.get(this.flushStreamIndex);
                IDecodedPacket<?> packet = stream.decodePacket(null);
                if (packet != null) {
                    return packet;
                }
                ++this.flushStreamIndex;
            }
            return null;
        }

        @Override
        public List<? extends IVideoDecoderStream> videoStreams() {
            return new ArrayList<DecoderVideoStreamImpl>(this.indexToVideoStream.values());
        }

        @Override
        public IVideoDecoderStream videoStream(int index) {
            return this.indexToVideoStream.get(index);
        }

        @Override
        public List<? extends IAudioDecoderStream> audioStreams() {
            return new ArrayList<DecoderAudioStreamImpl>(this.indexToAudioStream.values());
        }

        @Override
        public IAudioDecoderStream audioStream(int index) {
            return this.indexToAudioStream.get(index);
        }

        @Override
        public List<IDecoderStream<?, ?, ?>> streams() {
            ArrayList streams = new ArrayList();
            streams.addAll(this.indexToVideoStream.values());
            streams.addAll(this.indexToAudioStream.values());
            return streams;
        }

        @Override
        public Map<String, String> metadata() {
            Pointer dictionary = this.formatCtx.metadata.get();
            return VelvetVideoLib.this.libavutil.dictionaryToMap(dictionary);
        }

        @Override
        public IContainerProperties properties() {
            return new MuxerProperties(((AVInputFormat)this.formatCtx.iformat.get()).name.get(), this.formatCtx.duration.get() * 1000L);
        }

        @Override
        public void close() {
            VelvetVideoLib.this.libavcodec.av_packet_free(new Pointer[]{Struct.getMemory((Struct)this.packet)});
            this.allStreams.forEach(AbstractDecoderStream::close);
            AVIOContext avio = (AVIOContext)this.formatCtx.pb.get();
            VelvetVideoLib.this.libavutil.av_free(avio.buffer.get());
            VelvetVideoLib.this.libavformat.avio_context_free(new Pointer[]{Struct.getMemory((Struct)avio)});
            VelvetVideoLib.this.libavutil.av_dict_free(new Pointer[]{this.formatCtx.metadata.get()});
            this.formatCtx.metadata.set((Pointer)null);
            VelvetVideoLib.this.libavformat.avformat_free_context(this.formatCtx);
            this.input.close();
        }

        public String toString() {
            return "Demuxer " + this.properties();
        }

        public abstract class AbstractDecoderStream
        implements AutoCloseable {
            protected final Logger logDecoder = LoggerFactory.getLogger((String)"velvet-video.decoder");
            protected final AVStream avstream;
            protected final AVCodecContext codecCtx;
            private final String name;
            protected IFrameHolder frameHolder;
            private final int index;
            private long skipToPts = -1L;
            private Filters filters;

            public AbstractDecoderStream(AVStream avstream, String name) {
                this.avstream = avstream;
                this.name = name;
                this.index = avstream.index.get();
                this.codecCtx = (AVCodecContext)avstream.codec.get();
                AVCodec codec = VelvetVideoLib.this.libavcodec.avcodec_find_decoder(this.codecCtx.codec_id.get());
                VelvetVideoLib.this.checkcode(VelvetVideoLib.this.libavcodec.avcodec_open2(this.codecCtx, codec, null));
                this.logDecoder.atInfo().addArgument((Object)avstream.index.get()).addArgument((Object)avstream.time_base.num.get()).addArgument((Object)avstream.time_base.den.get()).addArgument((Object)codec.name.get()).addArgument((Object)this.codecCtx.time_base.num.get()).addArgument((Object)this.codecCtx.time_base.den.get()).log("stream {}: timebase: {}/{}, codec [{}] timebase {}/{}");
            }

            /*
             * Enabled aggressive block sorting
             * Lifted jumps to return sites
             */
            IDecodedPacket<?> decodePacket(AVPacket pack) {
                AVFrame frame;
                block5: {
                    while (true) {
                        frame = this.feedPacket(pack);
                        if (this.filters != null) {
                            frame = this.filters.submitFrame(frame);
                        }
                        if (frame == null) {
                            return null;
                        }
                        long pts = frame.pts.get();
                        this.logDecoder.atDebug().addArgument((Object)pts).log("delivered frame pts={}");
                        if (this.skipToPts == -1L) break block5;
                        if (pts == Long.MIN_VALUE) {
                            throw new VelvetVideoException("Cannot seek when decoded packets have no PTS. Looks like neither codec no container keep timing information.");
                        }
                        if (pts < this.skipToPts) {
                            this.logDecoder.atDebug().addArgument(() -> this.skipToPts).log(" ...but need to skip more to pts={}");
                            if (pack != null) return null;
                            continue;
                        }
                        if (pts <= this.skipToPts) break;
                        this.logDecoder.atWarn().addArgument((Object)pts).addArgument((Object)this.skipToPts).log(" ...unexpected position: PTS={} missed target PTS={}");
                        if (pack != null) return null;
                    }
                    this.skipToPts = -1L;
                }
                IDecodedPacket<?> decodedPacket = this.frameHolder.decode(frame, this);
                if (this.filters == null) return decodedPacket;
                VelvetVideoLib.this.libavutil.av_frame_unref(frame);
                return decodedPacket;
            }

            AVFrame feedPacket(AVPacket pack) {
                int res;
                int res1 = VelvetVideoLib.this.libavcodec.avcodec_send_packet(this.codecCtx, pack);
                if (res1 != -541478725) {
                    VelvetVideoLib.this.checkcode(res1);
                }
                if (this.frameHolder == null) {
                    this.frameHolder = this.createFrameHolder();
                }
                if ((res = VelvetVideoLib.this.libavcodec.avcodec_receive_frame(this.codecCtx, this.frameHolder.frame())) == -541478725 || pack != null && res == -11) {
                    return null;
                }
                VelvetVideoLib.this.checkcode(res);
                this.logDecoder.atDebug().addArgument((Object)this.frameHolder.pts()).addArgument(() -> VelvetVideoLib.this.libavutil.av_frame_get_pkt_duration(this.frameHolder.frame())).log("decoded frame pts={} dur={}");
                VelvetVideoLib.this.libavcodec.av_packet_unref(DemuxerImpl.this.packet);
                return this.frameHolder.frame();
            }

            protected abstract IFrameHolder createFrameHolder();

            public String name() {
                return this.name;
            }

            public int index() {
                return this.index;
            }

            public Map<String, String> metadata() {
                Pointer dictionary = this.avstream.metadata.get();
                return VelvetVideoLib.this.libavutil.dictionaryToMap(dictionary);
            }

            public void seekToFrame(long frameIndex) {
                long cn = this.codecCtx.time_base.num.get();
                long cd = this.codecCtx.time_base.den.get();
                long defaultFrameDur = cn * (long)this.avstream.time_base.den.get() * (long)this.codecCtx.ticks_per_frame.get() / (cd * (long)this.avstream.time_base.num.get());
                long pts = frameIndex * defaultFrameDur;
                this.logDecoder.atDebug().addArgument(() -> frameIndex).addArgument(() -> pts).log("seeking to frame {}, target pts={}");
                this.seekToPts(pts);
            }

            public void seekToNano(long nanostamp) {
                long pts = nanostamp * (long)this.avstream.time_base.den.get() / (long)this.avstream.time_base.num.get() / 1000000L;
                this.logDecoder.atDebug().addArgument(() -> nanostamp).addArgument(() -> pts).log("seeking to t={} ns, target pts={}");
                this.seekToPts(pts);
            }

            private void seekToPts(long pts) {
                VelvetVideoLib.this.checkcode(VelvetVideoLib.this.libavformat.av_seek_frame(DemuxerImpl.this.formatCtx, this.index, pts, 9));
                VelvetVideoLib.this.libavcodec.avcodec_flush_buffers(this.codecCtx);
                this.skipToPts = pts;
                DemuxerImpl.this.flushStreamIndex = 0;
                if (this.filters != null) {
                    this.filters.reset();
                }
            }

            public IRawPacket nextRawPacket() {
                AVPacket p;
                while ((p = DemuxerImpl.this.nextAVPacket()) != null) {
                    RawPacket rp = p.stream_index.get() == this.index ? new RawPacket(p) : null;
                    VelvetVideoLib.this.libavcodec.av_packet_unref(p);
                    if (rp == null) continue;
                    return rp;
                }
                return null;
            }

            public void setFilter(String filterString) {
                if (filterString != null) {
                    this.filters = new Filters(this.codecCtx, filterString);
                }
            }

            @Override
            public void close() {
                if (this.filters != null) {
                    this.filters.close();
                }
                if (this.frameHolder != null) {
                    this.frameHolder.close();
                }
                VelvetVideoLib.this.libavcodec.avcodec_close(this.codecCtx);
            }
        }

        private class DecoderAudioStreamImpl
        extends AbstractDecoderStream
        implements IAudioDecoderStream {
            private final AudioFormat targetFormat;

            public DecoderAudioStreamImpl(AVStream avstream, String name) {
                super(avstream, name);
                AudioFormat suggestedFormat = ((AVSampleFormat)this.codecCtx.sample_fmt.get()).destFormat().toAudioFormat(this.codecCtx.sample_rate.get(), this.codecCtx.channels.get());
                this.targetFormat = new BestMatchingAudioFormatConvertor().apply(suggestedFormat);
                this.logDecoder.atInfo().addArgument((Object)this.index()).addArgument((Object)this.targetFormat).log("stream {}: audio format [{}]");
                if (!this.targetFormat.equals(suggestedFormat)) {
                    this.logDecoder.atWarn().addArgument((Object)suggestedFormat).addArgument((Object)this.targetFormat).log("Audio format converted [{}] -> [{}]");
                }
            }

            @Override
            public IAudioFrame nextFrame() {
                IDecodedPacket<?> packet;
                while ((packet = DemuxerImpl.this.nextPacket()) != null) {
                    if (!packet.is(MediaType.Audio) || packet.stream() != this) continue;
                    return packet.asAudio();
                }
                return null;
            }

            @Override
            public Iterator<IAudioFrame> iterator() {
                return VelvetVideoLib.iteratorFromSupplier(this::nextFrame);
            }

            @Override
            public IAudioStreamProperties properties() {
                int timebase_n = this.avstream.time_base.num.get();
                int timebase_d = this.avstream.time_base.den.get();
                long duration = this.avstream.duration.get() * 1000000000L * (long)timebase_n / (long)timebase_d;
                long frames = this.avstream.nb_frames.get();
                AVCodec codec = VelvetVideoLib.this.libavcodec.avcodec_find_decoder(this.codecCtx.codec_id.get());
                return new AudioStreamPropertiesImpl(codec.name.get(), this.targetFormat, duration, frames);
            }

            @Override
            public IAudioDecoderStream seek(long frameNumber) {
                throw new VelvetVideoException("Not yet implemented");
            }

            @Override
            public IAudioDecoderStream seekNano(long ns) {
                throw new VelvetVideoException("Not yet implemented");
            }

            @Override
            protected IFrameHolder createFrameHolder() {
                return new AudioFrameHolder(this.avstream.time_base, false, this.codecCtx, this.targetFormat);
            }
        }

        private class DecoderVideoStreamImpl
        extends AbstractDecoderStream
        implements IVideoDecoderStream {
            public DecoderVideoStreamImpl(AVStream avstream, String name) {
                super(avstream, name);
            }

            @Override
            public IVideoStreamProperties properties() {
                int timebase_n = this.avstream.time_base.num.get();
                int timebase_d = this.avstream.time_base.den.get();
                long duration = this.avstream.duration.get() * 1000000000L * (long)timebase_n / (long)timebase_d;
                if (duration == 0L) {
                    duration = ((DemuxerImpl)DemuxerImpl.this).formatCtx.duration.get() * 1000L;
                }
                long frames = this.avstream.nb_frames.get();
                int width = this.codecCtx.width.get();
                int height = this.codecCtx.height.get();
                AVCodec codec = VelvetVideoLib.this.libavcodec.avcodec_find_decoder(this.codecCtx.codec_id.get());
                double framerate = (double)this.avstream.avg_frame_rate.num.get() / (double)this.avstream.avg_frame_rate.den.get();
                return new VideoStreamProperties(codec.name.get(), framerate, duration, frames, width, height);
            }

            @Override
            public IVideoFrame nextFrame() {
                IDecodedPacket<?> packet;
                while ((packet = DemuxerImpl.this.nextPacket()) != null) {
                    if (!packet.is(MediaType.Video) || packet.stream() != this) continue;
                    return packet.asVideo();
                }
                return null;
            }

            @Override
            public Iterator<IVideoFrame> iterator() {
                return VelvetVideoLib.iteratorFromSupplier(this::nextFrame);
            }

            @Override
            public IVideoDecoderStream seek(long frameNumber) {
                this.seekToFrame(frameNumber);
                return this;
            }

            @Override
            public IVideoDecoderStream seekNano(long ns) {
                this.seekToNano(ns);
                return this;
            }

            @Override
            protected IFrameHolder createFrameHolder() {
                return new VideoFrameHolder(this.codecCtx.width.get(), this.codecCtx.height.get(), (AVPixelFormat)this.codecCtx.pix_fmt.get(), AVPixelFormat.AV_PIX_FMT_BGR24, this.avstream.time_base, false);
            }
        }

        private class IOCallback
        implements LibAVFormat.ICustomAvioCallback {
            private IOCallback() {
            }

            @Override
            public int read_packet(Pointer opaque, Pointer buf, int buf_size) {
                byte[] bytes = new byte[buf_size];
                int bts = DemuxerImpl.this.input.read(bytes);
                if (bts > 0) {
                    buf.put(0L, bytes, 0, bts);
                }
                return bts;
            }

            @Override
            public int seek(Pointer opaque, int offset, int whence) {
                boolean SEEK_SET = false;
                int SEEK_END = 2;
                int AVSEEK_SIZE = 65536;
                if (whence == 0) {
                    DemuxerImpl.this.input.seek(offset);
                } else if (whence == 2) {
                    DemuxerImpl.this.input.seek(DemuxerImpl.this.input.size() - (long)offset);
                } else {
                    if (whence == 65536) {
                        return (int)DemuxerImpl.this.input.size();
                    }
                    throw new VelvetVideoException("Unsupported seek operation " + whence);
                }
                return offset;
            }
        }
    }

    private class MuxerImpl
    implements IMuxer {
        private final Logger logMuxer = LoggerFactory.getLogger((String)"velvet-video.muxer");
        private final LibAVFormat libavformat;
        private final List<VideoEncoderStreamImpl> videoStreams = new ArrayList<VideoEncoderStreamImpl>();
        private final List<AudioEncoderStreamImpl> audioStreams = new ArrayList<AudioEncoderStreamImpl>();
        private final List<RemuxerStreamImpl> remuxerStreams = new ArrayList<RemuxerStreamImpl>();
        private final ISeekableOutput output;
        private final AVFormatContext formatCtx;
        private final IOCallback callback;

        private MuxerImpl(ISeekableOutput output, MuxerBuilderImpl builder) {
            this.libavformat = JNRHelper.load(LibAVFormat.class, "avformat", 58);
            this.output = output;
            this.formatCtx = VelvetVideoLib.this.createMuxerFormatContext(builder.format, builder.metadata);
            this.callback = new IOCallback();
            VelvetVideoLib.this.initCustomAvio(false, this.formatCtx, this.callback);
            Consumer<AVPacket> packetStream = packet -> {
                this.logMuxer.atDebug().addArgument(() -> packet.pts.get()).addArgument(() -> packet.dts.get()).addArgument(() -> packet.duration.get()).addArgument(() -> packet.size.get()).log("writing packet PTS/DTS = {}/{}, duration={}, {} bytes");
                VelvetVideoLib.this.checkcode(this.libavformat.av_write_frame(this.formatCtx, (AVPacket)((Object)packet)));
            };
            builder.builders.stream().forEach(brec -> {
                if (((MuxerBuilderImpl.BuilderRec)brec).video != null) {
                    this.videoStreams.add(new VideoEncoderStreamImpl(((MuxerBuilderImpl.BuilderRec)brec).video, this.formatCtx, packetStream));
                } else if (((MuxerBuilderImpl.BuilderRec)brec).audio != null) {
                    this.audioStreams.add(new AudioEncoderStreamImpl(((MuxerBuilderImpl.BuilderRec)brec).audio, this.formatCtx, packetStream));
                } else if (((MuxerBuilderImpl.BuilderRec)brec).remuxer != null) {
                    this.remuxerStreams.add(new RemuxerStreamImpl(((MuxerBuilderImpl.BuilderRec)brec).remuxer, this.formatCtx, packetStream));
                } else {
                    throw new VelvetVideoException("Unknown video stream builder type");
                }
            });
            VelvetVideoLib.this.checkcode(this.libavformat.avformat_write_header(this.formatCtx, null));
            this.videoStreams.forEach(enc -> enc.init());
            this.audioStreams.forEach(enc -> enc.init());
            this.remuxerStreams.forEach(enc -> enc.init());
        }

        @Override
        public IVideoEncoderStream videoEncoder(int index) {
            return this.videoStreams.stream().filter(vs -> vs.streamIndex == index).findFirst().orElseThrow(() -> new VelvetVideoException("No video stream found with index " + index));
        }

        @Override
        public IAudioEncoderStream audioEncoder(int index) {
            return this.audioStreams.stream().filter(vs -> vs.streamIndex == index).findFirst().orElseThrow(() -> new VelvetVideoException("No audio stream found with index " + index));
        }

        @Override
        public IRemuxerStream remuxer(int index) {
            return this.remuxerStreams.stream().filter(vs -> vs.streamIndex == index).findFirst().orElseThrow(() -> new VelvetVideoException("No remuxer stream found with index " + index));
        }

        @Override
        public void close() {
            for (VideoEncoderStreamImpl videoEncoderStreamImpl : this.videoStreams) {
                videoEncoderStreamImpl.close();
            }
            for (AudioEncoderStreamImpl audioEncoderStreamImpl : this.audioStreams) {
                audioEncoderStreamImpl.close();
            }
            for (RemuxerStreamImpl remuxerStreamImpl : this.remuxerStreams) {
                remuxerStreamImpl.close();
            }
            do {
                this.logMuxer.atDebug().log("flushing");
            } while (VelvetVideoLib.this.checkcode(this.libavformat.av_write_frame(this.formatCtx, null)) == 0);
            this.logMuxer.atDebug().log("writing trailer");
            VelvetVideoLib.this.checkcode(this.libavformat.av_write_trailer(this.formatCtx));
            AVIOContext avio = (AVIOContext)this.formatCtx.pb.get();
            VelvetVideoLib.this.libavutil.av_free(avio.buffer.get());
            this.libavformat.avio_context_free(new Pointer[]{Struct.getMemory((Struct)avio)});
            VelvetVideoLib.this.libavutil.av_dict_free(new Pointer[]{this.formatCtx.metadata.get()});
            this.formatCtx.metadata.set((Pointer)null);
            this.libavformat.avformat_free_context(this.formatCtx);
            this.output.close();
        }

        private class IOCallback
        implements LibAVFormat.ICustomAvioCallback {
            private IOCallback() {
            }

            @Override
            public int read_packet(Pointer opaque, Pointer buf, int buf_size) {
                byte[] bytes = new byte[buf_size];
                buf.get(0L, bytes, 0, buf_size);
                MuxerImpl.this.output.write(bytes);
                return buf_size;
            }

            @Override
            public int seek(Pointer opaque, int offset, int whence) {
                if (whence != 0) {
                    throw new IllegalArgumentException();
                }
                MuxerImpl.this.output.seek(offset);
                return offset;
            }
        }
    }

    private class MuxerBuilderImpl
    implements IMuxerBuilder {
        private final String format;
        private final List<BuilderRec> builders = new ArrayList<BuilderRec>();
        private final Map<String, String> metadata = new LinkedHashMap<String, String>();

        public MuxerBuilderImpl(String format) {
            this.format = format;
        }

        @Override
        public IMuxerBuilder videoEncoder(IVideoEncoderBuilder encoderBuilder) {
            this.builders.add(new BuilderRec(encoderBuilder));
            return this;
        }

        @Override
        public IMuxerBuilder audioEncoder(IAudioEncoderBuilder encoderBuilder) {
            this.builders.add(new BuilderRec(encoderBuilder));
            return this;
        }

        @Override
        public IMuxerBuilder remuxer(IDecoderStream<?, ?, ?> decoder) {
            return this.remuxer(new RemuxerBuilderImpl(decoder));
        }

        @Override
        public IMuxerBuilder remuxer(IRemuxerBuilder remuxerBuilder) {
            this.builders.add(new BuilderRec(remuxerBuilder));
            return this;
        }

        @Override
        public IMuxerBuilder metadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        @Override
        public IMuxer build(ISeekableOutput output) {
            return new MuxerImpl(output, this);
        }

        @Override
        public IMuxer build(File outputFile) {
            try {
                FileSeekableOutput output = new FileSeekableOutput(new FileOutputStream(outputFile));
                return new MuxerImpl(output, this);
            }
            catch (FileNotFoundException e) {
                throw new VelvetVideoException(e);
            }
        }

        private class BuilderRec {
            private final VideoEncoderBuilderImpl video;
            private final AudioEncoderBuilderImpl audio;
            private final RemuxerBuilderImpl remuxer;

            public BuilderRec(IVideoEncoderBuilder video) {
                this((VideoEncoderBuilderImpl)video, null, null);
            }

            public BuilderRec(IAudioEncoderBuilder audio) {
                this(null, (AudioEncoderBuilderImpl)audio, null);
            }

            public BuilderRec(IRemuxerBuilder remuxer) {
                this(null, null, (RemuxerBuilderImpl)remuxer);
            }

            public BuilderRec(VideoEncoderBuilderImpl video, AudioEncoderBuilderImpl audio, RemuxerBuilderImpl remuxer) {
                this.video = video;
                this.audio = audio;
                this.remuxer = remuxer;
            }
        }
    }

    private class AudioEncoderStreamImpl
    extends AbstractEncoderStreamImpl<AudioEncoderBuilderImpl>
    implements IAudioEncoderStream {
        private AudioFrameHolder frameHolder;
        private AudioFormat inputSampleFormat;

        public AudioEncoderStreamImpl(AudioEncoderBuilderImpl builder, AVFormatContext formatCtx, Consumer<AVPacket> output) {
            super(VelvetVideoLib.this, (AbstractEncoderBuilderImpl)builder, formatCtx, output);
        }

        @Override
        void initCodecCtx(AudioEncoderBuilderImpl builder) {
            this.inputSampleFormat = builder.inputFormat;
            Set<AVSampleFormat> supportedFormats = this.codec.sampleFormats();
            AVSampleFormat codecAVSampleFormat = BestMatchingAudioFormatConvertor.findBest(supportedFormats, this.inputSampleFormat);
            AudioFormat codecAudioFormat = codecAVSampleFormat.toAudioFormat((int)this.inputSampleFormat.getSampleRate(), this.inputSampleFormat.getChannels());
            this.codecCtx.sample_fmt.set((Enum)codecAVSampleFormat);
            this.codecCtx.sample_rate.set((int)codecAudioFormat.getSampleRate());
            this.codecCtx.channels.set(codecAudioFormat.getChannels());
            this.codecCtx.channel_layout.set((long)VelvetVideoLib.this.libavutil.av_get_default_channel_layout(codecAudioFormat.getChannels()));
            this.codecCtx.bit_rate.set(builder.bitrate == null ? 131072L : (long)builder.bitrate.intValue());
            VelvetVideoLib.this.checkcode(VelvetVideoLib.this.libavcodec.avcodec_open2(this.codecCtx, (AVCodec)this.codecCtx.codec.get(), new Pointer[]{this.codecOpts}));
            this.frameHolder = new AudioFrameHolder(this.codecCtx.time_base, true, this.codecCtx, builder.inputFormat);
            this.codecOpened = true;
        }

        @Override
        protected void fixEncodedPacketPtsDtsDuration() {
            this.packet.pts.set(this.codecToStream(this.packet.pts.get()));
            this.packet.dts.set(this.codecToStream(this.packet.dts.get()));
            this.packet.duration.set(this.codecToStream(this.packet.duration.get()));
        }

        private long codecToStream(long dur) {
            return dur * (long)this.stream.time_base.den.get() * (long)this.codecCtx.time_base.num.get() / (long)(this.stream.time_base.num.get() * this.codecCtx.time_base.den.get());
        }

        @Override
        public void encode(byte[] samples) {
            this.encode(samples, 0);
        }

        @Override
        public void encode(byte[] samples, int offset) {
            int duration = this.frameHolder.put(samples, offset);
            AVFrame frame = this.frameHolder.frame();
            frame.pts.set(this.nextPts);
            this.nextPts += (long)duration;
            this.submitFrame(frame, duration);
        }

        @Override
        public int frameBytes() {
            return this.frameHolder.frameBytes();
        }

        @Override
        public void close() {
            if (this.frameHolder != null) {
                this.frameHolder.close();
            }
            super.close();
        }
    }

    private class VideoEncoderStreamImpl
    extends AbstractEncoderStreamImpl<VideoEncoderBuilderImpl>
    implements IVideoEncoderStream {
        private VideoFrameHolder frameHolder;
        private final Map<Long, Integer> frameDurationCache;

        public VideoEncoderStreamImpl(VideoEncoderBuilderImpl builder, AVFormatContext formatCtx, Consumer<AVPacket> output) {
            super(VelvetVideoLib.this, (AbstractEncoderBuilderImpl)builder, formatCtx, output);
            this.frameDurationCache = new HashMap<Long, Integer>();
        }

        @Override
        void initCodecCtx(VideoEncoderBuilderImpl builder) {
            this.codecCtx.width.set(builder.width == null ? 1 : builder.width);
            this.codecCtx.height.set(builder.height == null ? 1 : builder.height);
            int firstFormat = this.codec.pix_fmts.get().getInt(0L);
            this.codecCtx.pix_fmt.set((Number)firstFormat);
        }

        @Override
        public void encode(BufferedImage image) {
            this.encode(image, 1);
        }

        @Override
        protected void submitFrame(AVFrame frame, int duration) {
            if (frame != null) {
                this.frameDurationCache.put(frame.pts.get(), duration);
            }
            super.submitFrame(frame, duration);
        }

        @Override
        public void encode(BufferedImage image, int duration) {
            int width = image.getWidth();
            int height = image.getHeight();
            if (!this.codecOpened) {
                this.codecCtx.width.set(width);
                this.codecCtx.height.set(height);
                VelvetVideoLib.this.checkcode(VelvetVideoLib.this.libavcodec.avcodec_open2(this.codecCtx, (AVCodec)this.codecCtx.codec.get(), new Pointer[]{this.codecOpts}));
                VelvetVideoLib.this.checkcode(VelvetVideoLib.this.libavcodec.avcodec_parameters_from_context((AVCodecParameters)this.stream.codecpar.get(), this.codecCtx));
                this.codecOpened = true;
                if (this.filterString != null) {
                    this.filters = new Filters(this.codecCtx, this.filterString);
                }
            } else if (this.codecCtx.width.get() != width || this.codecCtx.height.get() != height) {
                throw new VelvetVideoException("Image dimensions do not match, expected " + this.codecCtx.width.get() + "x" + this.codecCtx.height.get());
            }
            if (this.frameHolder == null) {
                this.frameHolder = new VideoFrameHolder(width, height, AVPixelFormat.avformatOf(image.getType()), (AVPixelFormat)this.codecCtx.pix_fmt.get(), this.stream.time_base, true);
            }
            AVFrame frame = this.frameHolder.setPixels(image);
            frame.extended_data.set(frame.data[0].getMemory());
            frame.pts.set(this.nextPts);
            this.nextPts += (long)(duration * this.defaultFrameDuration);
            this.submitFrame(frame, duration);
        }

        @Override
        protected void fixEncodedPacketPtsDtsDuration() {
            Integer dur = this.frameDurationCache.remove(this.packet.pts.get());
            if (this.packet.duration.get() == 0L || this.packet.duration.get() == Long.MIN_VALUE) {
                if (dur == null) {
                    dur = 1;
                }
                this.packet.duration.set((long)(dur * this.defaultFrameDuration));
                this.logEncoder.atDebug().addArgument(() -> this.packet.duration.get()).log(() -> "encoder: duration adjusted to {}");
            }
        }

        @Override
        public void close() {
            super.close();
            if (this.frameHolder != null) {
                this.frameHolder.close();
            }
            if (this.filters != null) {
                this.filters.close();
            }
        }
    }

    private static abstract class AbstractEncoderStreamImpl<B extends AbstractEncoderBuilderImpl<?>>
    extends AbstractMuxerStreamImpl {
        protected final AVCodecContext codecCtx;
        protected boolean codecOpened;
        protected final AVCodec codec;
        protected final Pointer codecOpts;
        protected final String filterString;
        protected Filters filters;
        private long nextExpectedPts;
        final /* synthetic */ VelvetVideoLib this$0;

        public AbstractEncoderStreamImpl(B builder, AVFormatContext formatCtx, Consumer<AVPacket> output) {
            this.this$0 = var1_1;
            super(output);
            this.codecOpts = ((VelvetVideoLib)var1_1).libavutil.createDictionary(((AbstractEncoderBuilderImpl)builder).params);
            this.filterString = ((AbstractEncoderBuilderImpl)builder).filter;
            this.codec = ((VelvetVideoLib)var1_1).libavcodec.avcodec_find_encoder_by_name(((AbstractEncoderBuilderImpl)builder).codec);
            if (this.codec == null && ((AbstractEncoderBuilderImpl)builder).decoder == null) {
                throw new VelvetVideoException("Unknown video codec: " + ((AbstractEncoderBuilderImpl)builder).codec);
            }
            this.stream = ((VelvetVideoLib)var1_1).libavformat.avformat_new_stream(formatCtx, this.codec);
            this.codecCtx = ((VelvetVideoLib)var1_1).libavcodec.avcodec_alloc_context3(this.codec);
            if ((((AVOutputFormat)formatCtx.oformat.get()).flags.get() & 0x40) != 0 && !this.codec.name.get().equals("libx265")) {
                this.codecCtx.flags.set(this.codecCtx.flags.get() | 0x400000);
            }
            this.codecCtx.codec_id.set(this.codec.id.get());
            this.codecCtx.codec_type.set(this.codec.type.get());
            this.codecCtx.bit_rate.set(((AbstractEncoderBuilderImpl)builder).bitrate == null ? 400000L : (long)((AbstractEncoderBuilderImpl)builder).bitrate.intValue());
            this.codecCtx.time_base.num.set(((AbstractEncoderBuilderImpl)builder).timebaseNum == null ? 1 : ((AbstractEncoderBuilderImpl)builder).timebaseNum);
            this.codecCtx.time_base.den.set(((AbstractEncoderBuilderImpl)builder).timebaseDen == null ? 30 : ((AbstractEncoderBuilderImpl)builder).timebaseDen);
            if (((AbstractEncoderBuilderImpl)builder).enableExperimental) {
                this.codecCtx.strict_std_compliance.set(-2);
                formatCtx.strict_std_compliance.set(-2);
            }
            this.initCodecCtx(builder);
            Pointer dictionary = ((VelvetVideoLib)var1_1).libavutil.createDictionary(((AbstractEncoderBuilderImpl)builder).metadata);
            this.stream.metadata.set(dictionary);
            ((VelvetVideoLib)var1_1).checkcode(((VelvetVideoLib)var1_1).libavcodec.avcodec_parameters_from_context((AVCodecParameters)this.stream.codecpar.get(), this.codecCtx));
            this.stream.time_base.num.set(this.codecCtx.time_base.num.get());
            this.stream.time_base.den.set(this.codecCtx.time_base.den.get());
            this.stream.index.set((Number)(formatCtx.nb_streams.get() - 1L));
            this.stream.id.set((Number)(formatCtx.nb_streams.get() - 1L));
            this.codecTimeBaseNum = this.codecCtx.time_base.num.get();
            this.codecTimeBaseDen = this.codecCtx.time_base.den.get();
        }

        abstract void initCodecCtx(B var1);

        protected void submitFrame(AVFrame frame, int duration) {
            if (this.filters == null) {
                this.encodeFrame(frame);
            } else {
                Feeder.feed(frame, inputFrame -> this.filters.submitFrame((AVFrame)((Object)inputFrame)), outputFrame -> {
                    this.encodeFrame((AVFrame)((Object)outputFrame));
                    this.this$0.libavutil.av_frame_unref((AVFrame)((Object)outputFrame));
                });
            }
        }

        private void encodeFrame(AVFrame frame) {
            this.logEncoder.atDebug().addArgument((Object)this.streamIndex).log(() -> frame == null ? "stream {}: flush" : "stream {}: send frame for encoding, PTS=" + frame.pts.get());
            this.this$0.checkcode(this.this$0.libavcodec.avcodec_send_frame(this.codecCtx, frame));
            while (true) {
                this.this$0.libavcodec.av_init_packet(this.packet);
                int res = this.this$0.libavcodec.avcodec_receive_packet(this.codecCtx, this.packet);
                if (res == -11 || res == -541478725) break;
                this.this$0.checkcode(res);
                this.packet.stream_index.set(this.streamIndex);
                this.logEncoder.atDebug().addArgument(() -> this.packet.pts.get()).addArgument(() -> this.packet.dts.get()).addArgument(() -> this.packet.duration.get()).addArgument(() -> this.packet.size.get()).log(() -> "encoder: returned packet  PTS/DTS: {}/{}, duration={}, {} bytes");
                this.fixEncodedPacketPtsDtsDuration();
                if (this.packet.pts.get() != this.nextExpectedPts) {
                    this.logEncoder.atWarn().addArgument((Object)this.nextExpectedPts).addArgument((Object)this.packet.pts.get()).log("expected PTS mismatch: expected {}, actual {}");
                }
                this.nextExpectedPts = this.packet.pts.get() + this.packet.duration.get();
                this.output.accept(this.packet);
                this.this$0.libavcodec.av_packet_unref(this.packet);
            }
        }

        protected abstract void fixEncodedPacketPtsDtsDuration();

        @Override
        public void close() {
            if (this.codecOpened) {
                this.submitFrame(null, this.defaultFrameDuration);
                this.this$0.libavcodec.avcodec_close(this.codecCtx);
                this.this$0.libavcodec.avcodec_free_context(new Pointer[]{Struct.getMemory((Struct)this.codecCtx)});
            }
            super.close();
        }
    }

    private class RemuxerStreamImpl
    extends AbstractMuxerStreamImpl
    implements IRemuxerStream {
        private final int originalStreamTimeBaseNum;
        private final int originalStreamTimeBaseDen;
        private int frameSize;

        public RemuxerStreamImpl(RemuxerBuilderImpl builder, AVFormatContext formatCtx, Consumer<AVPacket> output) {
            super(output);
            this.stream = VelvetVideoLib.this.libavformat.avformat_new_stream(formatCtx, null);
            DemuxerImpl.AbstractDecoderStream decoderImpl = (DemuxerImpl.AbstractDecoderStream)((Object)builder.decoder);
            VelvetVideoLib.this.checkcode(VelvetVideoLib.this.libavcodec.avcodec_parameters_copy((AVCodecParameters)this.stream.codecpar.get(), (AVCodecParameters)decoderImpl.avstream.codecpar.get()));
            ((AVCodecParameters)this.stream.codecpar.get()).codec_tag.set(0L);
            AVCodecContext codecCtx = (AVCodecContext)this.stream.codec.get();
            if ((((AVOutputFormat)formatCtx.oformat.get()).flags.get() & 0x40) != 0 && ((AVCodecParameters)decoderImpl.avstream.codecpar.get()).codec_id.get() != 27) {
                codecCtx.flags.set(codecCtx.flags.get() | 0x400000);
            }
            int timeBaseNum = builder.timebaseNum == null ? decoderImpl.codecCtx.time_base.num.get() * decoderImpl.codecCtx.ticks_per_frame.get() : builder.timebaseNum;
            int timeBaseDen = builder.timebaseDen == null ? decoderImpl.codecCtx.time_base.den.get() : builder.timebaseDen.intValue();
            this.stream.time_base.num.set(timeBaseNum);
            this.stream.time_base.den.set(timeBaseDen);
            this.codecTimeBaseNum = timeBaseNum;
            this.codecTimeBaseDen = timeBaseDen;
            this.originalStreamTimeBaseNum = decoderImpl.avstream.time_base.num.get();
            this.originalStreamTimeBaseDen = decoderImpl.avstream.time_base.den.get();
            if (decoderImpl.codecCtx.codec_type.get() == 1) {
                this.frameSize = decoderImpl.codecCtx.frame_size.get();
            }
            this.codecTimeBaseDen = timeBaseDen;
        }

        @Override
        public void init() {
            this.defaultFrameDuration = this.frameSize > 0 ? this.frameSize * this.codecTimeBaseDen * this.stream.time_base.num.get() / this.codecTimeBaseNum / this.stream.time_base.den.get() : this.codecTimeBaseNum * this.stream.time_base.den.get() / this.codecTimeBaseDen / this.stream.time_base.num.get();
            this.streamIndex = this.stream.index.get();
            this.logEncoder.atInfo().addArgument((Object)this.stream.index.get()).addArgument((Object)this.stream.time_base.num.get()).addArgument((Object)this.stream.time_base.den.get()).addArgument((Object)((AVCodec)((AVCodecContext)this.stream.codec.get()).codec.get()).name.get()).addArgument((Object)this.codecTimeBaseNum).addArgument((Object)this.codecTimeBaseDen).log("stream {} (remux): timebase: {}/{}, codec [{}] timebase {}/{}");
        }

        @Override
        public void writeRaw(byte[] packetData) {
            VelvetVideoLib.this.checkcode(VelvetVideoLib.this.libavcodec.av_new_packet(this.packet, packetData.length));
            this.packet.data.get().put(0L, packetData, 0, packetData.length);
            this.packet.stream_index.set(this.streamIndex);
            this.packet.pts.set(this.nextPts);
            this.packet.duration.set((long)this.defaultFrameDuration);
            this.nextPts += (long)this.defaultFrameDuration;
            this.output.accept(this.packet);
            VelvetVideoLib.this.libavcodec.av_packet_unref(this.packet);
        }
    }

    private abstract class AbstractMuxerStreamImpl
    implements AutoCloseable {
        protected final Logger logEncoder = LoggerFactory.getLogger((String)"velvet-video.encoder");
        final Consumer<AVPacket> output;
        final AVPacket packet;
        AVStream stream;
        int codecTimeBaseNum;
        int codecTimeBaseDen;
        int streamIndex;
        long nextPts = 0L;
        int defaultFrameDuration;

        AbstractMuxerStreamImpl(Consumer<AVPacket> output) {
            this.output = output;
            this.packet = VelvetVideoLib.this.libavcodec.av_packet_alloc();
        }

        public void init() {
            this.defaultFrameDuration = this.codecTimeBaseNum * this.stream.time_base.den.get() / this.codecTimeBaseDen / this.stream.time_base.num.get();
            this.streamIndex = this.stream.index.get();
            this.logEncoder.atInfo().addArgument((Object)this.stream.index.get()).addArgument((Object)this.stream.time_base.num.get()).addArgument((Object)this.stream.time_base.den.get()).addArgument((Object)((AVCodec)((AVCodecContext)this.stream.codec.get()).codec.get()).name.get()).addArgument((Object)this.codecTimeBaseNum).addArgument((Object)this.codecTimeBaseDen).log("stream {}: timebase: {}/{}, codec [{}] timebase {}/{}");
        }

        @Override
        public void close() {
            VelvetVideoLib.this.libavcodec.av_packet_unref(this.packet);
            VelvetVideoLib.this.libavcodec.av_packet_free(new Pointer[]{Struct.getMemory((Struct)this.packet)});
        }
    }
}

