/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo.impl;

import com.zakgof.velvetvideo.ISeekableInput;
import com.zakgof.velvetvideo.VelvetVideoException;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class FileSeekableInput
implements ISeekableInput {
    private SeekableByteChannel channel;
    private FileInputStream fos;

    public FileSeekableInput(FileInputStream fis) {
        this.fos = fis;
        this.channel = fis.getChannel();
    }

    @Override
    public int read(byte[] bytes) {
        try {
            return this.channel.read(ByteBuffer.wrap(bytes));
        }
        catch (IOException e) {
            throw new VelvetVideoException(e);
        }
    }

    @Override
    public void seek(long position) {
        try {
            this.channel.position(position);
        }
        catch (IOException e) {
            throw new VelvetVideoException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
            this.fos.close();
        }
        catch (IOException e) {
            throw new VelvetVideoException(e);
        }
    }

    @Override
    public long size() {
        try {
            return this.channel.size();
        }
        catch (IOException e) {
            throw new VelvetVideoException(e);
        }
    }
}

