/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo;

import com.zakgof.velvetvideo.ISeekableOutput;
import java.util.ArrayList;
import java.util.List;

public class MemSeekableFile
implements ISeekableOutput {
    private static final int CHUNK = 0x100000;
    private long length;
    private long position;
    private final List<byte[]> buffers = new ArrayList<byte[]>();

    @Override
    public void write(byte[] bytes) {
        long bytesToAllocate = this.position + (long)bytes.length - (long)(this.buffers.size() * 0x100000);
        if (bytesToAllocate > 0L) {
            long buffersToAllocate = (bytesToAllocate - 1L) / 0x100000L * 0x100000L + 1L;
            int i = 0;
            while ((long)i < buffersToAllocate) {
                this.buffers.add(new byte[0x100000]);
                ++i;
            }
        }
        int messagepos = 0;
        while (messagepos < bytes.length) {
            long chunk = this.position / 0x100000L;
            long offset = this.position % 0x100000L;
            long len = Math.min((long)(bytes.length - messagepos), 0x100000L - offset);
            System.arraycopy(bytes, messagepos, this.buffers.get((int)chunk), (int)offset, (int)len);
            this.position += len;
            messagepos = (int)((long)messagepos + len);
        }
        if (this.position > this.length) {
            this.length = this.position;
        }
    }

    @Override
    public void seek(long position) {
        if (position > this.length) {
            throw new IllegalArgumentException();
        }
        this.position = position;
    }

    @Override
    public void close() {
    }

    public byte[] toBytes() {
        byte[] result = new byte[(int)this.length];
        int pos = 0;
        while ((long)pos < this.length) {
            long chunk = pos / 0x100000;
            long offset = pos % 0x100000;
            long len = Math.min(this.length - (long)pos, 0x100000L - offset);
            System.arraycopy(this.buffers.get((int)chunk), (int)offset, result, pos, (int)len);
            pos = (int)((long)pos + len);
        }
        return result;
    }
}

