/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.velvetvideo;

import com.zakgof.velvetvideo.Direction;
import com.zakgof.velvetvideo.IAudioEncoderBuilder;
import com.zakgof.velvetvideo.IDecoderStream;
import com.zakgof.velvetvideo.IDemuxer;
import com.zakgof.velvetvideo.IMuxerBuilder;
import com.zakgof.velvetvideo.IRemuxerBuilder;
import com.zakgof.velvetvideo.ISeekableInput;
import com.zakgof.velvetvideo.IVideoEncoderBuilder;
import com.zakgof.velvetvideo.MediaType;
import com.zakgof.velvetvideo.VelvetVideoException;
import com.zakgof.velvetvideo.impl.FileSeekableInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;
import javax.sound.sampled.AudioFormat;

public interface IVelvetVideoLib {
    public List<String> codecs(Direction var1, MediaType var2);

    public List<String> formats(Direction var1);

    public IVideoEncoderBuilder videoEncoder(String var1);

    public IAudioEncoderBuilder audioEncoder(String var1, AudioFormat var2);

    public IRemuxerBuilder remuxer(IDecoderStream<?, ?, ?> var1);

    public IMuxerBuilder muxer(String var1);

    public IDemuxer demuxer(ISeekableInput var1);

    default public IDemuxer demuxer(File file) {
        try {
            return this.demuxer(new FileSeekableInput(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw new VelvetVideoException(e);
        }
    }
}

