/*
 * Decompiled with CFR 0.152.
 */
package com.github.zagum.speechrecognitionview.animators;

import android.graphics.Point;
import com.github.zagum.speechrecognitionview.RecognitionBar;
import com.github.zagum.speechrecognitionview.animators.BarParamsAnimator;
import java.util.ArrayList;
import java.util.List;

public class TransformAnimator
implements BarParamsAnimator {
    private static final long DURATION = 300L;
    private long startTimestamp;
    private boolean isPlaying;
    private OnInterpolationFinishedListener listener;
    private final int radius;
    private final int centerX;
    private final int centerY;
    private final List<Point> finalPositions = new ArrayList<Point>();
    private final List<RecognitionBar> bars;

    public TransformAnimator(List<RecognitionBar> bars, int centerX, int centerY, int radius) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.bars = bars;
        this.radius = radius;
    }

    @Override
    public void start() {
        this.isPlaying = true;
        this.startTimestamp = System.currentTimeMillis();
        this.initFinalPositions();
    }

    @Override
    public void stop() {
        this.isPlaying = false;
        if (this.listener != null) {
            this.listener.onFinished();
        }
    }

    @Override
    public void animate() {
        if (!this.isPlaying) {
            return;
        }
        long currTimestamp = System.currentTimeMillis();
        long delta = currTimestamp - this.startTimestamp;
        if (delta > 300L) {
            delta = 300L;
        }
        for (int i = 0; i < this.bars.size(); ++i) {
            RecognitionBar bar = this.bars.get(i);
            int x = bar.getStartX() + (int)((float)(this.finalPositions.get((int)i).x - bar.getStartX()) * ((float)delta / 300.0f));
            int y = bar.getStartY() + (int)((float)(this.finalPositions.get((int)i).y - bar.getStartY()) * ((float)delta / 300.0f));
            bar.setX(x);
            bar.setY(y);
            bar.update();
        }
        if (delta == 300L) {
            this.stop();
        }
    }

    private void initFinalPositions() {
        Point startPoint = new Point();
        startPoint.x = this.centerX;
        startPoint.y = this.centerY - this.radius;
        for (int i = 0; i < 5; ++i) {
            Point point = new Point(startPoint);
            this.rotate(72.0 * (double)i, point);
            this.finalPositions.add(point);
        }
    }

    private void rotate(double degrees, Point point) {
        double angle = Math.toRadians(degrees);
        int x = this.centerX + (int)((double)(point.x - this.centerX) * Math.cos(angle) - (double)(point.y - this.centerY) * Math.sin(angle));
        int y = this.centerY + (int)((double)(point.x - this.centerX) * Math.sin(angle) + (double)(point.y - this.centerY) * Math.cos(angle));
        point.x = x;
        point.y = y;
    }

    public void setOnInterpolationFinishedListener(OnInterpolationFinishedListener listener) {
        this.listener = listener;
    }

    public static interface OnInterpolationFinishedListener {
        public void onFinished();
    }
}

