/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver;

import com.github.zafarkhaja.semver.GrammarException;
import com.github.zafarkhaja.semver.MetadataVersion;
import com.github.zafarkhaja.semver.NormalVersion;
import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.util.Stream;
import java.util.ArrayList;

class VersionParser
implements Parser<Version> {
    private final Stream<Character> chars;

    VersionParser(String input) {
        Character[] elements = new Character[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            elements[i] = Character.valueOf(input.charAt(i));
        }
        this.chars = new Stream<Character>(elements);
    }

    @Override
    public Version parse(String input) {
        return this.parseValidSemVer();
    }

    static Version parseValidSemVer(String version) {
        VersionParser parser = new VersionParser(version);
        return parser.parseValidSemVer();
    }

    static NormalVersion parseVersionCore(String versionCore) {
        VersionParser parser = new VersionParser(versionCore);
        return parser.parseVersionCore();
    }

    static MetadataVersion parsePreRelease(String preRelease) {
        if (preRelease == null) {
            return MetadataVersion.NULL;
        }
        VersionParser parser = new VersionParser(preRelease);
        return parser.parsePreRelease();
    }

    static MetadataVersion parseBuild(String build) {
        if (build == null) {
            return MetadataVersion.NULL;
        }
        VersionParser parser = new VersionParser(build);
        return parser.parseBuild();
    }

    private Version parseValidSemVer() {
        NormalVersion normalVersion = this.parseVersionCore();
        MetadataVersion preReleaseVersion = MetadataVersion.NULL;
        MetadataVersion buildMetadata = MetadataVersion.NULL;
        if (this.chars.positiveLookahead(new Char[]{Char.HYPHEN})) {
            this.chars.consume();
            preReleaseVersion = this.parsePreRelease();
        }
        if (this.chars.positiveLookahead(new Char[]{Char.PLUS})) {
            this.chars.consume();
            buildMetadata = this.parseBuild();
        }
        return new Version(normalVersion, preReleaseVersion, buildMetadata);
    }

    private NormalVersion parseVersionCore() {
        int major = Integer.parseInt(this.numericIdentifier());
        this.chars.consume(new Char[]{Char.DOT});
        int minor = Integer.parseInt(this.numericIdentifier());
        this.chars.consume(new Char[]{Char.DOT});
        int patch = Integer.parseInt(this.numericIdentifier());
        return new NormalVersion(major, minor, patch);
    }

    private MetadataVersion parsePreRelease() {
        Char end = this.closestEndpoint(Char.PLUS, Char.EOL);
        Char before = this.closestEndpoint(Char.DOT, end);
        ArrayList<String> idents = new ArrayList<String>();
        while (!this.chars.positiveLookahead(new Char[]{end})) {
            if (before == Char.DOT) {
                this.checkForEmptyIdentifier();
            }
            if (this.chars.positiveLookaheadBefore(before, new Char[]{Char.LETTER, Char.HYPHEN})) {
                idents.add(this.alphanumericIdentifier());
            } else {
                idents.add(this.numericIdentifier());
            }
            if (before == Char.DOT) {
                this.chars.consume();
            }
            before = this.closestEndpoint(Char.DOT, end);
        }
        return new MetadataVersion(idents.toArray(new String[idents.size()]));
    }

    private MetadataVersion parseBuild() {
        Char end = Char.EOL;
        Char before = this.closestEndpoint(Char.DOT, end);
        ArrayList<String> idents = new ArrayList<String>();
        while (!this.chars.positiveLookahead(new Char[]{end})) {
            if (before == Char.DOT) {
                this.checkForEmptyIdentifier();
            }
            if (this.chars.positiveLookaheadBefore(before, new Char[]{Char.LETTER, Char.HYPHEN})) {
                idents.add(this.alphanumericIdentifier());
            } else {
                idents.add(this.digits());
            }
            if (before == Char.DOT) {
                this.chars.consume();
            }
            before = this.closestEndpoint(Char.DOT, end);
        }
        return new MetadataVersion(idents.toArray(new String[idents.size()]));
    }

    private String numericIdentifier() {
        this.checkForLeadingZeroes();
        StringBuilder sb = new StringBuilder();
        sb.append(this.chars.consume(new Char[]{Char.DIGIT}));
        while (this.chars.positiveLookahead(new Char[]{Char.DIGIT})) {
            sb.append(this.chars.consume());
        }
        return sb.toString();
    }

    private String alphanumericIdentifier() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.chars.consume(new Char[]{Char.DIGIT, Char.LETTER, Char.HYPHEN}));
        while (this.chars.positiveLookahead(new Char[]{Char.DIGIT, Char.LETTER, Char.HYPHEN})) {
            sb.append(this.chars.consume());
        }
        return sb.toString();
    }

    private String digits() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.chars.consume(new Char[]{Char.DIGIT}));
        while (this.chars.positiveLookahead(new Char[]{Char.DIGIT})) {
            sb.append(this.chars.consume());
        }
        return sb.toString();
    }

    private Char closestEndpoint(Char tryThis, Char orThis) {
        if (this.chars.positiveLookaheadBefore(orThis, new Char[]{tryThis})) {
            return tryThis;
        }
        return orThis;
    }

    private void checkForLeadingZeroes() {
        Character la1 = this.chars.lookahead(1);
        Character la2 = this.chars.lookahead(2);
        if (la1.charValue() == '0' && Char.DIGIT.isMatchedBy(la2)) {
            throw new GrammarException("Numeric identifier MUST NOT contain leading zeroes");
        }
    }

    private void checkForEmptyIdentifier() {
        if (Char.DOT.isMatchedBy(this.chars.lookahead(1))) {
            throw new GrammarException("Identifiers MUST NOT be empty");
        }
    }

    static enum Char implements Stream.ElementType<Character>
    {
        DIGIT{

            @Override
            public boolean isMatchedBy(Character chr) {
                if (chr == null) {
                    return false;
                }
                return chr.charValue() >= '0' && chr.charValue() <= '9';
            }
        }
        ,
        LETTER{

            @Override
            public boolean isMatchedBy(Character chr) {
                if (chr == null) {
                    return false;
                }
                return chr.charValue() >= 'a' && chr.charValue() <= 'z' || chr.charValue() >= 'A' && chr.charValue() <= 'Z';
            }
        }
        ,
        DOT{

            @Override
            public boolean isMatchedBy(Character chr) {
                if (chr == null) {
                    return false;
                }
                return chr.charValue() == '.';
            }
        }
        ,
        HYPHEN{

            @Override
            public boolean isMatchedBy(Character chr) {
                if (chr == null) {
                    return false;
                }
                return chr.charValue() == '-';
            }
        }
        ,
        PLUS{

            @Override
            public boolean isMatchedBy(Character chr) {
                if (chr == null) {
                    return false;
                }
                return chr.charValue() == '+';
            }
        }
        ,
        EOL{

            @Override
            public boolean isMatchedBy(Character chr) {
                return chr == null;
            }
        };

    }
}

