/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.resolver;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import com.suke.zhjg.common.autofull.annotation.AutoDecodeMask;
import com.suke.zhjg.common.autofull.decode.DecodeMaskDataHandle;
import com.suke.zhjg.common.autofull.entity.ConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Component
public class AutoDecodeMaskParamResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(AutoDecodeMaskParamResolver.class);
    @Autowired
    public ConfigProperties configProperties;

    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.hasParameterAnnotation(AutoDecodeMask.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer container, NativeWebRequest webRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        Object obj = parameter.getParameterType().newInstance();
        webRequest.getParameterMap().forEach((key, value) -> {
            try {
                if (ArrayUtil.isNotEmpty((Object[])value)) {
                    String temp = String.valueOf(value[0]);
                    if (temp.contains("*") && !temp.contains(this.configProperties.getEncryptFlag())) {
                        throw new RuntimeException("\u8131\u654f\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff0c\u7f3a\u5c11key");
                    }
                    if (temp.contains("*") && temp.contains(this.configProperties.getEncryptFlag())) {
                        log.info("key:{},value:{}", key, (Object)temp);
                        temp = DecodeMaskDataHandle.decode(temp);
                    }
                    BeanUtil.setProperty((Object)obj, (String)key, (Object)temp);
                }
            }
            catch (Exception e) {
                log.error("\u8131\u654f\u6570\u636e\u89e3\u5bc6\u5931\u8d25:", (Throwable)e);
            }
        });
        return obj;
    }
}

