/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.suke.zhjg.common.autofull.annotation.AutoFullConfiguration;
import com.suke.zhjg.common.autofull.annotation.AutoFullListSQL;
import com.suke.zhjg.common.autofull.cache.AutoFullRedisCache;
import com.suke.zhjg.common.autofull.handler.AutoFullHandler;
import com.suke.zhjg.common.autofull.handler.DefaultHandler;
import com.suke.zhjg.common.autofull.sequence.AutoSequence;
import com.suke.zhjg.common.autofull.sql.AutoFullSqlJdbcTemplate;
import com.suke.zhjg.common.autofull.util.StringSQLUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.stereotype.Component;

@Component
@AutoFullConfiguration(type=AutoFullListSQL.class)
public class AutoFullListSQLService
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFullListSQLService.class);

    @Override
    public String sql(String sql) {
        Matcher matcher = StringSQLUtil.parse(sql);
        while (matcher.find()) {
            String fieldKey = matcher.group(1);
            sql = sql.replace("{" + fieldKey + "}", " ? ");
        }
        return sql;
    }

    @Override
    public void result(Annotation annotation, Field[] fields, Field field, Object obj, String sequence, int level) {
        try {
            if (annotation instanceof AutoFullListSQL) {
                Object object = AutoSequence.init().get(sequence);
                AutoFullListSQL fieldAnnotation = field.getAnnotation(AutoFullListSQL.class);
                field.setAccessible(true);
                String sql = fieldAnnotation.sql();
                boolean useCache = fieldAnnotation.useCache();
                Map<Integer, Object> param = this.getParam(fields, obj, sql);
                if (ObjectUtil.isNotNull(param)) {
                    String parseSql = this.sql(sql);
                    if (this.configProperties.isShowLog()) {
                        log.info("ID:{}, LEVEL:{}, SQL:{}", new Object[]{sequence, level, parseSql});
                        log.info("ID:{}, LEVEL:{}, param\uff1a{}", new Object[]{sequence, level, param});
                    }
                    List<Class<Object>> result = null;
                    if (useCache) {
                        List<Class<?>> data = AutoFullRedisCache.getList(sequence, parseSql, param, this.getBeanClassType(field));
                        if (CollUtil.isNotEmpty(data)) {
                            result = data;
                        } else {
                            Class<?> classType = this.getListClassType(field);
                            List<Object> paramList = this.getParamList(fields, obj, sql);
                            BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(classType);
                            result = AutoFullSqlJdbcTemplate.queryList(parseSql, rm, paramList.toArray());
                            AutoFullRedisCache.setData(sequence, parseSql, param, result);
                        }
                    } else {
                        Class<?> classType = this.getListClassType(field);
                        List<Object> paramList = this.getParamList(fields, obj, sql);
                        BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(classType);
                        result = AutoFullSqlJdbcTemplate.queryList(parseSql, rm, paramList.toArray());
                    }
                    if (CollUtil.isNotEmpty(result)) {
                        int maxLevel;
                        if (ObjectUtil.isNotNull((Object)object) && level < (maxLevel = ((Integer)object).intValue()) && fieldAnnotation.childLevel()) {
                            AutoFullHandler.full(result, sequence, ++level);
                        }
                        field.set(obj, result);
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u586b\u5145List\u5931\u8d25:{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

