/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.suke.zhjg.common.autofull.annotation.AutoFullBean;
import com.suke.zhjg.common.autofull.annotation.AutoFullConfiguration;
import com.suke.zhjg.common.autofull.cache.AutoFullRedisCache;
import com.suke.zhjg.common.autofull.constant.ConstantSQL;
import com.suke.zhjg.common.autofull.handler.AutoFullHandler;
import com.suke.zhjg.common.autofull.handler.DefaultHandler;
import com.suke.zhjg.common.autofull.sequence.AutoSequence;
import com.suke.zhjg.common.autofull.sql.AutoFullSqlJdbcTemplate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.stereotype.Component;

@Component
@AutoFullConfiguration(type=AutoFullBean.class)
public class AutoFullBeanService
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFullBeanService.class);

    @Override
    public String sql(String table, String alias, String conditionField) {
        conditionField = this.getConditionField(conditionField);
        String sql = (Object)((Object)ConstantSQL.SQL.SELECT) + " * " + (Object)((Object)ConstantSQL.SQL.FROM) + " " + table + " " + (Object)((Object)ConstantSQL.SQL.WHERE) + " " + conditionField + "  =  ?";
        return sql;
    }

    @Override
    public void result(Annotation annotation, Field[] fields, Field field, Object obj, String sequence, int level) {
        try {
            if (annotation instanceof AutoFullBean) {
                Object object = AutoSequence.init().get(sequence);
                AutoFullBean fieldAnnotation = field.getAnnotation(AutoFullBean.class);
                field.setAccessible(true);
                String alias = field.getName();
                String table = fieldAnnotation.table();
                boolean useCache = fieldAnnotation.useCache();
                String tableField = fieldAnnotation.conditionField();
                Object param = this.findFieldValue(fields, tableField, obj);
                if (ObjectUtil.isNotNull((Object)param)) {
                    String sql = this.sql(table, alias, tableField);
                    if (this.configProperties.isShowLog()) {
                        log.info("ID:{}, LEVEL:{}, SQL:{}", new Object[]{sequence, level, sql});
                        log.info("ID:{}, LEVEL:{}, param\uff1a{}", new Object[]{sequence, level, param});
                    }
                    HashMap<Integer, Object> paramMap = new HashMap<Integer, Object>();
                    paramMap.put(1, param);
                    List<Class<Object>> result = null;
                    if (useCache) {
                        List<Class<?>> data = AutoFullRedisCache.getList(sequence, sql, param, this.getBeanClassType(field));
                        if (CollUtil.isNotEmpty(data)) {
                            result = data;
                        } else {
                            Class<?> classType = this.getBeanClassType(field);
                            BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(classType);
                            result = AutoFullSqlJdbcTemplate.queryList(sql, rm, new Object[]{param});
                            AutoFullRedisCache.setData(sequence, sql, param, result);
                        }
                    } else {
                        Class<?> classType = this.getBeanClassType(field);
                        BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(classType);
                        result = AutoFullSqlJdbcTemplate.queryList(sql, rm, new Object[]{param});
                    }
                    if (CollUtil.isNotEmpty(result)) {
                        int maxLevel;
                        if (ObjectUtil.isNotNull((Object)object) && level < (maxLevel = ((Integer)object).intValue()) && fieldAnnotation.childLevel()) {
                            AutoFullHandler.full(result, sequence, ++level);
                        }
                        field.set(obj, result.get(0));
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u586b\u5145Bean\u5931\u8d25:{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

