/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.decode;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suke.zhjg.common.autofull.config.ApplicationContextRegister;
import com.suke.zhjg.common.autofull.entity.ConfigProperties;
import com.suke.zhjg.common.autofull.util.CryptUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DecodeMaskDataHandle {
    private static final Logger log = LoggerFactory.getLogger(DecodeMaskDataHandle.class);

    public static String decode(String decrypt) {
        return DecodeMaskDataHandle.getValue(decrypt);
    }

    public static <T> T decode(T data) {
        Class<?> aClass = data.getClass();
        for (Field field : aClass.getDeclaredFields()) {
            Object value = field.get(data);
            field.setAccessible(true);
            String temp = String.valueOf(value);
            if (!temp.contains("*") || !temp.contains(DecodeMaskDataHandle.getConfigProperties().getEncryptFlag())) continue;
            temp = DecodeMaskDataHandle.getValue(temp);
            field.set(data, temp);
        }
        return data;
    }

    public static <T> List<T> decode(List<T> list) {
        if (CollUtil.isNotEmpty(list)) {
            list.forEach(obj -> {
                obj = DecodeMaskDataHandle.decode(obj);
            });
        }
        return list;
    }

    public static InputStream decode(InputStream in, ObjectMapper objectMapper, Type type) {
        String bodyStr = IoUtil.read((InputStream)in, (Charset)CharsetUtil.CHARSET_UTF_8);
        try {
            if (bodyStr.contains("*") && !bodyStr.contains(DecodeMaskDataHandle.getConfigProperties().getEncryptFlag())) {
                throw new RuntimeException("\u8131\u654f\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff0c\u7f3a\u5c11key");
            }
            Object object = objectMapper.readValue(bodyStr, Class.forName(type.getTypeName()));
            Object decode = DecodeMaskDataHandle.decode(object);
            bodyStr = objectMapper.writeValueAsString(decode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return IoUtil.toStream((String)bodyStr, (Charset)CharsetUtil.CHARSET_UTF_8);
    }

    protected static String getValue(String value) {
        if (StrUtil.isNotEmpty((CharSequence)value)) {
            if (value.contains("*") && value.contains(DecodeMaskDataHandle.getConfigProperties().getEncryptFlag())) {
                int index = value.indexOf(DecodeMaskDataHandle.getConfigProperties().getEncryptFlag());
                String key = value.substring(index + DecodeMaskDataHandle.getConfigProperties().getEncryptFlag().length());
                if (StrUtil.isEmpty((CharSequence)key)) {
                    throw new RuntimeException("\u8131\u654f\u6570\u636e\u89e3\u5bc6\u5931\u8d25!key\u4e3a\u7a7a");
                }
                String decrypt = CryptUtil.decrypt(key);
                log.info("\u8131\u654f\u6570\u636e\u89e3\u5bc6\uff1a{}", (Object)decrypt);
                return decrypt;
            }
            return value;
        }
        throw new RuntimeException("\u8131\u654f\u5b57\u6bb5\u5bc6\u6587\u4e3a\u7a7a!");
    }

    private static ConfigProperties getConfigProperties() {
        return (ConfigProperties)ApplicationContextRegister.getApplicationContext().getBean(ConfigProperties.class);
    }

    private DecodeMaskDataHandle() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

