/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.aop;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.suke.zhjg.common.autofull.annotation.AutoFullData;
import com.suke.zhjg.common.autofull.handler.AutoFullHandler;
import com.suke.zhjg.common.autofull.sequence.AutoSequence;
import com.suke.zhjg.common.autofull.util.R;
import java.util.ArrayList;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class AutoFullAspect {
    private static final Logger log = LoggerFactory.getLogger(AutoFullAspect.class);
    private static final int DEFAULT_LEVEL = 1;
    private static final String DATA = "data";

    @Pointcut(value="@annotation(com.suke.zhjg.common.autofull.annotation.AutoFullData)")
    public void autoFullDataPointCut() {
    }

    @Around(value="@annotation(autoFullData)", argNames="point,autoFullData")
    public Object around(ProceedingJoinPoint point, AutoFullData autoFullData) throws Throwable {
        int maxLevel = autoFullData.maxLevel();
        String sequence = AutoSequence.init().put(maxLevel == 0 ? 1 : maxLevel);
        Object proceed = point.proceed();
        Class<?> cls = proceed.getClass();
        if (cls.equals(R.class)) {
            Object data;
            R result = (R)proceed;
            if (result != null && (data = result.get(DATA)) != null) {
                cls = data.getClass();
                data = this.fullData(cls, data, sequence, maxLevel);
                result.put(DATA, data);
                return result;
            }
        } else {
            return this.fullData(cls, proceed, sequence, maxLevel);
        }
        return proceed;
    }

    public Object fullData(Class<?> cls, Object data, String sequence, int maxLevel) {
        if (cls.equals(ArrayList.class)) {
            ArrayList listData = (ArrayList)data;
            if (maxLevel == 0) {
                AutoFullHandler.full(listData, sequence);
            } else {
                AutoFullHandler.full(listData, sequence, 1);
            }
        } else if (cls.equals(Page.class)) {
            IPage pageData = (IPage)data;
            if (maxLevel == 0) {
                AutoFullHandler.full(pageData, sequence);
            } else {
                AutoFullHandler.full(pageData, sequence, 1);
            }
        } else if (maxLevel == 0) {
            AutoFullHandler.full(data, sequence);
        } else {
            AutoFullHandler.full(data, sequence, 1);
        }
        AutoSequence.init().remove(sequence);
        return data;
    }
}

