/*
 * Decompiled with CFR 0.152.
 */
package com.yzq.zxinglibrary.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.os.Vibrator;
import android.util.Log;
import com.yzq.zxinglibrary.R;
import java.io.Closeable;
import java.io.IOException;

public final class BeepManager
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
Closeable {
    private static final String TAG = BeepManager.class.getSimpleName();
    private static final float BEEP_VOLUME = 0.1f;
    private static final long VIBRATE_DURATION = 200L;
    private final Activity activity;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private boolean vibrate;

    public BeepManager(Activity activity) {
        this.activity = activity;
        this.mediaPlayer = null;
        this.updatePrefs();
    }

    public void setPlayBeep(boolean playBeep) {
        this.playBeep = playBeep;
    }

    public void setVibrate(boolean vibrate) {
        this.vibrate = vibrate;
    }

    public synchronized void updatePrefs() {
        if (this.playBeep && this.mediaPlayer == null) {
            this.activity.setVolumeControlStream(3);
            this.mediaPlayer = this.buildMediaPlayer((Context)this.activity);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public synchronized void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            Vibrator vibrator = (Vibrator)this.activity.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaPlayer buildMediaPlayer(Context activity) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        mediaPlayer.setAudioStreamType(3);
        mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        try {
            try (AssetFileDescriptor file = activity.getResources().openRawResourceFd(R.raw.beep);){
                mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
            }
            mediaPlayer.setVolume(0.1f, 0.1f);
            mediaPlayer.prepare();
            return mediaPlayer;
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (Throwable)ioe);
            mediaPlayer.release();
            return null;
        }
    }

    public void onCompletion(MediaPlayer mp) {
        mp.seekTo(0);
    }

    public synchronized boolean onError(MediaPlayer mp, int what, int extra) {
        if (what == 100) {
            this.activity.finish();
        } else {
            mp.release();
            this.mediaPlayer = null;
            this.updatePrefs();
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }
}

