/*
 * Decompiled with CFR 0.152.
 */
package com.yzq.zxinglibrary.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.LinearLayoutCompat;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import android.widget.Toast;
import com.google.zxing.Result;
import com.yzq.zxinglibrary.R;
import com.yzq.zxinglibrary.android.BeepManager;
import com.yzq.zxinglibrary.android.CaptureActivityHandler;
import com.yzq.zxinglibrary.android.FinishListener;
import com.yzq.zxinglibrary.android.InactivityTimer;
import com.yzq.zxinglibrary.bean.ZxingConfig;
import com.yzq.zxinglibrary.camera.CameraManager;
import com.yzq.zxinglibrary.decode.DecodeImgCallback;
import com.yzq.zxinglibrary.decode.DecodeImgThread;
import com.yzq.zxinglibrary.decode.ImageUtil;
import com.yzq.zxinglibrary.view.ViewfinderView;
import java.io.IOException;

public class CaptureActivity
extends AppCompatActivity
implements SurfaceHolder.Callback,
View.OnClickListener {
    private static final String TAG = CaptureActivity.class.getSimpleName();
    private ZxingConfig config;
    private SurfaceView previewView;
    private ViewfinderView viewfinderView;
    private AppCompatImageView flashLightIv;
    private TextView flashLightTv;
    private AppCompatImageView backIv;
    private LinearLayoutCompat flashLightLayout;
    private LinearLayoutCompat albumLayout;
    private LinearLayoutCompat bottomLayout;
    private boolean hasSurface;
    private InactivityTimer inactivityTimer;
    private BeepManager beepManager;
    private CameraManager cameraManager;
    private CaptureActivityHandler handler;
    private SurfaceHolder surfaceHolder;

    public ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public CameraManager getCameraManager() {
        return this.cameraManager;
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        window.addFlags(128);
        if (Build.VERSION.SDK_INT >= 21) {
            window.setStatusBarColor(-16777216);
        }
        Log.i((String)"onCreate", (String)"setContentView");
        try {
            this.config = (ZxingConfig)this.getIntent().getExtras().get("zxingConfig");
        }
        catch (Exception e) {
            Log.i((String)"config", (String)e.toString());
        }
        if (this.config == null) {
            this.config = new ZxingConfig();
        }
        this.setContentView(R.layout.activity_capture);
        this.initView();
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer((Activity)this);
        this.beepManager = new BeepManager((Activity)this);
        this.beepManager.setPlayBeep(this.config.isPlayBeep());
        this.beepManager.setVibrate(this.config.isShake());
    }

    private void initView() {
        this.previewView = (SurfaceView)this.findViewById(R.id.preview_view);
        this.previewView.setOnClickListener((View.OnClickListener)this);
        this.viewfinderView = (ViewfinderView)this.findViewById(R.id.viewfinder_view);
        this.viewfinderView.setOnClickListener(this);
        this.backIv = (AppCompatImageView)this.findViewById(R.id.backIv);
        this.backIv.setOnClickListener((View.OnClickListener)this);
        this.flashLightIv = (AppCompatImageView)this.findViewById(R.id.flashLightIv);
        this.flashLightTv = (TextView)this.findViewById(R.id.flashLightTv);
        this.flashLightLayout = (LinearLayoutCompat)this.findViewById(R.id.flashLightLayout);
        this.flashLightLayout.setOnClickListener((View.OnClickListener)this);
        this.albumLayout = (LinearLayoutCompat)this.findViewById(R.id.albumLayout);
        this.albumLayout.setOnClickListener((View.OnClickListener)this);
        this.bottomLayout = (LinearLayoutCompat)this.findViewById(R.id.bottomLayout);
        this.switchVisibility((View)this.bottomLayout, this.config.isShowbottomLayout());
        this.switchVisibility((View)this.flashLightLayout, this.config.isShowFlashLight());
        this.switchVisibility((View)this.albumLayout, this.config.isShowAlbum());
        if (CaptureActivity.isSupportCameraLedFlash(this.getPackageManager())) {
            this.flashLightLayout.setVisibility(0);
        } else {
            this.flashLightLayout.setVisibility(8);
        }
    }

    public static boolean isSupportCameraLedFlash(PackageManager pm) {
        FeatureInfo[] features;
        if (pm != null && (features = pm.getSystemAvailableFeatures()) != null) {
            for (FeatureInfo f : features) {
                if (f == null || !"android.hardware.camera.flash".equals(f.name)) continue;
                return true;
            }
        }
        return false;
    }

    public void switchFlashImg(int flashState) {
        if (flashState == 8) {
            this.flashLightIv.setImageResource(R.drawable.ic_open);
            this.flashLightTv.setText((CharSequence)"\u5173\u95ed\u95ea\u5149\u706f");
        } else {
            this.flashLightIv.setImageResource(R.drawable.ic_close);
            this.flashLightTv.setText((CharSequence)"\u6253\u5f00\u95ea\u5149\u706f");
        }
    }

    public void handleDecode(Result rawResult) {
        this.inactivityTimer.onActivity();
        this.beepManager.playBeepSoundAndVibrate();
        Intent intent = this.getIntent();
        intent.putExtra("codedContent", rawResult.getText());
        this.setResult(-1, intent);
        this.finish();
    }

    private void switchVisibility(View view, boolean b) {
        if (b) {
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
    }

    protected void onResume() {
        super.onResume();
        this.cameraManager = new CameraManager((Context)this.getApplication());
        this.viewfinderView.setCameraManager(this.cameraManager);
        this.handler = null;
        this.surfaceHolder = this.previewView.getHolder();
        if (this.hasSurface) {
            this.initCamera(this.surfaceHolder);
        } else {
            this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
        this.beepManager.updatePrefs();
        this.inactivityTimer.onResume();
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalStateException("No SurfaceHolder provided");
        }
        if (this.cameraManager.isOpen()) {
            return;
        }
        try {
            this.cameraManager.openDriver(surfaceHolder);
            if (this.handler == null) {
                this.handler = new CaptureActivityHandler(this, this.cameraManager);
            }
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (Throwable)ioe);
            this.displayFrameworkBugMessageAndExit();
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Unexpected error initializing camera", (Throwable)e);
            this.displayFrameworkBugMessageAndExit();
        }
    }

    private void displayFrameworkBugMessageAndExit() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"\u626b\u4e00\u626b");
        builder.setMessage((CharSequence)this.getString(R.string.msg_camera_framework_bug));
        builder.setPositiveButton(R.string.button_ok, (DialogInterface.OnClickListener)new FinishListener((Activity)this));
        builder.setOnCancelListener((DialogInterface.OnCancelListener)new FinishListener((Activity)this));
        builder.show();
    }

    protected void onPause() {
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        this.inactivityTimer.onPause();
        this.beepManager.close();
        this.cameraManager.closeDriver();
        if (!this.hasSurface) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        super.onPause();
    }

    protected void onDestroy() {
        this.inactivityTimer.shutdown();
        super.onDestroy();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.flashLightLayout) {
            this.cameraManager.switchFlashLight(this.handler);
        } else if (id2 == R.id.albumLayout) {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.PICK");
            intent.setType("image/*");
            this.startActivityForResult(intent, 10);
        } else if (id2 == R.id.backIv) {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 10 && resultCode == -1) {
            String path = ImageUtil.getImageAbsolutePath((Context)this, data.getData());
            new DecodeImgThread(path, new DecodeImgCallback(){

                @Override
                public void onImageDecodeSuccess(Result result) {
                    CaptureActivity.this.handleDecode(result);
                }

                @Override
                public void onImageDecodeFailed() {
                    Toast.makeText((Context)CaptureActivity.this, (CharSequence)"\u62b1\u6b49\uff0c\u89e3\u6790\u5931\u8d25,\u6362\u4e2a\u56fe\u7247\u8bd5\u8bd5.", (int)0).show();
                }
            }).run();
        }
    }

    static {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
    }
}

