/*
 * Decompiled with CFR 0.152.
 */
package com.yzq.zxinglibrary.encode;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.text.TextUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.Hashtable;

public class CodeCreator {
    private static Bitmap logoBitmap;

    public static Bitmap createQRCode(String content, int w, int h, Bitmap logo) throws WriterException {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        int offsetX = w / 2;
        int offsetY = h / 2;
        if (logo != null) {
            Matrix matrix = new Matrix();
            float scaleFactor = Math.min((float)w * 1.0f / 5.0f / (float)logo.getWidth(), (float)h * 1.0f / 5.0f / (float)logo.getHeight());
            matrix.postScale(scaleFactor, scaleFactor);
            logoBitmap = Bitmap.createBitmap((Bitmap)logo, (int)0, (int)0, (int)logo.getWidth(), (int)logo.getHeight(), (Matrix)matrix, (boolean)true);
        }
        int logoW = 0;
        int logoH = 0;
        if (logoBitmap != null) {
            logoW = logoBitmap.getWidth();
            logoH = logoBitmap.getHeight();
            offsetX = (w - logoW) / 2;
            offsetY = (h - logoH) / 2;
        }
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.MARGIN, 0);
        BitMatrix matrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, w, h, hints);
        int[] pixels = new int[w * h];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (x >= offsetX && x < offsetX + logoW && y >= offsetY && y < offsetY + logoH) {
                    int pixel = logoBitmap.getPixel(x - offsetX, y - offsetY);
                    if (pixel == 0) {
                        pixel = matrix.get(x, y) ? -16777216 : -1;
                    }
                    pixels[y * w + x] = pixel;
                    continue;
                }
                pixels[y * w + x] = matrix.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, w, 0, 0, w, h);
        return bitmap;
    }
}

