/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

final class MultiFinderPatternFinder
extends FinderPatternFinder {
    private static final FinderPatternInfo[] EMPTY_RESULT_ARRAY = new FinderPatternInfo[0];
    private static final float MAX_MODULE_COUNT_PER_EDGE = 180.0f;
    private static final float MIN_MODULE_COUNT_PER_EDGE = 9.0f;
    private static final float DIFF_MODSIZE_CUTOFF_PERCENT = 0.05f;
    private static final float DIFF_MODSIZE_CUTOFF = 0.5f;

    MultiFinderPatternFinder(BitMatrix image) {
        super(image);
    }

    MultiFinderPatternFinder(BitMatrix image, ResultPointCallback resultPointCallback) {
        super(image, resultPointCallback);
    }

    private FinderPattern[][] selectMutipleBestPatterns() throws NotFoundException {
        List<FinderPattern> possibleCenters = this.getPossibleCenters();
        int size = possibleCenters.size();
        if (size < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (size == 3) {
            return new FinderPattern[][]{{possibleCenters.get(0), possibleCenters.get(1), possibleCenters.get(2)}};
        }
        Collections.sort(possibleCenters, new ModuleSizeComparator());
        ArrayList<ResultPoint[]> results = new ArrayList<ResultPoint[]>();
        block0: for (int i1 = 0; i1 < size - 2; ++i1) {
            FinderPattern p1 = possibleCenters.get(i1);
            if (p1 == null) continue;
            block1: for (int i2 = i1 + 1; i2 < size - 1; ++i2) {
                FinderPattern p2 = possibleCenters.get(i2);
                if (p2 == null) continue;
                float vModSize12 = (p1.getEstimatedModuleSize() - p2.getEstimatedModuleSize()) / Math.min(p1.getEstimatedModuleSize(), p2.getEstimatedModuleSize());
                if (Math.abs(p1.getEstimatedModuleSize() - p2.getEstimatedModuleSize()) > 0.5f && vModSize12 >= 0.05f) continue block0;
                for (int i3 = i2 + 1; i3 < size; ++i3) {
                    float dCpy;
                    FinderPattern p3 = possibleCenters.get(i3);
                    if (p3 == null) continue;
                    float vModSize23 = (p2.getEstimatedModuleSize() - p3.getEstimatedModuleSize()) / Math.min(p2.getEstimatedModuleSize(), p3.getEstimatedModuleSize());
                    if (Math.abs(p2.getEstimatedModuleSize() - p3.getEstimatedModuleSize()) > 0.5f && vModSize23 >= 0.05f) continue block1;
                    ResultPoint[] test = new FinderPattern[]{p1, p2, p3};
                    ResultPoint.orderBestPatterns(test);
                    FinderPatternInfo info = new FinderPatternInfo((FinderPattern[])test);
                    float dA = ResultPoint.distance(info.getTopLeft(), info.getBottomLeft());
                    float dC = ResultPoint.distance(info.getTopRight(), info.getBottomLeft());
                    float dB = ResultPoint.distance(info.getTopLeft(), info.getTopRight());
                    float estimatedModuleCount = (dA + dB) / (p1.getEstimatedModuleSize() * 2.0f);
                    if (estimatedModuleCount > 180.0f || estimatedModuleCount < 9.0f || Math.abs((dA - dB) / Math.min(dA, dB)) >= 0.1f || Math.abs((dC - (dCpy = (float)Math.sqrt(dA * dA + dB * dB))) / Math.min(dC, dCpy)) >= 0.1f) continue;
                    results.add(test);
                }
            }
        }
        if (!results.isEmpty()) {
            return (FinderPattern[][])results.toArray((T[])new FinderPattern[results.size()][]);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public FinderPatternInfo[] findMulti(Map<DecodeHintType, ?> hints) throws NotFoundException {
        boolean tryHarder = hints != null && hints.containsKey((Object)DecodeHintType.TRY_HARDER);
        boolean pureBarcode = hints != null && hints.containsKey((Object)DecodeHintType.PURE_BARCODE);
        BitMatrix image = this.getImage();
        int maxI = image.getHeight();
        int maxJ = image.getWidth();
        int iSkip = (int)((float)maxI / 228.0f * 3.0f);
        if (iSkip < 3 || tryHarder) {
            iSkip = 3;
        }
        int[] stateCount = new int[5];
        for (int i = iSkip - 1; i < maxI; i += iSkip) {
            stateCount[0] = 0;
            stateCount[1] = 0;
            stateCount[2] = 0;
            stateCount[3] = 0;
            stateCount[4] = 0;
            int currentState = 0;
            for (int j = 0; j < maxJ; ++j) {
                if (image.get(j, i)) {
                    if (currentState & true) {
                        // empty if block
                    }
                    int n = ++currentState;
                    stateCount[n] = stateCount[n] + 1;
                    continue;
                }
                if (!(currentState & true)) {
                    if (currentState == 4) {
                        if (MultiFinderPatternFinder.foundPatternCross(stateCount) && this.handlePossibleCenter(stateCount, i, j, pureBarcode)) {
                            currentState = 0;
                            stateCount[0] = 0;
                            stateCount[1] = 0;
                            stateCount[2] = 0;
                            stateCount[3] = 0;
                            stateCount[4] = 0;
                            continue;
                        }
                        stateCount[0] = stateCount[2];
                        stateCount[1] = stateCount[3];
                        stateCount[2] = stateCount[4];
                        stateCount[3] = 1;
                        stateCount[4] = 0;
                        currentState = 3;
                        continue;
                    }
                    int n = ++currentState;
                    stateCount[n] = stateCount[n] + 1;
                    continue;
                }
                int n = currentState;
                stateCount[n] = stateCount[n] + 1;
            }
            if (!MultiFinderPatternFinder.foundPatternCross(stateCount)) continue;
            this.handlePossibleCenter(stateCount, i, maxJ, pureBarcode);
        }
        FinderPattern[][] patternInfo = this.selectMutipleBestPatterns();
        ArrayList<FinderPatternInfo> result = new ArrayList<FinderPatternInfo>();
        FinderPattern[][] finderPatternArray = patternInfo;
        int n = patternInfo.length;
        for (int i = 0; i < n; ++i) {
            ResultPoint[] pattern = finderPatternArray[i];
            ResultPoint.orderBestPatterns(pattern);
            result.add(new FinderPatternInfo((FinderPattern[])pattern));
        }
        if (result.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        return result.toArray(new FinderPatternInfo[result.size()]);
    }

    private static final class ModuleSizeComparator
    implements Serializable,
    Comparator<FinderPattern> {
        private ModuleSizeComparator() {
        }

        @Override
        public int compare(FinderPattern center1, FinderPattern center2) {
            float f;
            float value = center2.getEstimatedModuleSize() - center1.getEstimatedModuleSize();
            if ((double)f < 0.0) {
                return -1;
            }
            if ((double)value > 0.0) {
                return 1;
            }
            return 0;
        }
    }
}

