/*
 * Decompiled with CFR 0.152.
 */
package com.yzq.zxinglibrary.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.widget.ImageButton;
import android.widget.Toast;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.Result;
import com.yzq.zxinglibrary.R;
import com.yzq.zxinglibrary.android.BeepManager;
import com.yzq.zxinglibrary.android.CaptureActivityHandler;
import com.yzq.zxinglibrary.android.FinishListener;
import com.yzq.zxinglibrary.android.InactivityTimer;
import com.yzq.zxinglibrary.android.IntentSource;
import com.yzq.zxinglibrary.camera.CameraManager;
import com.yzq.zxinglibrary.view.ViewfinderView;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public final class CaptureActivity
extends Activity
implements SurfaceHolder.Callback {
    private static final String TAG = CaptureActivity.class.getSimpleName();
    private CameraManager cameraManager;
    private CaptureActivityHandler handler;
    private ViewfinderView viewfinderView;
    private boolean hasSurface;
    private IntentSource source;
    private Collection<BarcodeFormat> decodeFormats;
    private Map<DecodeHintType, ?> decodeHints;
    private String characterSet;
    private InactivityTimer inactivityTimer;
    private BeepManager beepManager;
    private ImageButton imageButton_back;

    public ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public CameraManager getCameraManager() {
        return this.cameraManager;
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        Window window = this.getWindow();
        window.addFlags(128);
        this.setContentView(R.layout.capture);
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer(this);
        this.beepManager = new BeepManager(this);
        this.imageButton_back = (ImageButton)this.findViewById(R.id.capture_imageview_back);
        this.imageButton_back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CaptureActivity.this.finish();
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.cameraManager = new CameraManager((Context)this.getApplication());
        this.viewfinderView = (ViewfinderView)this.findViewById(R.id.viewfinder_view);
        this.viewfinderView.setCameraManager(this.cameraManager);
        this.handler = null;
        SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
        this.beepManager.updatePrefs();
        this.inactivityTimer.onResume();
        this.source = IntentSource.NONE;
        this.decodeFormats = null;
        this.characterSet = null;
    }

    protected void onPause() {
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        this.inactivityTimer.onPause();
        this.beepManager.close();
        this.cameraManager.closeDriver();
        if (!this.hasSurface) {
            SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
            SurfaceHolder surfaceHolder = surfaceView.getHolder();
            surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        super.onPause();
    }

    protected void onDestroy() {
        this.inactivityTimer.shutdown();
        super.onDestroy();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void handleDecode(Result rawResult, Bitmap barcode, float scaleFactor) {
        boolean fromLiveScan;
        this.inactivityTimer.onActivity();
        boolean bl = fromLiveScan = barcode != null;
        if (fromLiveScan) {
            this.beepManager.playBeepSoundAndVibrate();
            Toast.makeText((Context)this, (CharSequence)"\u626b\u63cf\u6210\u529f", (int)0).show();
            Intent intent = this.getIntent();
            intent.putExtra("codedContent", rawResult.getText());
            intent.putExtra("codedBitmap", (Parcelable)barcode);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalStateException("No SurfaceHolder provided");
        }
        if (this.cameraManager.isOpen()) {
            return;
        }
        try {
            this.cameraManager.openDriver(surfaceHolder);
            if (this.handler == null) {
                this.handler = new CaptureActivityHandler(this, this.decodeFormats, this.decodeHints, this.characterSet, this.cameraManager);
            }
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (Throwable)ioe);
            this.displayFrameworkBugMessageAndExit();
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Unexpected error initializing camera", (Throwable)e);
            this.displayFrameworkBugMessageAndExit();
        }
    }

    private void displayFrameworkBugMessageAndExit() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"\u626b\u4e00\u626b");
        builder.setMessage((CharSequence)this.getString(R.string.msg_camera_framework_bug));
        builder.setPositiveButton(R.string.button_ok, (DialogInterface.OnClickListener)new FinishListener(this));
        builder.setOnCancelListener((DialogInterface.OnCancelListener)new FinishListener(this));
        builder.show();
    }
}

