/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.StyleRes;
import com.budiyev.android.codescanner.ButtonPosition;
import com.budiyev.android.codescanner.CodeScanner;
import com.budiyev.android.codescanner.Point;
import com.budiyev.android.codescanner.R;
import com.budiyev.android.codescanner.Rect;
import com.budiyev.android.codescanner.Utils;
import com.budiyev.android.codescanner.ViewFinderView;
import java.util.Objects;

public final class CodeScannerView
extends ViewGroup {
    private static final boolean DEFAULT_AUTO_FOCUS_BUTTON_VISIBLE = true;
    private static final boolean DEFAULT_FLASH_BUTTON_VISIBLE = true;
    private static final boolean DEFAULT_MASK_VISIBLE = true;
    private static final boolean DEFAULT_FRAME_VISIBLE = true;
    private static final int DEFAULT_MASK_COLOR = 0x77000000;
    private static final int DEFAULT_FRAME_COLOR = -1;
    private static final int DEFAULT_AUTO_FOCUS_BUTTON_COLOR = -1;
    private static final int DEFAULT_FLASH_BUTTON_COLOR = -1;
    private static final int HINT_VIEW_INDEX = 4;
    private static final int MAX_CHILD_COUNT = 5;
    private static final float DEFAULT_FRAME_THICKNESS_DP = 2.0f;
    private static final float DEFAULT_FRAME_ASPECT_RATIO_WIDTH = 1.0f;
    private static final float DEFAULT_FRAME_ASPECT_RATIO_HEIGHT = 1.0f;
    private static final float DEFAULT_FRAME_CORNER_SIZE_DP = 50.0f;
    private static final float DEFAULT_FRAME_CORNERS_RADIUS_DP = 0.0f;
    private static final float DEFAULT_FRAME_SIZE = 0.75f;
    private static final float DEFAULT_FRAME_VERTICAL_BIAS = 0.5f;
    private static final float DEFAULT_BUTTON_PADDING_DP = 16.0f;
    private static final float FOCUS_AREA_SIZE_DP = 20.0f;
    private static final ButtonPosition DEFAULT_AUTO_FOCUS_BUTTON_POSITION = ButtonPosition.TOP_START;
    private static final ButtonPosition DEFAULT_FLASH_BUTTON_POSITION = ButtonPosition.TOP_END;
    private SurfaceView mPreviewView;
    private ViewFinderView mViewFinderView;
    private ImageView mAutoFocusButton;
    private ButtonPosition mAutoFocusButtonPosition;
    private int mAutoFocusButtonPaddingHorizontal;
    private int mAutoFocusButtonPaddingVertical;
    private int mAutoFocusButtonColor;
    private Drawable mAutoFocusButtonOnIcon;
    private Drawable mAutoFocusButtonOffIcon;
    private ImageView mFlashButton;
    private ButtonPosition mFlashButtonPosition;
    private int mFlashButtonPaddingHorizontal;
    private int mFlashButtonPaddingVertical;
    private int mFlashButtonColor;
    private Drawable mFlashButtonOnIcon;
    private Drawable mFlashButtonOffIcon;
    private Point mPreviewSize;
    private SizeListener mSizeListener;
    private CodeScanner mCodeScanner;
    private int mFocusAreaSize;

    public CodeScannerView(@NonNull Context context) {
        super(context);
        this.initialize(context, null, 0, 0);
    }

    public CodeScannerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0, 0);
    }

    public CodeScannerView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr, 0);
    }

    @RequiresApi(value=21)
    public CodeScannerView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.mPreviewView = new SurfaceView(context);
        this.mViewFinderView = new ViewFinderView(context);
        float density = context.getResources().getDisplayMetrics().density;
        int defaultButtonPadding = Math.round(density * 16.0f);
        this.mFocusAreaSize = Math.round(density * 20.0f);
        this.mAutoFocusButton = new ImageView(context);
        this.mAutoFocusButton.setScaleType(ImageView.ScaleType.CENTER);
        this.mAutoFocusButton.setOnClickListener((View.OnClickListener)new AutoFocusClickListener());
        this.mFlashButton = new ImageView(context);
        this.mFlashButton.setScaleType(ImageView.ScaleType.CENTER);
        this.mFlashButton.setOnClickListener((View.OnClickListener)new FlashClickListener());
        if (attrs == null) {
            this.setFrameAspectRatio(1.0f, 1.0f);
            this.setMaskColor(0x77000000);
            this.setMaskVisible(true);
            this.setFrameColor(-1);
            this.setFrameVisible(true);
            this.setFrameThickness(Math.round(2.0f * density));
            this.setFrameCornersSize(Math.round(50.0f * density));
            this.setFrameCornersRadius(Math.round(0.0f * density));
            this.setFrameSize(0.75f);
            this.setFrameVerticalBias(0.5f);
            this.setAutoFocusButtonColor(-1);
            this.setFlashButtonColor(-1);
            this.setAutoFocusButtonVisible(true);
            this.setAutoFocusButtonPosition(DEFAULT_AUTO_FOCUS_BUTTON_POSITION);
            this.setFlashButtonVisible(true);
            this.setFlashButtonPosition(DEFAULT_FLASH_BUTTON_POSITION);
            this.setAutoFocusButtonPaddingHorizontal(defaultButtonPadding);
            this.setAutoFocusButtonPaddingVertical(defaultButtonPadding);
            this.setFlashButtonPaddingHorizontal(defaultButtonPadding);
            this.setFlashButtonPaddingVertical(defaultButtonPadding);
            this.setAutoFocusButtonOnIcon(Utils.getDrawable(context, R.drawable.ic_code_scanner_auto_focus_on));
            this.setAutoFocusButtonOffIcon(Utils.getDrawable(context, R.drawable.ic_code_scanner_auto_focus_off));
            this.setFlashButtonOnIcon(Utils.getDrawable(context, R.drawable.ic_code_scanner_flash_on));
            this.setFlashButtonOffIcon(Utils.getDrawable(context, R.drawable.ic_code_scanner_flash_off));
        } else {
            TypedArray a = null;
            try {
                a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CodeScannerView, defStyleAttr, defStyleRes);
                this.setMaskColor(a.getColor(R.styleable.CodeScannerView_maskColor, 0x77000000));
                this.setMaskVisible(a.getBoolean(R.styleable.CodeScannerView_maskVisible, true));
                this.setFrameColor(a.getColor(R.styleable.CodeScannerView_frameColor, -1));
                this.setFrameVisible(a.getBoolean(R.styleable.CodeScannerView_frameVisible, true));
                this.setFrameThickness(a.getDimensionPixelOffset(R.styleable.CodeScannerView_frameThickness, Math.round(2.0f * density)));
                this.setFrameCornersSize(a.getDimensionPixelOffset(R.styleable.CodeScannerView_frameCornersSize, Math.round(50.0f * density)));
                this.setFrameCornersRadius(a.getDimensionPixelOffset(R.styleable.CodeScannerView_frameCornersRadius, Math.round(0.0f * density)));
                this.setFrameAspectRatio(a.getFloat(R.styleable.CodeScannerView_frameAspectRatioWidth, 1.0f), a.getFloat(R.styleable.CodeScannerView_frameAspectRatioHeight, 1.0f));
                this.setFrameSize(a.getFloat(R.styleable.CodeScannerView_frameSize, 0.75f));
                this.setFrameVerticalBias(a.getFloat(R.styleable.CodeScannerView_frameVerticalBias, 0.5f));
                this.setAutoFocusButtonVisible(a.getBoolean(R.styleable.CodeScannerView_autoFocusButtonVisible, true));
                this.setAutoFocusButtonColor(a.getColor(R.styleable.CodeScannerView_autoFocusButtonColor, -1));
                this.setAutoFocusButtonPosition(CodeScannerView.buttonPositionFromAttr(a.getInt(R.styleable.CodeScannerView_autoFocusButtonPosition, CodeScannerView.indexOfButtonPosition(DEFAULT_AUTO_FOCUS_BUTTON_POSITION))));
                this.setAutoFocusButtonPaddingHorizontal(a.getDimensionPixelOffset(R.styleable.CodeScannerView_autoFocusButtonPaddingHorizontal, defaultButtonPadding));
                this.setAutoFocusButtonPaddingVertical(a.getDimensionPixelOffset(R.styleable.CodeScannerView_autoFocusButtonPaddingVertical, defaultButtonPadding));
                Drawable autoFocusButtonOnIcon = a.getDrawable(R.styleable.CodeScannerView_autoFocusButtonOnIcon);
                this.setAutoFocusButtonOnIcon(autoFocusButtonOnIcon != null ? autoFocusButtonOnIcon : Utils.getDrawable(context, R.drawable.ic_code_scanner_auto_focus_on));
                Drawable autoFocusButtonOffIcon = a.getDrawable(R.styleable.CodeScannerView_autoFocusButtonOffIcon);
                this.setAutoFocusButtonOffIcon(autoFocusButtonOffIcon != null ? autoFocusButtonOffIcon : Utils.getDrawable(context, R.drawable.ic_code_scanner_auto_focus_off));
                this.setFlashButtonVisible(a.getBoolean(R.styleable.CodeScannerView_flashButtonVisible, true));
                this.setFlashButtonColor(a.getColor(R.styleable.CodeScannerView_flashButtonColor, -1));
                this.setFlashButtonPosition(CodeScannerView.buttonPositionFromAttr(a.getInt(R.styleable.CodeScannerView_flashButtonPosition, CodeScannerView.indexOfButtonPosition(DEFAULT_FLASH_BUTTON_POSITION))));
                this.setFlashButtonPaddingHorizontal(a.getDimensionPixelOffset(R.styleable.CodeScannerView_flashButtonPaddingHorizontal, defaultButtonPadding));
                this.setFlashButtonPaddingVertical(a.getDimensionPixelOffset(R.styleable.CodeScannerView_flashButtonPaddingVertical, defaultButtonPadding));
                Drawable flashButtonOnIcon = a.getDrawable(R.styleable.CodeScannerView_flashButtonOnIcon);
                this.setFlashButtonOnIcon(flashButtonOnIcon != null ? flashButtonOnIcon : Utils.getDrawable(context, R.drawable.ic_code_scanner_flash_on));
                Drawable flashButtonOffIcon = a.getDrawable(R.styleable.CodeScannerView_flashButtonOffIcon);
                this.setFlashButtonOffIcon(flashButtonOffIcon != null ? flashButtonOffIcon : Utils.getDrawable(context, R.drawable.ic_code_scanner_flash_off));
            }
            finally {
                if (a != null) {
                    a.recycle();
                }
            }
        }
        if (this.isInEditMode()) {
            this.setAutoFocusEnabled(true);
            this.setFlashEnabled(true);
        }
        this.addView((View)this.mPreviewView, (ViewGroup.LayoutParams)new LayoutParams(-1, -1));
        this.addView(this.mViewFinderView, (ViewGroup.LayoutParams)new LayoutParams(-1, -1));
        this.addView((View)this.mAutoFocusButton, (ViewGroup.LayoutParams)new LayoutParams(-2, -2));
        this.addView((View)this.mFlashButton, (ViewGroup.LayoutParams)new LayoutParams(-2, -2));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childCount = this.getChildCount();
        if (childCount > 5) {
            throw new IllegalStateException("CodeScannerView can have zero or one child");
        }
        this.measureChildWithMargins((View)this.mPreviewView, widthMeasureSpec, 0, heightMeasureSpec, 0);
        this.measureChildWithMargins(this.mViewFinderView, widthMeasureSpec, 0, heightMeasureSpec, 0);
        this.measureChildWithMargins((View)this.mAutoFocusButton, widthMeasureSpec, 0, heightMeasureSpec, 0);
        this.measureChildWithMargins((View)this.mFlashButton, widthMeasureSpec, 0, heightMeasureSpec, 0);
        if (childCount == 5) {
            Rect frameRect = this.mViewFinderView.getFrameRect();
            this.measureChildWithMargins(this.getChildAt(4), widthMeasureSpec, 0, heightMeasureSpec, frameRect != null ? frameRect.getBottom() : 0);
        }
        this.setMeasuredDimension(CodeScannerView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), CodeScannerView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int childCount = this.getChildCount();
        if (childCount > 5) {
            throw new IllegalStateException("CodeScannerView can have zero or one child");
        }
        int width = right - left;
        int height = bottom - top;
        Point previewSize = this.mPreviewSize;
        if (previewSize == null) {
            this.mPreviewView.layout(0, 0, width, height);
        } else {
            int previewHeight;
            int frameLeft = 0;
            int frameTop = 0;
            int frameRight = width;
            int frameBottom = height;
            int previewWidth = previewSize.getX();
            if (previewWidth > width) {
                int d = (previewWidth - width) / 2;
                frameLeft -= d;
                frameRight += d;
            }
            if ((previewHeight = previewSize.getY()) > height) {
                int d = (previewHeight - height) / 2;
                frameTop -= d;
                frameBottom += d;
            }
            this.mPreviewView.layout(frameLeft, frameTop, frameRight, frameBottom);
        }
        this.mViewFinderView.layout(0, 0, width, height);
        this.layoutButton((View)this.mAutoFocusButton, this.mAutoFocusButtonPosition, width, height);
        this.layoutButton((View)this.mFlashButton, this.mFlashButtonPosition, width, height);
        if (childCount == 5) {
            Rect frameRect = this.mViewFinderView.getFrameRect();
            int viewTop = frameRect != null ? frameRect.getBottom() : 0;
            View hintView = this.getChildAt(4);
            int paddingLeft = this.getPaddingLeft();
            int paddingTop = this.getPaddingTop();
            if (hintView.getVisibility() != 8) {
                LayoutParams lp = (LayoutParams)hintView.getLayoutParams();
                int childLeft = paddingLeft + lp.leftMargin;
                int childTop = paddingTop + lp.topMargin + viewTop;
                hintView.layout(childLeft, childTop, childLeft + hintView.getMeasuredWidth(), childTop + hintView.getMeasuredHeight());
            }
        }
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        SizeListener listener = this.mSizeListener;
        if (listener != null) {
            listener.onSizeChanged(width, height);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        CodeScanner codeScanner = this.mCodeScanner;
        Rect frameRect = this.getFrameRect();
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (codeScanner != null && frameRect != null && codeScanner.isAutoFocusSupportedOrUnknown() && codeScanner.isTouchFocusEnabled() && event.getAction() == 0 && frameRect.isPointInside(x, y)) {
            int areaSize = this.mFocusAreaSize;
            codeScanner.performTouchFocus(new Rect(x - areaSize, y - areaSize, x + areaSize, y + areaSize).fitIn(frameRect));
        }
        return super.onTouchEvent(event);
    }

    protected boolean checkLayoutParams(@Nullable ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    @NonNull
    public ViewGroup.LayoutParams generateLayoutParams(@Nullable AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @NonNull
    protected ViewGroup.LayoutParams generateLayoutParams(@NonNull ViewGroup.LayoutParams p) {
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    @NonNull
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @ColorInt
    public int getMaskColor() {
        return this.mViewFinderView.getMaskColor();
    }

    public void setMaskColor(@ColorInt int color) {
        this.mViewFinderView.setMaskColor(color);
    }

    public boolean isMaskVisible() {
        return this.mViewFinderView.isMaskVisible();
    }

    public void setMaskVisible(boolean visible) {
        this.mViewFinderView.setMaskVisible(visible);
    }

    @ColorInt
    public int getFrameColor() {
        return this.mViewFinderView.getFrameColor();
    }

    public void setFrameColor(@ColorInt int color) {
        this.mViewFinderView.setFrameColor(color);
    }

    public boolean isFrameVisible() {
        return this.mViewFinderView.isFrameVisible();
    }

    public void setFrameVisible(boolean visible) {
        this.mViewFinderView.setFrameVisible(visible);
    }

    @Px
    public int getFrameThickness() {
        return this.mViewFinderView.getFrameThickness();
    }

    public void setFrameThickness(@Px int thickness) {
        if (thickness < 0) {
            throw new IllegalArgumentException("Frame thickness can't be negative");
        }
        this.mViewFinderView.setFrameThickness(thickness);
    }

    @Px
    public int getFrameCornersSize() {
        return this.mViewFinderView.getFrameCornersSize();
    }

    public void setFrameCornersSize(@Px int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Frame corners size can't be negative");
        }
        this.mViewFinderView.setFrameCornersSize(size);
    }

    @Px
    public int getFrameCornersRadius() {
        return this.mViewFinderView.getFrameCornersRadius();
    }

    public void setFrameCornersRadius(@Px int radius) {
        if (radius < 0) {
            throw new IllegalArgumentException("Frame corners radius can't be negative");
        }
        this.mViewFinderView.setFrameCornersRadius(radius);
    }

    @FloatRange(from=0.1, to=1.0)
    public float getFrameSize() {
        return this.mViewFinderView.getFrameSize();
    }

    public void setFrameSize(@FloatRange(from=0.1, to=1.0) float size) {
        if ((double)size < 0.1 || size > 1.0f) {
            throw new IllegalArgumentException("Max frame size value should be between 0.1 and 1, inclusive");
        }
        this.mViewFinderView.setFrameSize(size);
    }

    @FloatRange(from=0.0, to=1.0)
    public float getFrameVerticalBias() {
        return this.mViewFinderView.getFrameVerticalBias();
    }

    public void setFrameVerticalBias(@FloatRange(from=0.0, to=1.0) float bias) {
        if (bias < 0.0f || bias > 1.0f) {
            throw new IllegalArgumentException("Max frame size value should be between 0 and 1, inclusive");
        }
        this.mViewFinderView.setFrameVerticalBias(bias);
    }

    @FloatRange(from=0.0, fromInclusive=false)
    public float getFrameAspectRatioWidth() {
        return this.mViewFinderView.getFrameAspectRatioWidth();
    }

    public void setFrameAspectRatioWidth(@FloatRange(from=0.0, fromInclusive=false) float ratioWidth) {
        if (ratioWidth <= 0.0f) {
            throw new IllegalArgumentException("Frame aspect ratio values should be greater than zero");
        }
        this.mViewFinderView.setFrameAspectRatioWidth(ratioWidth);
    }

    @FloatRange(from=0.0, fromInclusive=false)
    public float getFrameAspectRatioHeight() {
        return this.mViewFinderView.getFrameAspectRatioHeight();
    }

    public void setFrameAspectRatioHeight(@FloatRange(from=0.0, fromInclusive=false) float ratioHeight) {
        if (ratioHeight <= 0.0f) {
            throw new IllegalArgumentException("Frame aspect ratio values should be greater than zero");
        }
        this.mViewFinderView.setFrameAspectRatioHeight(ratioHeight);
    }

    public void setFrameAspectRatio(@FloatRange(from=0.0, fromInclusive=false) float ratioWidth, @FloatRange(from=0.0, fromInclusive=false) float ratioHeight) {
        if (ratioWidth <= 0.0f || ratioHeight <= 0.0f) {
            throw new IllegalArgumentException("Frame aspect ratio values should be greater than zero");
        }
        this.mViewFinderView.setFrameAspectRatio(ratioWidth, ratioHeight);
    }

    public boolean isAutoFocusButtonVisible() {
        return this.mAutoFocusButton.getVisibility() == 0;
    }

    public void setAutoFocusButtonVisible(boolean visible) {
        this.mAutoFocusButton.setVisibility(visible ? 0 : 4);
    }

    @ColorInt
    public int getAutoFocusButtonColor() {
        return this.mAutoFocusButtonColor;
    }

    public void setAutoFocusButtonColor(@ColorInt int color) {
        this.mAutoFocusButtonColor = color;
        this.mAutoFocusButton.setColorFilter(color);
    }

    @NonNull
    public ButtonPosition getAutoFocusButtonPosition() {
        return this.mAutoFocusButtonPosition;
    }

    public void setAutoFocusButtonPosition(@NonNull ButtonPosition position) {
        Objects.requireNonNull(position);
        boolean changed = position != this.mAutoFocusButtonPosition;
        this.mAutoFocusButtonPosition = position;
        if (changed && this.isLaidOut()) {
            this.requestLayout();
        }
    }

    @Px
    public int getAutoFocusButtonPaddingHorizontal() {
        return this.mAutoFocusButtonPaddingHorizontal;
    }

    public void setAutoFocusButtonPaddingHorizontal(@Px int padding) {
        if (padding < 0) {
            throw new IllegalArgumentException("Padding should be equal to or grater then zero");
        }
        boolean changed = padding != this.mAutoFocusButtonPaddingHorizontal;
        this.mAutoFocusButtonPaddingHorizontal = padding;
        if (changed) {
            this.invalidateAutoFocusButtonPadding();
        }
    }

    @Px
    public int getAutoFocusButtonPaddingVertical() {
        return this.mAutoFocusButtonPaddingVertical;
    }

    public void setAutoFocusButtonPaddingVertical(@Px int padding) {
        if (padding < 0) {
            throw new IllegalArgumentException("Padding should be equal to or grater then zero");
        }
        boolean changed = padding != this.mAutoFocusButtonPaddingVertical;
        this.mAutoFocusButtonPaddingVertical = padding;
        if (changed) {
            this.invalidateAutoFocusButtonPadding();
        }
    }

    public boolean isFlashButtonVisible() {
        return this.mFlashButton.getVisibility() == 0;
    }

    @NonNull
    public Drawable getAutoFocusButtonOnIcon() {
        return this.mAutoFocusButtonOnIcon;
    }

    public void setAutoFocusButtonOnIcon(@NonNull Drawable icon) {
        Objects.requireNonNull(icon);
        boolean changed = icon != this.mAutoFocusButtonOnIcon;
        this.mAutoFocusButtonOnIcon = icon;
        CodeScanner codeScanner = this.mCodeScanner;
        if (changed && codeScanner != null) {
            this.setAutoFocusEnabled(codeScanner.isAutoFocusEnabled());
        }
    }

    @NonNull
    public Drawable getAutoFocusButtonOffIcon() {
        return this.mAutoFocusButtonOffIcon;
    }

    public void setAutoFocusButtonOffIcon(@NonNull Drawable icon) {
        Objects.requireNonNull(icon);
        boolean changed = icon != this.mAutoFocusButtonOffIcon;
        this.mAutoFocusButtonOffIcon = icon;
        CodeScanner codeScanner = this.mCodeScanner;
        if (changed && codeScanner != null) {
            this.setAutoFocusEnabled(codeScanner.isAutoFocusEnabled());
        }
    }

    public void setFlashButtonVisible(boolean visible) {
        this.mFlashButton.setVisibility(visible ? 0 : 4);
    }

    @ColorInt
    public int getFlashButtonColor() {
        return this.mFlashButtonColor;
    }

    public void setFlashButtonColor(@ColorInt int color) {
        this.mFlashButtonColor = color;
        this.mFlashButton.setColorFilter(color);
    }

    @NonNull
    public ButtonPosition getFlashButtonPosition() {
        return this.mFlashButtonPosition;
    }

    public void setFlashButtonPosition(@NonNull ButtonPosition position) {
        Objects.requireNonNull(position);
        boolean changed = position != this.mFlashButtonPosition;
        this.mFlashButtonPosition = position;
        if (changed) {
            this.requestLayout();
        }
    }

    @Px
    public int getFlashButtonPaddingHorizontal() {
        return this.mFlashButtonPaddingHorizontal;
    }

    public void setFlashButtonPaddingHorizontal(@Px int padding) {
        if (padding < 0) {
            throw new IllegalArgumentException("Padding should be equal to or grater then zero");
        }
        boolean changed = padding != this.mFlashButtonPaddingHorizontal;
        this.mFlashButtonPaddingHorizontal = padding;
        if (changed) {
            this.invalidateFlashButtonPadding();
        }
    }

    @Px
    public int getFlashButtonPaddingVertical() {
        return this.mFlashButtonPaddingVertical;
    }

    public void setFlashButtonPaddingVertical(@Px int padding) {
        if (padding < 0) {
            throw new IllegalArgumentException("Padding should be equal to or grater then zero");
        }
        boolean changed = padding != this.mFlashButtonPaddingVertical;
        this.mFlashButtonPaddingVertical = padding;
        if (changed) {
            this.invalidateFlashButtonPadding();
        }
    }

    @NonNull
    public Drawable getFlashButtonOnIcon() {
        return this.mFlashButtonOnIcon;
    }

    public void setFlashButtonOnIcon(@NonNull Drawable icon) {
        Objects.requireNonNull(icon);
        boolean changed = icon != this.mFlashButtonOnIcon;
        this.mFlashButtonOnIcon = icon;
        CodeScanner codeScanner = this.mCodeScanner;
        if (changed && codeScanner != null) {
            this.setFlashEnabled(codeScanner.isFlashEnabled());
        }
    }

    @NonNull
    public Drawable getFlashButtonOffIcon() {
        return this.mFlashButtonOffIcon;
    }

    public void setFlashButtonOffIcon(@NonNull Drawable icon) {
        Objects.requireNonNull(icon);
        boolean changed = icon != this.mFlashButtonOffIcon;
        this.mFlashButtonOffIcon = icon;
        CodeScanner codeScanner = this.mCodeScanner;
        if (changed && codeScanner != null) {
            this.setFlashEnabled(codeScanner.isFlashEnabled());
        }
    }

    @NonNull
    SurfaceView getPreviewView() {
        return this.mPreviewView;
    }

    @NonNull
    ViewFinderView getViewFinderView() {
        return this.mViewFinderView;
    }

    @Nullable
    Rect getFrameRect() {
        return this.mViewFinderView.getFrameRect();
    }

    void setPreviewSize(@Nullable Point previewSize) {
        this.mPreviewSize = previewSize;
        this.requestLayout();
    }

    void setSizeListener(@Nullable SizeListener sizeListener) {
        this.mSizeListener = sizeListener;
    }

    void setCodeScanner(@NonNull CodeScanner codeScanner) {
        if (this.mCodeScanner != null) {
            throw new IllegalStateException("Code scanner has already been set");
        }
        this.mCodeScanner = codeScanner;
        this.setAutoFocusEnabled(codeScanner.isAutoFocusEnabled());
        this.setFlashEnabled(codeScanner.isFlashEnabled());
    }

    void setAutoFocusEnabled(boolean enabled) {
        this.mAutoFocusButton.setImageDrawable(enabled ? this.mAutoFocusButtonOnIcon : this.mAutoFocusButtonOffIcon);
    }

    void setFlashEnabled(boolean enabled) {
        this.mFlashButton.setImageDrawable(enabled ? this.mFlashButtonOnIcon : this.mFlashButtonOffIcon);
    }

    private void layoutButton(View button, ButtonPosition position, int parentWidth, int parentHeight) {
        int width = button.getMeasuredWidth();
        int height = button.getMeasuredHeight();
        int layoutDirection = this.getLayoutDirection();
        switch (position) {
            case TOP_START: {
                if (layoutDirection == 1) {
                    button.layout(parentWidth - width, 0, parentWidth, height);
                    break;
                }
                button.layout(0, 0, width, height);
                break;
            }
            case TOP_END: {
                if (layoutDirection == 1) {
                    button.layout(0, 0, width, height);
                    break;
                }
                button.layout(parentWidth - width, 0, parentWidth, height);
                break;
            }
            case BOTTOM_START: {
                if (layoutDirection == 1) {
                    button.layout(parentWidth - width, parentHeight - height, parentWidth, parentHeight);
                    break;
                }
                button.layout(0, parentHeight - height, width, parentHeight);
                break;
            }
            case BOTTOM_END: {
                if (layoutDirection == 1) {
                    button.layout(0, parentHeight - height, width, parentHeight);
                    break;
                }
                button.layout(parentWidth - width, parentHeight - height, parentWidth, parentHeight);
            }
        }
    }

    private void invalidateAutoFocusButtonPadding() {
        int autoFocusButtonHorizontalPadding = this.mAutoFocusButtonPaddingHorizontal;
        int autoFocusButtonVerticalPadding = this.mAutoFocusButtonPaddingVertical;
        this.mAutoFocusButton.setPadding(autoFocusButtonHorizontalPadding, autoFocusButtonVerticalPadding, autoFocusButtonHorizontalPadding, autoFocusButtonVerticalPadding);
    }

    private void invalidateFlashButtonPadding() {
        int flashButtonHorizontalPadding = this.mFlashButtonPaddingHorizontal;
        int flashButtonVerticalPadding = this.mFlashButtonPaddingVertical;
        this.mFlashButton.setPadding(flashButtonHorizontalPadding, flashButtonVerticalPadding, flashButtonHorizontalPadding, flashButtonVerticalPadding);
    }

    @NonNull
    private static ButtonPosition buttonPositionFromAttr(int value) {
        switch (value) {
            case 1: {
                return ButtonPosition.TOP_END;
            }
            case 2: {
                return ButtonPosition.BOTTOM_START;
            }
            case 3: {
                return ButtonPosition.BOTTOM_END;
            }
        }
        return ButtonPosition.TOP_START;
    }

    private static int indexOfButtonPosition(@NonNull ButtonPosition value) {
        switch (value) {
            case TOP_END: {
                return 1;
            }
            case BOTTOM_START: {
                return 2;
            }
            case BOTTOM_END: {
                return 3;
            }
        }
        return 0;
    }

    private final class FlashClickListener
    implements View.OnClickListener {
        private FlashClickListener() {
        }

        public void onClick(View view) {
            CodeScanner scanner = CodeScannerView.this.mCodeScanner;
            if (scanner == null || !scanner.isFlashSupportedOrUnknown()) {
                return;
            }
            boolean enabled = !scanner.isFlashEnabled();
            scanner.setFlashEnabled(enabled);
            CodeScannerView.this.setFlashEnabled(enabled);
        }
    }

    private final class AutoFocusClickListener
    implements View.OnClickListener {
        private AutoFocusClickListener() {
        }

        public void onClick(View view) {
            CodeScanner scanner = CodeScannerView.this.mCodeScanner;
            if (scanner == null || !scanner.isAutoFocusSupportedOrUnknown()) {
                return;
            }
            boolean enabled = !scanner.isAutoFocusEnabled();
            scanner.setAutoFocusEnabled(enabled);
            CodeScannerView.this.setAutoFocusEnabled(enabled);
        }
    }

    public static final class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(@NonNull Context c, @Nullable AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(@NonNull ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    static interface SizeListener {
        public void onSizeChanged(int var1, int var2);
    }
}

