/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import com.budiyev.android.codescanner.Rect;

final class ViewFinderView
extends View {
    private final Paint mMaskPaint = new Paint(1);
    private final Paint mFramePaint;
    private final Path mPath;
    private Rect mFrameRect;
    private int mFrameCornersSize = 0;
    private int mFrameCornersRadius = 0;
    private float mFrameRatioWidth = 1.0f;
    private float mFrameRatioHeight = 1.0f;
    private float mFrameSize = 0.75f;
    private float mFrameVerticalBias = 0.5f;
    private boolean mMaskVisible = true;
    private boolean mFrameVisible = true;

    public ViewFinderView(@NonNull Context context) {
        super(context);
        this.mMaskPaint.setStyle(Paint.Style.FILL);
        this.mFramePaint = new Paint(1);
        this.mFramePaint.setStyle(Paint.Style.STROKE);
        Path path = new Path();
        path.setFillType(Path.FillType.EVEN_ODD);
        this.mPath = path;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.invalidateFrameRect(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.invalidateFrameRect(right - left, bottom - top);
    }

    protected void onDraw(@NonNull Canvas canvas) {
        Rect frame = this.mFrameRect;
        if (frame == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        float top = frame.getTop();
        float left = frame.getLeft();
        float right = frame.getRight();
        float bottom = frame.getBottom();
        float frameCornersSize = this.mFrameCornersSize;
        float frameCornersRadius = this.mFrameCornersRadius;
        boolean maskVisible = this.mMaskVisible;
        boolean frameVisible = this.mFrameVisible;
        Path path = this.mPath;
        if (frameCornersRadius > 0.0f) {
            float normalizedRadius = Math.min(frameCornersRadius, Math.max(frameCornersSize - 1.0f, 0.0f));
            if (maskVisible) {
                path.reset();
                path.moveTo(left, top + normalizedRadius);
                path.quadTo(left, top, left + normalizedRadius, top);
                path.lineTo(right - normalizedRadius, top);
                path.quadTo(right, top, right, top + normalizedRadius);
                path.lineTo(right, bottom - normalizedRadius);
                path.quadTo(right, bottom, right - normalizedRadius, bottom);
                path.lineTo(left + normalizedRadius, bottom);
                path.quadTo(left, bottom, left, bottom - normalizedRadius);
                path.lineTo(left, top + normalizedRadius);
                path.moveTo(0.0f, 0.0f);
                path.lineTo((float)width, 0.0f);
                path.lineTo((float)width, (float)height);
                path.lineTo(0.0f, (float)height);
                path.lineTo(0.0f, 0.0f);
                canvas.drawPath(path, this.mMaskPaint);
            }
            if (frameVisible) {
                path.reset();
                path.moveTo(left, top + frameCornersSize);
                path.lineTo(left, top + normalizedRadius);
                path.quadTo(left, top, left + normalizedRadius, top);
                path.lineTo(left + frameCornersSize, top);
                path.moveTo(right - frameCornersSize, top);
                path.lineTo(right - normalizedRadius, top);
                path.quadTo(right, top, right, top + normalizedRadius);
                path.lineTo(right, top + frameCornersSize);
                path.moveTo(right, bottom - frameCornersSize);
                path.lineTo(right, bottom - normalizedRadius);
                path.quadTo(right, bottom, right - normalizedRadius, bottom);
                path.lineTo(right - frameCornersSize, bottom);
                path.moveTo(left + frameCornersSize, bottom);
                path.lineTo(left + normalizedRadius, bottom);
                path.quadTo(left, bottom, left, bottom - normalizedRadius);
                path.lineTo(left, bottom - frameCornersSize);
                canvas.drawPath(path, this.mFramePaint);
            }
        } else {
            if (maskVisible) {
                path.reset();
                path.moveTo(left, top);
                path.lineTo(right, top);
                path.lineTo(right, bottom);
                path.lineTo(left, bottom);
                path.lineTo(left, top);
                path.moveTo(0.0f, 0.0f);
                path.lineTo((float)width, 0.0f);
                path.lineTo((float)width, (float)height);
                path.lineTo(0.0f, (float)height);
                path.lineTo(0.0f, 0.0f);
                canvas.drawPath(path, this.mMaskPaint);
            }
            if (frameVisible) {
                path.reset();
                path.moveTo(left, top + frameCornersSize);
                path.lineTo(left, top);
                path.lineTo(left + frameCornersSize, top);
                path.moveTo(right - frameCornersSize, top);
                path.lineTo(right, top);
                path.lineTo(right, top + frameCornersSize);
                path.moveTo(right, bottom - frameCornersSize);
                path.lineTo(right, bottom);
                path.lineTo(right - frameCornersSize, bottom);
                path.moveTo(left + frameCornersSize, bottom);
                path.lineTo(left, bottom);
                path.lineTo(left, bottom - frameCornersSize);
                canvas.drawPath(path, this.mFramePaint);
            }
        }
    }

    @Nullable
    Rect getFrameRect() {
        return this.mFrameRect;
    }

    void setFrameAspectRatio(@FloatRange(from=0.0, fromInclusive=false) float ratioWidth, @FloatRange(from=0.0, fromInclusive=false) float ratioHeight) {
        this.mFrameRatioWidth = ratioWidth;
        this.mFrameRatioHeight = ratioHeight;
        this.invalidateFrameRect();
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @FloatRange(from=0.0, fromInclusive=false)
    float getFrameAspectRatioWidth() {
        return this.mFrameRatioWidth;
    }

    void setFrameAspectRatioWidth(@FloatRange(from=0.0, fromInclusive=false) float ratioWidth) {
        this.mFrameRatioWidth = ratioWidth;
        this.invalidateFrameRect();
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @FloatRange(from=0.0, fromInclusive=false)
    float getFrameAspectRatioHeight() {
        return this.mFrameRatioHeight;
    }

    void setFrameAspectRatioHeight(@FloatRange(from=0.0, fromInclusive=false) float ratioHeight) {
        this.mFrameRatioHeight = ratioHeight;
        this.invalidateFrameRect();
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @ColorInt
    int getMaskColor() {
        return this.mMaskPaint.getColor();
    }

    void setMaskColor(@ColorInt int color) {
        this.mMaskPaint.setColor(color);
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    boolean isMaskVisible() {
        return this.mMaskVisible;
    }

    void setMaskVisible(boolean visible) {
        this.mMaskVisible = visible;
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @ColorInt
    int getFrameColor() {
        return this.mFramePaint.getColor();
    }

    void setFrameColor(@ColorInt int color) {
        this.mFramePaint.setColor(color);
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    boolean isFrameVisible() {
        return this.mFrameVisible;
    }

    void setFrameVisible(boolean visible) {
        this.mFrameVisible = visible;
    }

    @Px
    int getFrameThickness() {
        return (int)this.mFramePaint.getStrokeWidth();
    }

    void setFrameThickness(@Px int thickness) {
        this.mFramePaint.setStrokeWidth((float)thickness);
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    boolean isFrameCornersCapRounded() {
        return this.mFramePaint.getStrokeCap() == Paint.Cap.ROUND;
    }

    void setFrameCornersCapRounded(boolean rounded) {
        this.mFramePaint.setStrokeCap(rounded ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        this.invalidate();
    }

    @Px
    int getFrameCornersSize() {
        return this.mFrameCornersSize;
    }

    void setFrameCornersSize(@Px int size) {
        this.mFrameCornersSize = size;
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @Px
    int getFrameCornersRadius() {
        return this.mFrameCornersRadius;
    }

    void setFrameCornersRadius(@Px int radius) {
        this.mFrameCornersRadius = radius;
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @FloatRange(from=0.1, to=1.0)
    public float getFrameSize() {
        return this.mFrameSize;
    }

    void setFrameSize(@FloatRange(from=0.1, to=1.0) float size) {
        this.mFrameSize = size;
        this.invalidateFrameRect();
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    @FloatRange(from=0.0, to=1.0)
    public float getFrameVerticalBias() {
        return this.mFrameVerticalBias;
    }

    public void setFrameVerticalBias(@FloatRange(from=0.0, to=1.0) float bias) {
        this.mFrameVerticalBias = bias;
        this.invalidateFrameRect();
        if (this.isLaidOut()) {
            this.invalidate();
        }
    }

    private void invalidateFrameRect() {
        this.invalidateFrameRect(this.getWidth(), this.getHeight());
    }

    private void invalidateFrameRect(int width, int height) {
        if (width > 0 && height > 0) {
            int frameHeight;
            int frameWidth;
            float viewAR = (float)width / (float)height;
            float frameAR = this.mFrameRatioWidth / this.mFrameRatioHeight;
            float frameSize = this.mFrameSize;
            if (viewAR <= frameAR) {
                frameWidth = Math.round((float)width * frameSize);
                frameHeight = Math.round((float)frameWidth / frameAR);
            } else {
                frameHeight = Math.round((float)height * frameSize);
                frameWidth = Math.round((float)frameHeight * frameAR);
            }
            int frameLeft = (width - frameWidth) / 2;
            int frameTop = Math.round((float)(height - frameHeight) * this.mFrameVerticalBias);
            this.mFrameRect = new Rect(frameLeft, frameTop, frameLeft + frameWidth, frameTop + frameHeight);
        }
    }
}

