/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.circularprogressbar;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.budiyev.android.circularprogressbar.R;

public class CircularProgressBar
extends View {
    private static final float DEFAULT_MAXIMUM = 100.0f;
    private static final float DEFAULT_PROGRESS = 0.0f;
    private static final float DEFAULT_FOREGROUND_STROKE_WIDTH_DP = 3.0f;
    private static final float DEFAULT_BACKGROUND_STROKE_WIDTH_DP = 1.0f;
    private static final float DEFAULT_START_ANGLE = 270.0f;
    private static final float DEFAULT_INDETERMINATE_MINIMUM_ANGLE = 60.0f;
    private static final int DEFAULT_FOREGROUND_STROKE_COLOR = -16776961;
    private static final int DEFAULT_BACKGROUND_STROKE_COLOR = -16777216;
    private static final int DEFAULT_PROGRESS_ANIMATION_DURATION = 100;
    private static final int DEFAULT_INDETERMINATE_ROTATION_ANIMATION_DURATION = 1200;
    private static final int DEFAULT_INDETERMINATE_SWEEP_ANIMATION_DURATION = 600;
    private static final boolean DEFAULT_ANIMATE_PROGRESS = true;
    private static final boolean DEFAULT_DRAW_BACKGROUND_STROKE = true;
    private static final boolean DEFAULT_INDETERMINATE = false;
    private final Runnable mSweepRestartAction = new SweepRestartAction();
    private final RectF mDrawRect = new RectF();
    private final ValueAnimator mProgressAnimator = new ValueAnimator();
    private final ValueAnimator mIndeterminateStartAnimator = new ValueAnimator();
    private final ValueAnimator mIndeterminateSweepAnimator = new ValueAnimator();
    private final Paint mForegroundStrokePaint = new Paint(1);
    private final Paint mBackgroundStrokePaint = new Paint(1);
    private float mMaximum;
    private float mProgress;
    private float mStartAngle;
    private float mIndeterminateStartAngle;
    private float mIndeterminateSweepAngle;
    private float mIndeterminateOffsetAngle;
    private float mIndeterminateMinimumAngle;
    private boolean mIndeterminate;
    private boolean mAnimateProgress;
    private boolean mDrawBackgroundStroke;
    private boolean mIndeterminateGrowMode;
    private boolean mVisible;

    public CircularProgressBar(@NonNull Context context) {
        super(context);
        this.initialize(context, null, 0, 0);
    }

    public CircularProgressBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0, 0);
    }

    public CircularProgressBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr, 0);
    }

    @RequiresApi(value=21)
    public CircularProgressBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context, attrs, defStyleAttr, defStyleRes);
    }

    public boolean isIndeterminate() {
        return this.mIndeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.stopIndeterminateAnimations();
        this.mIndeterminate = indeterminate;
        this.invalidate();
        if (this.mVisible && indeterminate) {
            this.startIndeterminateAnimations();
        }
    }

    public float getProgress() {
        return this.mProgress;
    }

    public void setProgress(float progress) {
        if (this.mIndeterminate) {
            this.mProgress = progress;
        } else {
            this.stopProgressAnimation();
            if (this.mVisible && this.mAnimateProgress) {
                this.setProgressAnimated(progress);
            } else {
                this.setProgressInternal(progress);
            }
        }
    }

    public float getMaximum() {
        return this.mMaximum;
    }

    public void setMaximum(float maximum) {
        this.mMaximum = maximum;
        this.invalidate();
    }

    public void setStartAngle(@FloatRange(from=0.0, to=360.0) float angle) {
        this.mStartAngle = angle;
        this.invalidate();
    }

    public void setAnimateProgress(boolean animate) {
        this.mAnimateProgress = animate;
    }

    public void setIndeterminateMinimumAngle(@FloatRange(from=0.0, to=360.0) float angle) {
        this.stopIndeterminateAnimations();
        this.mIndeterminateMinimumAngle = angle;
        this.mIndeterminateSweepAnimator.setFloatValues(new float[]{360.0f - angle * 2.0f});
        this.invalidate();
        if (this.mVisible && this.mIndeterminate) {
            this.startIndeterminateAnimations();
        }
    }

    public void setIndeterminateRotationAnimationDuration(@IntRange(from=0L) long duration) {
        this.stopIndeterminateAnimations();
        this.mIndeterminateStartAnimator.setDuration(duration);
        this.invalidate();
        if (this.mVisible && this.mIndeterminate) {
            this.startIndeterminateAnimations();
        }
    }

    public void setIndeterminateSweepAnimationDuration(@IntRange(from=0L) long duration) {
        this.stopIndeterminateAnimations();
        this.mIndeterminateSweepAnimator.setDuration(duration);
        this.invalidate();
        if (this.mVisible && this.mIndeterminate) {
            this.startIndeterminateAnimations();
        }
    }

    public void setForegroundStrokeColor(@ColorInt int color) {
        this.mForegroundStrokePaint.setColor(color);
        this.invalidate();
    }

    public void setForegroundStrokeWidth(@FloatRange(from=0.0, to=3.4028234663852886E38) float width) {
        this.mForegroundStrokePaint.setStrokeWidth(width);
        this.invalidateDrawRect();
        this.invalidate();
    }

    public void setBackgroundStrokeColor(@ColorInt int color) {
        this.mForegroundStrokePaint.setColor(color);
        this.invalidate();
    }

    public void setBackgroundStrokeWidth(@FloatRange(from=0.0, to=3.4028234663852886E38) float width) {
        this.mBackgroundStrokePaint.setStrokeWidth(width);
        this.invalidateDrawRect();
        this.invalidate();
    }

    public void setDrawBackgroundStroke(boolean draw) {
        this.mDrawBackgroundStroke = draw;
        this.invalidateDrawRect();
        this.invalidate();
    }

    public void onVisibilityAggregated(boolean visible) {
        super.onVisibilityAggregated(visible);
        this.mVisible = visible;
        if (this.mIndeterminate) {
            if (visible) {
                this.startIndeterminateAnimations();
            } else {
                this.stopIndeterminateAnimations();
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        float sweep;
        float start;
        if (this.mDrawBackgroundStroke) {
            canvas.drawOval(this.mDrawRect, this.mBackgroundStrokePaint);
        }
        if (this.mIndeterminate) {
            float startAngle = this.mIndeterminateStartAngle;
            float sweepAngle = this.mIndeterminateSweepAngle;
            float offsetAngle = this.mIndeterminateOffsetAngle;
            float minimumAngle = this.mIndeterminateMinimumAngle;
            if (this.mIndeterminateGrowMode) {
                start = startAngle - offsetAngle;
                sweep = sweepAngle + minimumAngle;
            } else {
                start = startAngle + sweepAngle - offsetAngle;
                sweep = 360.0f - sweepAngle - minimumAngle;
            }
        } else {
            float maximum = this.mMaximum;
            float progress = this.mProgress;
            start = this.mStartAngle;
            sweep = Math.abs(progress) < Math.abs(maximum) ? progress / maximum * 360.0f : 360.0f;
        }
        canvas.drawArc(this.mDrawRect, start, sweep, false, this.mForegroundStrokePaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = CircularProgressBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = CircularProgressBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        this.invalidateDrawRect(width, height);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        this.invalidateDrawRect(width, height);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mVisible = true;
        if (this.mIndeterminate) {
            this.startIndeterminateAnimations();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.stopIndeterminateAnimations();
        this.stopProgressAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(@NonNull Context context, @Nullable AttributeSet attributeSet, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.mForegroundStrokePaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundStrokePaint.setStyle(Paint.Style.STROKE);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (attributeSet == null) {
            this.mMaximum = 100.0f;
            this.mProgress = 0.0f;
            this.mStartAngle = 270.0f;
            this.mIndeterminateMinimumAngle = 60.0f;
            this.mProgressAnimator.setDuration(100L);
            this.mIndeterminate = false;
            this.mAnimateProgress = true;
            this.mDrawBackgroundStroke = true;
            this.mForegroundStrokePaint.setColor(-16776961);
            this.mForegroundStrokePaint.setStrokeWidth((float)Math.round(3.0f * displayMetrics.density));
            this.mBackgroundStrokePaint.setColor(-16777216);
            this.mBackgroundStrokePaint.setStrokeWidth((float)Math.round(1.0f * displayMetrics.density));
            this.mIndeterminateStartAnimator.setDuration(1200L);
            this.mIndeterminateSweepAnimator.setDuration(600L);
        } else {
            TypedArray attributes = null;
            try {
                attributes = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.CircularProgressBar, defStyleAttr, defStyleRes);
                this.mMaximum = attributes.getFloat(R.styleable.CircularProgressBar_maximum, 100.0f);
                this.mProgress = attributes.getFloat(R.styleable.CircularProgressBar_progress, 0.0f);
                this.mStartAngle = attributes.getFloat(R.styleable.CircularProgressBar_startAngle, 270.0f);
                this.mIndeterminateMinimumAngle = attributes.getFloat(R.styleable.CircularProgressBar_indeterminateMinimumAngle, 60.0f);
                this.mProgressAnimator.setDuration((long)attributes.getInteger(R.styleable.CircularProgressBar_progressAnimationDuration, 100));
                this.mIndeterminateStartAnimator.setDuration((long)attributes.getInteger(R.styleable.CircularProgressBar_indeterminateRotationAnimationDuration, 1200));
                this.mIndeterminateSweepAnimator.setDuration((long)attributes.getInteger(R.styleable.CircularProgressBar_indeterminateSweepAnimationDuration, 600));
                this.mForegroundStrokePaint.setColor(attributes.getColor(R.styleable.CircularProgressBar_foregroundStrokeColor, -16776961));
                this.mBackgroundStrokePaint.setColor(attributes.getColor(R.styleable.CircularProgressBar_backgroundStrokeColor, -16777216));
                this.mForegroundStrokePaint.setStrokeWidth(attributes.getDimension(R.styleable.CircularProgressBar_foregroundStrokeWidth, (float)Math.round(3.0f * displayMetrics.density)));
                this.mBackgroundStrokePaint.setStrokeWidth(attributes.getDimension(R.styleable.CircularProgressBar_backgroundStrokeWidth, (float)Math.round(1.0f * displayMetrics.density)));
                this.mAnimateProgress = attributes.getBoolean(R.styleable.CircularProgressBar_animateProgress, true);
                this.mDrawBackgroundStroke = attributes.getBoolean(R.styleable.CircularProgressBar_drawBackgroundStroke, true);
                this.mIndeterminate = attributes.getBoolean(R.styleable.CircularProgressBar_indeterminate, false);
            }
            finally {
                if (attributes != null) {
                    attributes.recycle();
                }
            }
        }
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mProgressAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new ProgressUpdateListener());
        this.mIndeterminateStartAnimator.setFloatValues(new float[]{360.0f});
        this.mIndeterminateStartAnimator.setRepeatMode(1);
        this.mIndeterminateStartAnimator.setRepeatCount(-1);
        this.mIndeterminateStartAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mIndeterminateStartAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new StartUpdateListener());
        this.mIndeterminateSweepAnimator.setFloatValues(new float[]{360.0f - this.mIndeterminateMinimumAngle * 2.0f});
        this.mIndeterminateSweepAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mIndeterminateSweepAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new SweepUpdateListener());
        this.mIndeterminateSweepAnimator.addListener((Animator.AnimatorListener)new SweepAnimatorListener());
    }

    private void invalidateDrawRect() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            this.invalidateDrawRect(width, height);
        }
    }

    private void invalidateDrawRect(int width, int height) {
        float thickness = this.mDrawBackgroundStroke ? Math.max(this.mForegroundStrokePaint.getStrokeWidth(), this.mBackgroundStrokePaint.getStrokeWidth()) : this.mForegroundStrokePaint.getStrokeWidth();
        if (width > height) {
            float offset = (float)(width - height) / 2.0f;
            this.mDrawRect.set(offset + thickness / 2.0f + 1.0f, thickness / 2.0f + 1.0f, (float)width - offset - thickness / 2.0f - 1.0f, (float)height - thickness / 2.0f - 1.0f);
        } else if (width < height) {
            float offset = (float)(height - width) / 2.0f;
            this.mDrawRect.set(thickness / 2.0f + 1.0f, offset + thickness / 2.0f + 1.0f, (float)width - thickness / 2.0f - 1.0f, (float)height - offset - thickness / 2.0f - 1.0f);
        } else {
            this.mDrawRect.set(thickness / 2.0f + 1.0f, thickness / 2.0f + 1.0f, (float)width - thickness / 2.0f - 1.0f, (float)height - thickness / 2.0f - 1.0f);
        }
    }

    private void setProgressInternal(float progress) {
        this.mProgress = progress;
        this.invalidate();
    }

    private void setProgressAnimated(float progress) {
        this.mProgressAnimator.setFloatValues(new float[]{this.mProgress, progress});
        this.mProgressAnimator.start();
    }

    private void stopProgressAnimation() {
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
        }
    }

    private void stopIndeterminateAnimations() {
        if (this.mIndeterminateStartAnimator.isRunning()) {
            this.mIndeterminateStartAnimator.cancel();
        }
        if (this.mIndeterminateSweepAnimator.isRunning()) {
            this.mIndeterminateSweepAnimator.cancel();
        }
    }

    private void startIndeterminateAnimations() {
        if (!this.mIndeterminateStartAnimator.isRunning()) {
            this.mIndeterminateStartAnimator.start();
        }
        if (!this.mIndeterminateSweepAnimator.isRunning()) {
            this.mIndeterminateSweepAnimator.start();
        }
    }

    private final class SweepRestartAction
    implements Runnable {
        private SweepRestartAction() {
        }

        @Override
        public void run() {
            CircularProgressBar.this.mIndeterminateGrowMode = !CircularProgressBar.this.mIndeterminateGrowMode;
            if (CircularProgressBar.this.mIndeterminateGrowMode) {
                CircularProgressBar.this.mIndeterminateOffsetAngle = (CircularProgressBar.this.mIndeterminateOffsetAngle + CircularProgressBar.this.mIndeterminateMinimumAngle * 2.0f) % 360.0f;
            }
            if (CircularProgressBar.this.mIndeterminateSweepAnimator.isRunning()) {
                CircularProgressBar.this.mIndeterminateSweepAnimator.cancel();
            }
            CircularProgressBar.this.mIndeterminateSweepAnimator.start();
        }
    }

    private final class SweepAnimatorListener
    implements Animator.AnimatorListener {
        private boolean mCancelled;

        private SweepAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
            this.mCancelled = false;
        }

        public void onAnimationEnd(Animator animation) {
            if (!this.mCancelled) {
                CircularProgressBar.this.post(CircularProgressBar.this.mSweepRestartAction);
            }
        }

        public void onAnimationCancel(Animator animation) {
            this.mCancelled = true;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    private final class SweepUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private SweepUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            CircularProgressBar.this.mIndeterminateSweepAngle = ((Float)animation.getAnimatedValue()).floatValue();
        }
    }

    private final class StartUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private StartUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            CircularProgressBar.this.mIndeterminateStartAngle = ((Float)animation.getAnimatedValue()).floatValue();
            CircularProgressBar.this.invalidate();
        }
    }

    private final class ProgressUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private ProgressUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            CircularProgressBar.this.setProgressInternal(((Float)animation.getAnimatedValue()).floatValue());
        }
    }
}

