/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.autoconfigure;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusLanguageDriverAutoConfiguration;
import com.baomidou.mybatisplus.core.injector.AbstractSqlInjector;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.github.yulichang.autoconfigure.MybatisPlusJoinProperties;
import com.github.yulichang.autoconfigure.conditional.MPJSqlInjectorCondition;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.config.MPJInterceptorConfig;
import com.github.yulichang.config.MappingConfig;
import com.github.yulichang.config.enums.LogicDelTypeEnum;
import com.github.yulichang.injector.MPJSqlInjector;
import com.github.yulichang.interceptor.MPJInterceptor;
import com.github.yulichang.toolkit.SpringContentUtils;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@EnableConfigurationProperties(value={MybatisPlusJoinProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, MybatisPlusLanguageDriverAutoConfiguration.class})
public class MybatisPlusJoinAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MybatisPlusJoinAutoConfiguration.class);
    private final MybatisPlusJoinProperties properties;

    public MybatisPlusJoinAutoConfiguration(MybatisPlusJoinProperties properties) {
        this.properties = properties;
        ConfigProperties.subTableLogic = properties.getSubTableLogic();
        ConfigProperties.msCache = properties.isMsCache();
        ConfigProperties.tableAlias = properties.getTableAlias();
        ConfigProperties.joinPrefix = properties.getJoinPrefix();
        ConfigProperties.logicDelType = "where".equalsIgnoreCase(properties.getLogicDelType()) ? LogicDelTypeEnum.WHERE : LogicDelTypeEnum.ON;
    }

    @Bean
    public MPJInterceptor mpjInterceptor() {
        return new MPJInterceptor();
    }

    @Bean
    @ConditionalOnBean(value={SqlSessionFactory.class})
    public MPJInterceptorConfig mpjInterceptorConfig(List<SqlSessionFactory> sqlSessionFactoryList) {
        return new MPJInterceptorConfig(sqlSessionFactoryList, this.properties.getBanner());
    }

    @Bean
    @Primary
    @MPJSqlInjectorCondition
    @Order(value=-2147483648)
    @ConditionalOnBean(value={ISqlInjector.class})
    public MPJSqlInjector mpjSqlInjector(AbstractSqlInjector sqlInjector) {
        logger.info("MPJSqlInjector init");
        return new MPJSqlInjector(sqlInjector);
    }

    @Bean
    @Order(value=-2147483648)
    @ConditionalOnMissingBean(value={ISqlInjector.class})
    public MPJSqlInjector mpjSqlInjectorOnMiss() {
        logger.info("MPJSqlInjector init");
        return new MPJSqlInjector();
    }

    @Bean
    @Order(value=-2147483648)
    public SpringContentUtils mpjSpringContent(MPJSpringContext springContext) {
        return new SpringContentUtils((SpringContentUtils.SpringContext)springContext);
    }

    @Configuration
    @ConditionalOnBean(value={SqlSessionFactory.class})
    public static class MPJSpringContext
    implements SpringContentUtils.SpringContext,
    ApplicationContextAware {
        private ApplicationContext applicationContext;

        public <T> T getBean(Class<T> clazz) {
            return (T)this.applicationContext.getBean(clazz);
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }
    }

    @Configuration
    @Order(value=-2147483648)
    @ConditionalOnBean(value={SqlSessionFactory.class})
    public static class MPJMappingConfig
    implements ApplicationListener<ApplicationReadyEvent> {
        public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
            new MappingConfig();
        }
    }
}

