/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.adapter.jsqlparser.v46;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Collection;
import java.util.function.Consumer;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;

public class JSqlParserHelperV46 {
    public static void parserColum(String alias, String from, String selectSql, Consumer<String> columConsumer) {
        try {
            boolean parser = false;
            Statement statement = CCJSqlParserUtil.parse((String)String.format("SELECT %s FROM table %s %s", selectSql, alias, from));
            if (statement instanceof Select) {
                PlainSelect plainSelect;
                Select select = (Select)statement;
                SelectBody selectBody = select.getSelectBody();
                if (selectBody instanceof PlainSelect && CollectionUtils.isNotEmpty((Collection)(plainSelect = (PlainSelect)selectBody).getSelectItems())) {
                    for (SelectItem item : plainSelect.getSelectItems()) {
                        if (!(item instanceof SelectExpressionItem)) continue;
                        SelectExpressionItem selectExpressionItem = (SelectExpressionItem)item;
                        String col = null == selectExpressionItem.getAlias() ? (selectExpressionItem.getExpression() instanceof Column ? ((Column)selectExpressionItem.getExpression()).getColumnName() : selectExpressionItem.getExpression().toString()) : selectExpressionItem.getAlias().getName();
                        if (!StringUtils.isNotBlank((CharSequence)col)) continue;
                        columConsumer.accept(StringUtils.getTargetColumn((String)col));
                    }
                    parser = true;
                }
                if (!parser) {
                    throw ExceptionUtils.mpe((String)"JSqlParser parser error <%s>", (Object[])new Object[]{selectSql});
                }
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

