/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.ioc.proxy;

import com.github.youyinnn.youdbutils.YouDbManager;
import com.github.youyinnn.youdbutils.druid.ThreadLocalPropContainer;
import com.github.youyinnn.youdbutils.ioc.annotations.Transaction;
import com.github.youyinnn.youdbutils.ioc.annotations.YouService;
import com.github.youyinnn.youwebutils.third.Log4j2Helper;
import java.lang.reflect.Method;
import java.sql.Connection;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.logging.log4j.Logger;

public class TransactionInterceptor
implements MethodInterceptor {
    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        Logger connectionLog = Log4j2Helper.getLogger((String)"$db_connection");
        YouService service = o.getClass().getAnnotation(YouService.class);
        String dataSourceName = service.dataSourceName();
        YouDbManager.checkDataSourceName(dataSourceName);
        boolean embeddedLogEnable = YouDbManager.isYouDruidLogEnable(dataSourceName);
        String transactionRootServiceMethodName = ThreadLocalPropContainer.getTransactionRootServiceMethodName();
        long callNano = System.nanoTime();
        if (transactionRootServiceMethodName == null) {
            transactionRootServiceMethodName = method.getName() + callNano;
            ThreadLocalPropContainer.bindTransactionRootServiceMethodName(transactionRootServiceMethodName);
        }
        Connection conn = ThreadLocalPropContainer.getThreadConnection(dataSourceName);
        if (embeddedLogEnable) {
            connectionLog.info("\u4e1a\u52a1\u8fde\u63a5\u83b7\u53d6:" + conn.toString().split("@")[1] + ", \u6240\u5c5e\u4e1a\u52a1:{}, \u8c03\u7528\u65b9\u6cd5{}.", (Object)ThreadLocalPropContainer.getTransactionRootServiceMethodName(), (Object)method.getName());
        }
        conn.setAutoCommit(false);
        Transaction transactionA = method.getAnnotation(Transaction.class) != null ? method.getAnnotation(Transaction.class) : method.getDeclaringClass().getAnnotation(Transaction.class);
        boolean allowNoneffectiveUpdate = transactionA == null || transactionA.allowNoneffectiveUpdate();
        ThreadLocalPropContainer.setNoneffectiveUpdateFlag(allowNoneffectiveUpdate);
        Object result = methodProxy.invokeSuper(o, objects);
        if (ThreadLocalPropContainer.getRollbackFlag().booleanValue()) {
            ThreadLocalPropContainer.setRollbackFlagFalse();
            conn.rollback();
        }
        conn.commit();
        if (transactionRootServiceMethodName.equalsIgnoreCase(method.getName() + callNano)) {
            if (embeddedLogEnable) {
                connectionLog.info("\u4e1a\u52a1\u8fde\u63a5\u91ca\u653e:" + conn.toString().split("@")[1] + ", \u6240\u5c5e\u4e1a\u52a1:{}, \u8c03\u7528\u65b9\u6cd5{}.", (Object)ThreadLocalPropContainer.getTransactionRootServiceMethodName(), (Object)method.getName());
            }
            ThreadLocalPropContainer.removeAllThreadProp();
            ThreadLocalPropContainer.release(null, null, conn);
        }
        return result;
    }
}

